/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.mbeans;

import com.google.common.cache.CacheStats;
import com.xebialabs.xlrelease.service.ReportServiceCache;
import com.xebialabs.xlrelease.service.UserProfilesService;
import com.xebialabs.xlrelease.userdata.UserDataProvider;
import com.xebialabs.xlrelease.userdata.UserDataProviderCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.guava.GuavaCache;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@Component
@ManagedResource(objectName="com.xebialabs.xlrelease.settings:name=CacheControl", description="Cache control")
public class CacheControl {
    private UserProfilesService userProfilesService;
    private UserDataProvider userDataProvider;
    private ReportServiceCache reportServiceCache;
    private List<? extends CacheManager> cacheManagers = Collections.emptyList();

    @Autowired
    public CacheControl(UserProfilesService userProfilesService, UserDataProvider userDataProvider, ReportServiceCache reportServiceCache) {
        this.userProfilesService = userProfilesService;
        this.userDataProvider = userDataProvider;
        this.reportServiceCache = reportServiceCache;
    }

    @Autowired(required=false)
    public void setCacheManagers(List<? extends CacheManager> cacheManagers) {
        this.cacheManagers = cacheManagers;
    }

    @ManagedOperation(description="Clear user profiles cache")
    public void clearUserProfilesCache() {
        this.userProfilesService.clearCache();
    }

    @ManagedOperation(description="Clear user data cache")
    public void clearUserDataCache() {
        if (this.userDataProvider instanceof UserDataProviderCache) {
            ((UserDataProviderCache)this.userDataProvider).clearCache();
        }
    }

    @ManagedOperation(description="Clear reports cache")
    public void clearReportsCache() {
        this.reportServiceCache.clearCache();
    }

    @ManagedOperation(description="List caches")
    public List<String> listCaches() {
        return this.cacheManagers.stream().flatMap(manager -> manager.getCacheNames().stream()).collect(Collectors.toList());
    }

    @ManagedOperation(description="Clear named cache")
    public void clearCache(String cacheName) {
        this.cacheManagers.stream().forEach(manager -> {
            Cache cache = manager.getCache(cacheName);
            if (null != cache) {
                cache.clear();
            }
        });
    }

    @ManagedOperation(description="Fetch named cache statistics")
    public List<HashMap<String, String>> cacheStats(String cacheName) {
        return this.cacheManagers.stream().map(manager -> {
            Cache cache;
            HashMap<String, String> stats = new HashMap<String, String>();
            if (manager.getCacheNames().contains(cacheName) && (cache = manager.getCache(cacheName)) instanceof GuavaCache) {
                GuavaCache guavaCache = (GuavaCache)cache;
                CacheStats guavaCacheStats = guavaCache.getNativeCache().stats();
                stats.put("averageLoadPenalty", String.valueOf(guavaCacheStats.averageLoadPenalty()));
                stats.put("evictionCount", String.valueOf(guavaCacheStats.evictionCount()));
                stats.put("hitCount", String.valueOf(guavaCacheStats.hitCount()));
                stats.put("hitRate", String.valueOf(guavaCacheStats.hitRate()));
                stats.put("requestCount", String.valueOf(guavaCacheStats.requestCount()));
            }
            return stats;
        }).collect(Collectors.toList());
    }
}

