/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlplatform.repository.AdvancedRepositoryService;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Dependencies;
import com.xebialabs.xlrelease.repository.DependencyUpdateCommand;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PlanItemExistsQuery;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand$;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.TaskBackup;
import com.xebialabs.xlrelease.repository.TaskGetCommand;
import com.xebialabs.xlrelease.repository.XlrQueries;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.service.DependencyArchivingStrategy;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.DependencyCollectingStrategy;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u0001\u0003\u0001-\u0011\u0011\u0003R3qK:$WM\\2z'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011!\u0003=me\u0016dW-Y:f\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001aE\u0003\u0001\u0019I1\u0012\u0004\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011!CU3mK\u0006\u001cX\r\u0016:fK\n+\u0018\u000e\u001c3feB\u00111cF\u0005\u00031\t\u0011A\u0004R3qK:$WM\\2z\u0007\u0006tG-\u001b3bi\u0016\u001cu\u000e\u001c7fGR|'\u000f\u0005\u0002\u001b?5\t1D\u0003\u0002\u001d;\u0005)1\u000f\u001c45U*\ta$\u0001\u0005he&T(\u0010\\3e\u0013\t\u00013DA\u0004M_\u001e<\u0017N\\4\t\u0011\t\u0002!Q1A\u0005\u0002\r\n!B]3q_NLGo\u001c:z+\u0005!\u0003CA\u0013(\u001b\u00051#B\u0001\u0012\u0005\u0013\tAcEA\u0007YYJ\u0014V\r]8tSR|'/\u001f\u0005\tU\u0001\u0011\t\u0011)A\u0005I\u0005Y!/\u001a9pg&$xN]=!\u0011!a\u0003A!b\u0001\n\u0003i\u0013aB9vKJLWm]\u000b\u0002]A\u0011QeL\u0005\u0003a\u0019\u0012!\u0002\u00177s#V,'/[3t\u0011!\u0011\u0004A!A!\u0002\u0013q\u0013\u0001C9vKJLWm\u001d\u0011\t\u0011Q\u0002!Q1A\u0005\u0002U\n\u0001B]3mK\u0006\u001cXm]\u000b\u0002mA\u0011QeN\u0005\u0003q\u0019\u0012\u0001BU3mK\u0006\u001cXm\u001d\u0005\tu\u0001\u0011\t\u0011)A\u0005m\u0005I!/\u001a7fCN,7\u000f\t\u0005\ty\u0001\u0011)\u0019!C\u0001{\u0005aA-\u001a9f]\u0012,gnY5fgV\ta\b\u0005\u0002&\u007f%\u0011\u0001I\n\u0002\r\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005}\u0005iA-\u001a9f]\u0012,gnY5fg\u0002B\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t!R\u0001\u001aC\u00124\u0018M\\2fIJ+\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW-F\u0001G!\t95*D\u0001I\u0015\t\u0011\u0013J\u0003\u0002K\r\u0005Q\u0001\u0010\u001c9mCR4wN]7\n\u00051C%!G!em\u0006t7-\u001a3SKB|7/\u001b;pef\u001cVM\u001d<jG\u0016D\u0001B\u0014\u0001\u0003\u0002\u0003\u0006IAR\u0001\u001bC\u00124\u0018M\\2fIJ+\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW\r\t\u0005\t!\u0002\u0011)\u0019!C\u0001#\u0006aB-\u001a9f]\u0012,gnY=D_2dWm\u0019;j]\u001e\u001cFO]1uK\u001eLX#\u0001*\u0011\u0005M\u0019\u0016B\u0001+\u0003\u0005q!U\r]3oI\u0016t7-_\"pY2,7\r^5oON#(/\u0019;fOfD\u0001B\u0016\u0001\u0003\u0002\u0003\u0006IAU\u0001\u001eI\u0016\u0004XM\u001c3f]\u000eL8i\u001c7mK\u000e$\u0018N\\4TiJ\fG/Z4zA!A\u0001\f\u0001BC\u0002\u0013\u0005\u0011,A\u000eeKB,g\u000eZ3oGf\f%o\u00195jm&twm\u0015;sCR,w-_\u000b\u00025B\u00111cW\u0005\u00039\n\u00111\u0004R3qK:$WM\\2z\u0003J\u001c\u0007.\u001b<j]\u001e\u001cFO]1uK\u001eL\b\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\u00029\u0011,\u0007/\u001a8eK:\u001c\u00170\u0011:dQ&4\u0018N\\4TiJ\fG/Z4zA!A\u0001\r\u0001BC\u0002\u0013\u0005\u0011-\u0001\u0005fm\u0016tGOQ;t+\u0005\u0011\u0007CA2g\u001b\u0005!'BA3\u0005\u0003\u0019)g/\u001a8ug&\u0011q\r\u001a\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\b\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00022\u0002\u0013\u00154XM\u001c;CkN\u0004\u0003\u0002C6\u0001\u0005\u000b\u0007I\u0011\u00017\u0002\u0015Q\f7o\u001b\"bG.,\b/F\u0001n!\t)c.\u0003\u0002pM\tQA+Y:l\u0005\u0006\u001c7.\u001e9\t\u0011E\u0004!\u0011!Q\u0001\n5\f1\u0002^1tW\n\u000b7m[;qA!)1\u000f\u0001C\u0001i\u00061A(\u001b8jiz\"\"\"\u001e<xqfT8\u0010`?\u007f!\t\u0019\u0002\u0001C\u0003#e\u0002\u0007A\u0005C\u0003-e\u0002\u0007a\u0006C\u00035e\u0002\u0007a\u0007C\u0003=e\u0002\u0007a\bC\u0003Ee\u0002\u0007a\tC\u0003Qe\u0002\u0007!\u000bC\u0003Ye\u0002\u0007!\fC\u0003ae\u0002\u0007!\rC\u0003le\u0002\u0007Q\u000eK\u0002s\u0003\u0003\u0001B!a\u0001\u0002\u001a5\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0006b]:|G/\u0019;j_:TA!a\u0003\u0002\u000e\u00059a-Y2u_JL(\u0002BA\b\u0003#\tQAY3b]NTA!a\u0005\u0002\u0016\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002\u0018\u0005\u0019qN]4\n\t\u0005m\u0011Q\u0001\u0002\n\u0003V$xn^5sK\u0012D\u0011\"a\b\u0001\u0005\u0004%\t!!\t\u00021\u0005\u001cG/\u001b<f\t\u0016\u0004XM\u001c3f]\u000eL8\u000b^1ukN,7/\u0006\u0002\u0002$A1\u0011QEA\u001b\u0003wqA!a\n\u000229!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.)\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0007\u0005Mb\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0012\u0011\b\u0002\u0004'\u0016\f(bAA\u001a\u001dA!\u0011QHA#\u001d\u0011\ty$!\u0011\u0011\u0007\u0005%b\"C\u0002\u0002D9\ta\u0001\u0015:fI\u00164\u0017\u0002BA$\u0003\u0013\u0012aa\u0015;sS:<'bAA\"\u001d!A\u0011Q\n\u0001!\u0002\u0013\t\u0019#A\rbGRLg/\u001a#fa\u0016tG-\u001a8dsN#\u0018\r^;tKN\u0004\u0003bBA)\u0001\u0011\u0005\u00111K\u0001\u0016O\u0016$8i\\7qY\u0016$\u0018M\u00197f\u000f\u0006$X-\u00133t)\u0011\t)&!\u001a\u0011\r\u0005]\u0013\u0011MA\u001e\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013\u0001B;uS2T!!a\u0018\u0002\t)\fg/Y\u0005\u0005\u0003G\nIF\u0001\u0006D_2dWm\u0019;j_:D\u0001\"a\u001a\u0002P\u0001\u0007\u0011\u0011N\u0001\bi\u0006\u0014x-\u001a;t!\u0019\t9&!\u0019\u0002lA!\u0011QNA:\u001b\t\tyGC\u0002\u0002r\u0011\ta\u0001Z8nC&t\u0017\u0002BA;\u0003_\u0012\u0001\u0002\u00157b]&#X-\u001c\u0005\b\u0003s\u0002A\u0011AA>\u0003e1\u0017N\u001c3BGRLg/Z%oG>l\u0017N\\4HCR,\u0017\nZ:\u0015\t\u0005u\u00141\u0011\t\u0007\u0003/\ny(a\u000f\n\t\u0005\u0005\u0015\u0011\f\u0002\u0005\u0019&\u001cH\u000f\u0003\u0005\u0002\u0006\u0006]\u0004\u0019AA\u001e\u0003!\u0001\u0018M]3oi&#\u0007bBAE\u0001\u0011\u0005\u00111R\u0001\u0013O\u0016$h)Y5mC\ndWmR1uK&#7\u000f\u0006\u0003\u0002V\u00055\u0005\u0002CAH\u0003\u000f\u0003\r!!\u001b\u0002\u001d\u0005\u0014wN\u001d;fIR\u000b'oZ3ug\"9\u00111\u0013\u0001\u0005\u0002\u0005U\u0015\u0001\b4j]\u0012\fE\u000e\\%oG>l\u0017N\\4EKB,g\u000eZ3oGfLEm\u001d\u000b\u0005\u0003{\n9\n\u0003\u0005\u0002\u001a\u0006E\u0005\u0019AA6\u0003!\u0001H.\u00198Ji\u0016l\u0007bBAO\u0001\u0011\u0005\u0011qT\u0001$e\u0016\u0004H.Y2f\u0003J\u001c\u0007.\u001b<fI&s7m\\7j]\u001e$U\r]3oI\u0016t7-[3t)\u0019\t\t+a*\u0002,B\u0019Q\"a)\n\u0007\u0005\u0015fB\u0001\u0003V]&$\b\u0002CAU\u00037\u0003\r!a\u001b\u0002\u0013\u0011,\u0007/\u001a8eK:$\b\u0002CAW\u00037\u0003\r!a\u001b\u0002\u0017I,\u0007\u000f\\1dK6,g\u000e\u001e\u0005\b\u0003c\u0003A\u0011AAZ\u0003y\t'o\u00195jm\u0016\fE\u000e\\%oG>l\u0017N\\4EKB,g\u000eZ3oG&,7\u000f\u0006\u0003\u0002\"\u0006U\u0006\u0002CA\\\u0003_\u0003\r!a\u000f\u0002\u0013I,G.Z1tK&#\u0007bBA^\u0001\u0011\u0005\u0011QX\u0001\u001fCJ\u001c\u0007.\u001b<f\u00032dw*\u001e;h_&tw\rR3qK:$WM\\2jKN$B!!)\u0002@\"A\u0011\u0011YA]\u0001\u0004\t\u0019-A\u0004sK2,\u0017m]3\u0011\t\u00055\u0014QY\u0005\u0005\u0003\u000f\fyGA\u0004SK2,\u0017m]3\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\u0006Yb-\u001b8e\u0003\u000e$\u0018N^3PkR<w.\u001b8h)\u0006\u0014x-\u001a;JIN$B!! \u0002P\"A\u0011qWAe\u0001\u0004\tY\u0004C\u0004\u0002T\u0002!\t!!6\u0002\u001d\u001d,GOU3mK\u0006\u001cX\r\u0016:fKR!\u0011q[Ar!\u0011\tI.a8\u000e\u0005\u0005m'bAAo\t\u0005)a/[3xg&!\u0011\u0011]An\u0005-\u0011V\r\\3bg\u0016$&/Z3\t\u0011\u0005]\u0016\u0011\u001ba\u0001\u0003wAq!a:\u0001\t\u0003\tI/A\u000eva\u0012\fG/Z$bi\u0016\u0014VMZ3sK:\u001c\u0017N\\4QQ\u0006\u001cXm\u001d\u000b\u0007\u0003C\u000bY/a<\t\u0011\u00055\u0018Q\u001da\u0001\u0003w\taaZ1uK&#\u0007\u0002CAy\u0003K\u0004\r!a=\u0002!=\u0014\u0018nZ5o)>\u0014Vm\u001d;pe\u0016$\u0007\u0003CA,\u0003k\fY'a\u001b\n\t\u0005]\u0018\u0011\f\u0002\u0004\u001b\u0006\u0004\bbBA~\u0001\u0011E\u0011Q`\u0001\u001eM&tG-\u00138Qe><'/Z:t\u0013:\u001cw.\\5oO\u001e\u000bG/Z%egR!\u00111EA\u0000\u0011!\u0011\t!!?A\u0002\u0005\r\u0012!\u0003;be\u001e,G/\u00133t\u0011\u001d\u0011)\u0001\u0001C\t\u0005\u000f\t!\"[:UK6\u0004H.\u0019;f)\u0011\u0011IAa\u0004\u0011\u00075\u0011Y!C\u0002\u0003\u000e9\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0003\u0012\t\r\u0001\u0019AA\u001e\u00031!W\r]3oI\u0016t7-_%eQ\r\u0001!Q\u0003\t\u0005\u0005/\u0011i\"\u0004\u0002\u0003\u001a)!!1DA\t\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005?\u0011IBA\u0004TKJ4\u0018nY3")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private final XlrRepository repository;
    private final XlrQueries queries;
    private final Releases releases;
    private final Dependencies dependencies;
    private final AdvancedRepositoryService advancedRepositoryService;
    private final DependencyCollectingStrategy dependencyCollectingStrategy;
    private final DependencyArchivingStrategy dependencyArchivingStrategy;
    private final XLReleaseEventBus eventBus;
    private final TaskBackup taskBackup;
    private final Seq<String> activeDependencyStatuses;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XlrRepository repository() {
        return this.repository;
    }

    public XlrQueries queries() {
        return this.queries;
    }

    @Override
    public Releases releases() {
        return this.releases;
    }

    @Override
    public Dependencies dependencies() {
        return this.dependencies;
    }

    @Override
    public AdvancedRepositoryService advancedRepositoryService() {
        return this.advancedRepositoryService;
    }

    public DependencyCollectingStrategy dependencyCollectingStrategy() {
        return this.dependencyCollectingStrategy;
    }

    public DependencyArchivingStrategy dependencyArchivingStrategy() {
        return this.dependencyArchivingStrategy;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public TaskBackup taskBackup() {
        return this.taskBackup;
    }

    public Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    public Collection<String> getCompletableGateIds(Collection<PlanItem> targets) {
        Seq doneTargetIds = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(targets).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDone()))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Iterable$.MODULE$.canBuildFrom())).toSeq();
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.findInProgressIncomingGateIds((Seq<String>)doneTargetIds).map((Function1 & Serializable & scala.Serializable)id -> (GateTask)this.repository().handle(new TaskGetCommand((String)id)), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isCompletable()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    public List<String> findActiveIncomingGateIds(String parentId) {
        Seq seq;
        if (Predef$.MODULE$.Boolean2boolean(this.queries().query(new PlanItemExistsQuery(parentId)))) {
            seq = (Seq)((SeqLike)((TraversableLike)this.dependencyCollectingStrategy().findAllIncomingDependencyIds((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{parentId}))), this.activeDependencyStatuses(), true).filterNot((Function1 & Serializable & scala.Serializable)dependencyId -> BoxesRunTime.boxToBoolean((boolean)this.isTemplate(dependencyId)))).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getParentId((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Plan item ", " not found. It is either archived, or does not exist. Returning no dependencies"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentId})));
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(seq).asJava();
    }

    public Collection<String> getFailableGateIds(Collection<PlanItem> abortedTargets) {
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.findInProgressIncomingGateIds((Seq<String>)((Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(abortedTargets).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getId(), Seq$.MODULE$.canBuildFrom())))).asJava();
    }

    public List<String> findAllIncomingDependencyIds(PlanItem planItem) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.dependencyCollectingStrategy().findAllIncomingDependencyIds((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{planItem.getId()}))), this.dependencyCollectingStrategy().findAllIncomingDependencyIds$default$2(), this.dependencyCollectingStrategy().findAllIncomingDependencyIds$default$3())).asJava();
    }

    public void replaceArchivedIncomingDependencies(PlanItem dependent, PlanItem replacement) {
        this.taskBackup().replaceBackedUpDependencies(dependent, replacement);
    }

    public void archiveAllIncomingDependencies(String releaseId) {
        this.dependencyArchivingStrategy().archiveAllIncomingDependencies(releaseId);
    }

    public void archiveAllOutgoingDependencies(Release release) {
        this.dependencyArchivingStrategy().archiveAllOutgoingDependencies(release);
    }

    public List<String> findActiveOutgoingTargetIds(String releaseId) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.dependencies().findByReleaseId(releaseId, Predef$.MODULE$.int2Integer(2))).asScala()).filter((Function1 & Serializable & scala.Serializable)dep -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$findActiveOutgoingTargetIds$1(dep)))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getTargetId(), Buffer$.MODULE$.canBuildFrom())).distinct()).asJava();
    }

    public ReleaseTree getReleaseTree(String releaseId) {
        ReleaseTree releaseTree;
        if (this.releases().isArchived(releaseId)) {
            releaseTree = new ReleaseTree();
        } else {
            scala.collection.mutable.Map dependentReleases = Map$.MODULE$.empty();
            Release release = this.repository().handle(new ReleaseGetCommand(releaseId, Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), true, ReleaseGetCommand$.MODULE$.apply$default$4()));
            this.toTreeItem(releaseId, (scala.collection.mutable.Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
            ReleaseTree tree = new ReleaseTree();
            tree.releaseId_$eq(releaseId);
            tree.dependentReleases_$eq((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)dependentReleases.values().toList()).asJava());
            releaseTree = tree;
        }
        return releaseTree;
    }

    public void updateGateReferencingPhases(String gateId, Map<PlanItem, PlanItem> originToRestored) {
        GateTask gate = (GateTask)this.repository().handle(new TaskGetCommand(gateId));
        Release release = gate.getRelease();
        gate.getDependencies().forEach(dependency -> {
            block0: {
                PlanItem target = dependency.getTarget();
                if (!originToRestored.containsKey(target)) break block0;
                Dependency original = CiCloneHelper.cloneCi(dependency);
                dependency.setTarget((PlanItem)originToRestored.get(target));
                this.repository().handle(new DependencyUpdateCommand(release, (Dependency)dependency, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()));
                this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
            }
        });
    }

    public Seq<String> findInProgressIncomingGateIds(Seq<String> targetIds) {
        return (Seq)((SeqLike)this.dependencyCollectingStrategy().findAllIncomingDependencyIds(targetIds, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}))), this.dependencyCollectingStrategy().findAllIncomingDependencyIds$default$3()).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getParentId((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        String string = this.advancedRepositoryService().readPropertyAsString(Ids.releaseIdFrom((String)dependencyId), "status");
        String string2 = ReleaseStatus.TEMPLATE.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findActiveOutgoingTargetIds$1(Dependency dep) {
        return dep.hasResolvedTarget() && !dep.isDone();
    }

    @Autowired
    public DependencyService(XlrRepository repository, XlrQueries queries, Releases releases, Dependencies dependencies, AdvancedRepositoryService advancedRepositoryService, DependencyCollectingStrategy dependencyCollectingStrategy, DependencyArchivingStrategy dependencyArchivingStrategy, XLReleaseEventBus eventBus, TaskBackup taskBackup) {
        this.repository = repository;
        this.queries = queries;
        this.releases = releases;
        this.dependencies = dependencies;
        this.advancedRepositoryService = advancedRepositoryService;
        this.dependencyCollectingStrategy = dependencyCollectingStrategy;
        this.dependencyArchivingStrategy = dependencyArchivingStrategy;
        this.eventBus = eventBus;
        this.taskBackup = taskBackup;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (Seq)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).toSeq().$colon$plus((Object)TaskStatus.PLANNED, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom());
    }
}

