/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.upgrade.RepositoryInitializer;
import com.xebialabs.deployit.upgrade.UpgradeRejectedException;
import com.xebialabs.deployit.upgrade.Upgrader;
import com.xebialabs.xlplatform.spring.JythonBindingsHolder;
import com.xebialabs.xlrelease.actors.cluster.XlrActorSystem;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.XLReleaseServiceHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ServiceStarter {
    public static final String DECRYPTING_REPOSITORY_SERVICE = "decryptingRepositoryService";
    private final Upgrader upgrader;
    private final RepositoryInitializer repositoryInitializer;
    private RepositoryService repositoryService;
    private RepositoryService decryptingRepositoryService;
    private final XlrActorSystem xlrActorSystem;
    private List<? extends ApiService> apiServices;
    private static final Logger logger = LoggerFactory.getLogger(ServiceStarter.class);

    @Autowired
    public ServiceStarter(Upgrader upgrader, RepositoryInitializer repositoryInitializer, RepositoryService repositoryService, @Qualifier(value="decryptingRepositoryService") RepositoryService decryptingRepositoryService, XlrActorSystem xlrActorSystem) {
        this.upgrader = upgrader;
        this.repositoryInitializer = repositoryInitializer;
        this.repositoryService = repositoryService;
        this.decryptingRepositoryService = decryptingRepositoryService;
        this.xlrActorSystem = xlrActorSystem;
    }

    @Autowired
    public void setApiServices(List<? extends ApiService> apiServices) {
        this.apiServices = apiServices;
    }

    @PostConstruct
    public void startServices() {
        XLReleaseServiceHolder.init(this.repositoryService, this.apiServices);
        this.initEndpointsJythonBindings(this.apiServices);
        this.repositoryInitializer.initializeComponents();
        try {
            this.upgrader.autoUpgrade();
        }
        catch (UpgradeRejectedException e) {
            logger.warn("Upgrade rejected: {}", (Object)e.getMessage());
            return;
        }
        this.xlrActorSystem.boot();
    }

    private void initEndpointsJythonBindings(List<? extends ApiService> apiServices) {
        HashMap<String, RepositoryService> bindings = new HashMap<String, RepositoryService>();
        apiServices.forEach(apiService -> bindings.put(apiService.serviceName(), (RepositoryService)apiService));
        bindings.put("repositoryService", this.decryptingRepositoryService);
        JythonBindingsHolder.setBindings(Collections.unmodifiableMap(bindings));
    }
}

