/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade.common;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.upgrade.Components;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XLRelease409SetLoginAllowedToTrue
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(XLRelease409SetLoginAllowedToTrue.class);
    private static final String VERSION = "4.0.9";
    private RepositoryService repositoryService;

    @Autowired
    public XLRelease409SetLoginAllowedToTrue(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public boolean doUpgrade() throws UpgradeException {
        logger.info("*** Starting {} {} upgrade -- Set login allowed to true in all user profiles ***", (Object)"XL Release", (Object)VERSION);
        SearchParameters query = new SearchParameters().setType(Type.valueOf(UserProfile.class));
        List profiles = this.repositoryService.listEntities(query);
        for (UserProfile profile : profiles) {
            profile.setLoginAllowed(true);
            this.repositoryService.update((ConfigurationItem[])new UserProfile[]{profile});
        }
        logger.info("*** Done {} {} upgrade -- Set login allowed to true in all user profiles ***", (Object)"XL Release", (Object)VERSION);
        return true;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)Components.XL_RELEASE_COMPONENT, (String)VERSION);
    }
}

