/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.xlplatform.repository.AdvancedRepositoryService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.views.DependencyNode;
import com.xebialabs.xlrelease.views.Flag;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DependencyViewConverter {
    private AdvancedRepositoryService advancedRepositoryService;
    private XlrRepository repository;

    @Autowired
    public DependencyViewConverter(AdvancedRepositoryService advancedRepositoryService, XlrRepository repository) {
        this.advancedRepositoryService = advancedRepositoryService;
        this.repository = repository;
    }

    public List<DependencyNode> toDependencyNodes(List<String> planItemIds) {
        return planItemIds.stream().map(this::toDependencyNode).collect(Collectors.toList());
    }

    protected DependencyNode toDependencyNode(String planItemId) {
        DependencyNode dependency = new DependencyNode();
        String releaseId = Ids.releaseIdFrom((String)planItemId);
        Release release = this.repository.handle(new ReleaseGetCommand(releaseId, 2, true, null));
        dependency.setReleaseId(releaseId);
        dependency.setReleaseTitle(release.getTitle());
        dependency.setStartDate(release.getStartDate());
        dependency.setDueDate(release.getDueDate());
        dependency.setScheduledStartDate(release.getScheduledStartDate());
        dependency.setEndDate(release.getEndDate());
        dependency.setFlag(Flag.toFlag(release));
        if (Ids.isPhaseId((String)planItemId)) {
            dependency.setPhaseId(planItemId);
            dependency.setPhaseTitle(VariableHelper.replaceAll((String)this.getTitle(planItemId), (Map)release.getAllStringVariableValues()));
        } else if (Ids.isTaskId((String)planItemId)) {
            dependency.setTaskId(planItemId);
            dependency.setTaskTitle(VariableHelper.replaceAll((String)this.getTitle(planItemId), (Map)release.getAllStringVariableValues()));
            String phaseId = Ids.phaseIdFrom((String)planItemId);
            dependency.setPhaseId(phaseId);
            dependency.setPhaseTitle(VariableHelper.replaceAll((String)this.getTitle(phaseId), (Map)release.getAllStringVariableValues()));
        }
        return dependency;
    }

    private String getTitle(String id) {
        return this.advancedRepositoryService.readPropertyAsString(id, "title");
    }
}

