/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.TaskViewConverter;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.TaskPollingView;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TasksViewConverter {
    private Map<Type, TaskViewConverter> taskViewConverters = new HashMap<Type, TaskViewConverter>();

    @Autowired
    public void setTaskViewConverters(List<? extends TaskViewConverter> taskViewConverters) {
        taskViewConverters.stream().forEach(converter -> this.taskViewConverters.put(converter.getTaskType(), (TaskViewConverter)converter));
    }

    public TaskFullView toFullView(Task task, List<Type> allowedTaskTypesForAuthenticatedUser) {
        return this.getConverterFor(task.getType()).toFullView(task, allowedTaskTypesForAuthenticatedUser);
    }

    public List<TaskFullView> toFullView(Collection<? extends Task> tasks, List<Type> allowedTaskTypesForAuthenticatedUser) {
        return tasks.stream().map(t -> this.toFullView((Task)t, allowedTaskTypesForAuthenticatedUser)).collect(Collectors.toList());
    }

    public TaskPollingView toPollView(Task task) {
        return this.getConverterFor(task.getType()).toPollView(task);
    }

    public List<TaskPollingView> toPollView(Collection<? extends Task> tasks) {
        return tasks.stream().map(this::toPollView).collect(Collectors.toList());
    }

    public Task toTask(TaskFullView view) {
        return this.getConverterFor(Type.valueOf((String)view.getType())).toTask(view);
    }

    private TaskViewConverter getConverterFor(Type taskType) {
        TaskViewConverter taskViewConverter = this.taskViewConverters.get(taskType);
        if (null == taskViewConverter) {
            throw new IllegalStateException(String.format("TaskFullViewConverter is not defined for task '%s'", taskType));
        }
        return taskViewConverter;
    }
}

