/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.setup.JcrSetup;
import com.xebialabs.deployit.setup.Setup;
import com.xebialabs.xlrelease.JcrSetupFactory;
import com.xebialabs.xlrelease.config.XlrConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLReleaseSetup {
    private static final Logger logger = LoggerFactory.getLogger(XLReleaseSetup.class);

    public static Setup get(String product, ServerConfigFile configFile, ServerLaunchOptions launchOptions, ServerConfiguration serverConfiguration) {
        XlrConfig xlrConfig = XlrConfig.bootConfig();
        logger.info("Initializing Jackrabbit JCR Repository");
        return XLReleaseSetup.instantiateXlReleaseSetup("com.xebialabs.xlrelease.JackrabbitSetupFactory", product, configFile, launchOptions, serverConfiguration, xlrConfig);
    }

    private static JcrSetup instantiateXlReleaseSetup(String implementationName, String product, ServerConfigFile configFile, ServerLaunchOptions launchOptions, ServerConfiguration serverConfiguration, XlrConfig xlrConfig) {
        try {
            Class<?> jcrSetupFactoryClass = Class.forName(implementationName);
            JcrSetupFactory jcrSetupFactory = (JcrSetupFactory)jcrSetupFactoryClass.newInstance();
            return jcrSetupFactory.createSetup(product, configFile, launchOptions, serverConfiguration, xlrConfig);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.error("Unable to instantiate {}", (Object)implementationName, (Object)e);
            throw new IllegalStateException(String.format("Unable to instantiate %s", implementationName), e);
        }
    }
}

