/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.jcr;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.QueryTemplate;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.ReleasesMoveCommand;
import com.xebialabs.xlrelease.repository.XlrQueries;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.repository.XlrRepositoryCommand;
import com.xebialabs.xlrelease.repository.spi.RepositoryQueries;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.SearchServiceWithPermissions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001B\u0001\u0003\u00015\u00111CS2s\r>dG-\u001a:SKB|7/\u001b;pefT!a\u0001\u0003\u0002\u0007)\u001c'O\u0003\u0002\u0006\r\u0005Q!/\u001a9pg&$xN]=\u000b\u0005\u001dA\u0011!\u0003=me\u0016dW-Y:f\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ!!\u0005\u0004\u0002\u000fM,'O^5dK&\u00111\u0003\u0005\u0002\u001d'\u0016\f'o\u00195TKJ4\u0018nY3XSRD\u0007+\u001a:nSN\u001c\u0018n\u001c8t!\t)b#D\u0001\u0005\u0013\t9BA\u0001\tG_2$WM\u001d*fa>\u001c\u0018\u000e^8ss\"A\u0011\u0004\u0001B\u0001B\u0003%!$A\tsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\u0004\"aG\u0010\u000e\u0003qQ!!B\u000f\u000b\u0005yA\u0011\u0001\u00033fa2|\u00170\u001b;\n\u0005\u0001b\"!\u0005*fa>\u001c\u0018\u000e^8ssN+'O^5dK\"A!\u0005\u0001B\u0001B\u0003%1%A\tsKB|7/\u001b;pef\fV/\u001a:jKN\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0003\u0002\u0007M\u0004\u0018.\u0003\u0002)K\t\t\"+\u001a9pg&$xN]=Rk\u0016\u0014\u0018.Z:\t\u0011)\u0002!\u0011!Q\u0001\n-\nQ\u0002\u001f7s%\u0016\u0004xn]5u_JL\bCA\u000b-\u0013\tiCAA\u0007YYJ\u0014V\r]8tSR|'/\u001f\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005Q\u0001\u0010\u001c:Rk\u0016\u0014\u0018.Z:\u0011\u0005U\t\u0014B\u0001\u001a\u0005\u0005)AFN])vKJLWm\u001d\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005\u0001B-Z2pe\u0006$xN]*feZL7-Z\u000b\u0002mA\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\tS:$XM\u001d8bY*\u00111HB\u0001\u0004CBL\u0017BA\u001f9\u0005\u0001Je\u000e^3s]\u0006dW*\u001a;bI\u0006$\u0018\rR3d_J\fGo\u001c:TKJ4\u0018nY3\t\u0011}\u0002!\u0011!Q\u0001\nY\n\u0011\u0003Z3d_J\fGo\u001c:TKJ4\u0018nY3!\u0011!\t\u0005A!b\u0001\n\u0003\u0011\u0015a\u00039fe6L7o]5p]N,\u0012a\u0011\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r\u001a\t\u0001b]3dkJLG/_\u0005\u0003\u0011\u0016\u0013\u0011\u0003U3s[&\u001c8/[8o\u0007\",7m[3s\u0011!Q\u0005A!A!\u0002\u0013\u0019\u0015\u0001\u00049fe6L7o]5p]N\u0004\u0003\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\u0002%A,'/\\5tg&|g.\u00128g_J\u001cWM\u001d\t\u0003\u001dBk\u0011a\u0014\u0006\u0003\rvI!!U(\u0003%A+'/\\5tg&|g.\u00128g_J\u001cWM\u001d\u0005\u0006'\u0002!\t\u0001V\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011U;\u0006,\u0017.\\9v\u0003\"A\u0016\u0001\u000e\u0003\tAQ!\u0007*A\u0002iAQA\t*A\u0002\rBQA\u000b*A\u0002-BQa\f*A\u0002ABQ\u0001\u000e*A\u0002YBQ!\u0011*A\u0002\rCQ\u0001\u0014*A\u00025CQa\u0018\u0001\u0005B\u0001\faa\u0019:fCR,GcA1jqB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0007M>dG-\u001a:\u000b\u0005\u00194\u0011A\u00023p[\u0006Lg.\u0003\u0002iG\n1ai\u001c7eKJDQA\u001b0A\u0002-\f\u0001\u0002]1sK:$\u0018\n\u001a\t\u0003YVt!!\\:\u0011\u00059\fX\"A8\u000b\u0005Ad\u0011A\u0002\u001fs_>$hHC\u0001s\u0003\u0015\u00198-\u00197b\u0013\t!\u0018/\u0001\u0004Qe\u0016$WMZ\u0005\u0003m^\u0014aa\u0015;sS:<'B\u0001;r\u0011\u0015!g\f1\u0001b\u0011\u0015Q\b\u0001\"\u0011|\u0003\u0019!W\r\\3uKR\u0019A0!\u0001\u0011\u0005utX\"A9\n\u0005}\f(\u0001B+oSRDa!a\u0001z\u0001\u0004Y\u0017\u0001\u00034pY\u0012,'/\u00133\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n\u00051!/\u001a8b[\u0016$R!YA\u0006\u0003\u001bAq!a\u0001\u0002\u0006\u0001\u00071\u000eC\u0004\u0002\u0010\u0005\u0015\u0001\u0019A6\u0002\u000f9,wOT1nK\"9\u00111\u0003\u0001\u0005B\u0005U\u0011\u0001B7pm\u0016$R!YA\f\u00033Aq!a\u0001\u0002\u0012\u0001\u00071\u000eC\u0004\u0002\u001c\u0005E\u0001\u0019A6\u0002\u00179,w\u000fU1sK:$\u0018\n\u001a\u0005\b\u0003?\u0001A\u0011IA\u0011\u0003\u0019)\u00070[:ugR!\u00111EA\u0015!\ri\u0018QE\u0005\u0004\u0003O\t(a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0007\ti\u00021\u0001l\u0011\u001d\ti\u0003\u0001C!\u0003_\t\u0001bZ3u)&$H.\u001a\u000b\u0005\u0003c\t9\u0004\u0005\u0003~\u0003gY\u0017bAA\u001bc\n1q\n\u001d;j_:Dq!a\u0001\u0002,\u0001\u00071\u000eC\u0004\u0002<\u0001!\t%!\u0010\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$b!a\u0010\u0002B\u0005\r\u0003\u0003B?\u00024\u0005Dq!a\u0001\u0002:\u0001\u00071\u000e\u0003\u0006\u0002F\u0005e\u0002\u0013!a\u0001\u0003\u000f\nQ\u0001Z3qi\"\u00042!`A%\u0013\r\tY%\u001d\u0002\u0004\u0013:$\bbBA(\u0001\u0011\u0005\u0013\u0011K\u0001\u000bM&tGMQ=QCRDG#B1\u0002T\u0005]\u0003bBA+\u0003\u001b\u0002\ra[\u0001\ni&$H.\u001a)bi\"D!\"!\u0012\u0002NA\u0005\t\u0019AA$\u0011\u001d\tY\u0006\u0001C!\u0003;\n1\u0003\\5tiZKWm^1cY\u00164u\u000e\u001c3feN$\u0002\"a\u0018\u0002p\u0005E\u00141\u0010\t\u0006\u0003C\nY'Y\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005!Q\u000f^5m\u0015\t\tI'\u0001\u0003kCZ\f\u0017\u0002BA7\u0003G\u0012A\u0001T5ti\"1!.!\u0017A\u0002-D\u0001\"a\u001d\u0002Z\u0001\u0007\u0011QO\u0001\u0005a\u0006<W\rE\u0002\u0016\u0003oJ1!!\u001f\u0005\u0005\u0011\u0001\u0016mZ3\t\u0015\u0005u\u0014\u0011\fI\u0001\u0002\u0004\t\u0019#A\feK\u000e|'/\u0019;f/&$\b\u000eU3s[&\u001c8/[8og\"9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0015\u0001\u00064j]\u0012\u001cVO\u0019$pY\u0012,'OQ=USRdW\r\u0006\u0004\u0002@\u0005\u0015\u0015q\u0011\u0005\u0007U\u0006}\u0004\u0019A6\t\u000f\u0005%\u0015q\u0010a\u0001W\u0006)A/\u001b;mK\"9\u0011Q\u0012\u0001\u0005\u0012\u0005=\u0015\u0001\u00044j]\u0012LEMQ=QCRDG#B6\u0002\u0012\u0006M\u0005bBA+\u0003\u0017\u0003\ra\u001b\u0005\u000b\u0003\u000b\nY\t%AA\u0002\u0005\u001d\u0003bBAL\u0001\u0011E\u0011\u0011T\u0001\u0014M&dG/\u001a:CsB+'/\\5tg&|gn\u001d\u000b\u0007\u00037\u000bi+!-\u0011\u000b\u0005u\u0015qU1\u000f\t\u0005}\u00151\u0015\b\u0004]\u0006\u0005\u0016\"\u0001:\n\u0007\u0005\u0015\u0016/A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00161\u0016\u0002\u0004'\u0016\f(bAASc\"A\u0011qVAK\u0001\u0004\tY*A\u0004g_2$WM]:\t\u0011\u0005M\u0016Q\u0013a\u0001\u0003G\t!\u0002Z8EK\u000e|'/\u0019;f\u0011\u001d\t9\f\u0001C\t\u0003s\u000baBZ5mi\u0016\u00148\t[5mIJ,g\u000eF\u0002b\u0003wCa\u0001ZA[\u0001\u0004\t\u0007bBA`\u0001\u0011E\u0011\u0011Y\u0001\u000eG\u0006tg+[3x\r>dG-\u001a:\u0015\t\u0005\r\u00121\u0019\u0005\u0007I\u0006u\u0006\u0019A1\t\u0013\u0005\u001d\u0007!%A\u0005B\u0005%\u0017A\u00054j]\u0012\u0014\u00150\u00133%I\u00164\u0017-\u001e7uII*\"!a3+\t\u0005\u001d\u0013QZ\u0016\u0003\u0003\u001f\u0004B!!5\u0002\\6\u0011\u00111\u001b\u0006\u0005\u0003+\f9.A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\\9\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002^\u0006M'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\u001d\u0001\u0012\u0002\u0013\u0005\u0013\u0011Z\u0001\u0015M&tGMQ=QCRDG\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005\u0015\b!%A\u0005\u0012\u0005%\u0017A\u00064j]\u0012LEMQ=QCRDG\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005%\b!%A\u0005\u0002\u0005-\u0018!\b7jgR4\u0016.Z<bE2,gi\u001c7eKJ\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u00055(\u0006BA\u0012\u0003\u001b\u0004")
public class JcrFolderRepository
extends SearchServiceWithPermissions
implements FolderRepository {
    private final RepositoryService repositoryService;
    private final RepositoryQueries repositoryQueries;
    private final XlrRepository xlrRepository;
    private final InternalMetadataDecoratorService decoratorService;
    private final PermissionChecker permissions;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public void checkFolderExists(String folderId) {
        FolderRepository.checkFolderExists$((FolderRepository)this, (String)folderId);
    }

    public void checkNameIsUnique(String parentId, String name) {
        FolderRepository.checkNameIsUnique$((FolderRepository)this, (String)parentId, (String)name);
    }

    public List<Folder> paginate(List<Folder> folders, Page page) {
        return FolderRepository.paginate$((FolderRepository)this, folders, (Page)page);
    }

    public Seq<Folder> decorateWithEffectiveSecurity(Seq<Folder> folders) {
        return FolderRepository.decorateWithEffectiveSecurity$((FolderRepository)this, folders);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JcrFolderRepository jcrFolderRepository = this;
        synchronized (jcrFolderRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    public PermissionChecker permissions() {
        return this.permissions;
    }

    public Folder create(String parentId, Folder folder) {
        this.repositoryService.create((ConfigurationItem[])new Folder[]{folder});
        return folder;
    }

    public void delete(String folderId) {
        this.repositoryService.delete(new String[]{folderId});
    }

    /*
     * WARNING - void declaration
     */
    public Folder rename(String folderId, String newName) {
        void var3_3;
        this.checkNameIsUnique(Ids.getParentId((String)folderId), newName);
        Folder folder = (Folder)this.repositoryService.read(folderId, 1);
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Renaming folder ", " from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId, folder.getTitle(), newName})));
        folder.setTitle(newName);
        this.repositoryService.update((ConfigurationItem[])new Folder[]{folder});
        return var3_3;
    }

    public Folder move(String folderId, String newParentId) {
        Folder folder = (Folder)this.repositoryService.read(folderId, 1);
        this.checkNameIsUnique(newParentId, folder.getTitle());
        String newId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newParentId, Ids.getName((String)folderId)}));
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Moving '", "' under: '", "' with new id: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId, newParentId, newId})));
        this.repositoryService.move(folderId, newId);
        this.xlrRepository.handle((XlrRepositoryCommand)new ReleasesMoveCommand(folderId, newParentId));
        return (Folder)this.repositoryService.read(newId, 1);
    }

    public boolean exists(String folderId) {
        return this.repositoryService.exists(folderId);
    }

    public Option<String> getTitle(String folderId) {
        return Option$.MODULE$.apply((Object)this.repositoryService.read(folderId, 1)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getTitle());
    }

    public Option<Folder> findById(String folderId, int depth) {
        Folder folder = (Folder)this.repositoryService.read(folderId, depth);
        this.decoratorService().decorate((ConfigurationItem)folder, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
        return Option$.MODULE$.apply((Object)folder);
    }

    public int findById$default$2() {
        return Predef$.MODULE$.Integer2int(Page$.MODULE$.DEFAULT_DEPTH());
    }

    public Folder findByPath(String titlePath, int depth) {
        return (Folder)this.findById(this.findIdByPath(titlePath, depth), depth).get();
    }

    public int findByPath$default$2() {
        return Predef$.MODULE$.Integer2int(Page$.MODULE$.DEFAULT_DEPTH());
    }

    public List<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions) {
        this.checkFolderExists(parentId);
        QueryTemplate query = this.repositoryQueries.listSubfoldersQuery(parentId);
        List firstLevelFolders = this.queryEntitiesAndFilterByPermissions(page.page(), page.resultsPerPage(), query, page.depth(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.VIEW_FOLDER}))).asJava());
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.filterByPermissions((Seq<Folder>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(firstLevelFolders).asScala()), decorateWithPermissions)).asJava();
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    public Option<Folder> findSubFolderByTitle(String parentId, String title) {
        int depthFoldersWithTitles = 1;
        SearchParameters subfolderByNameQuery = new SearchParameters().setType(Type.valueOf(Folder.class)).setParent(parentId).setDepth(depthFoldersWithTitles).addProperty("title", title);
        List childrenByName = this.repositoryService.listEntities(subfolderByNameQuery);
        return ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(childrenByName).asScala()).headOption();
    }

    public String findIdByPath(String titlePath, int depth) {
        String foundFolderId;
        if (Strings.isEmpty((String)titlePath)) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find folder by empty path: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{titlePath})), new Object[0]);
        }
        String pathFromRoot = titlePath.startsWith("/") ? titlePath.substring(1) : titlePath;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finding folder by path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pathFromRoot})));
        String[] pathElements = pathFromRoot.split("/");
        String string = foundFolderId = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).foldLeft((Object)Ids.ROOT_FOLDER_ID, (Function2 & Serializable & scala.Serializable)(folderId, pathElement) -> {
            String string;
            if (pathElement.isEmpty()) {
                string = folderId;
            } else {
                Option<Folder> childByName = this.findSubFolderByTitle((String)folderId, (String)pathElement);
                string = (String)childByName.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find folder [", "] in path [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pathElement, titlePath})), new Object[0]);
                });
            }
            return string;
        });
        String string2 = Ids.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IllegalArgumentException("No folder path specified, the root path is not supported");
        }
        return foundFolderId;
    }

    public int findIdByPath$default$2() {
        return Predef$.MODULE$.Integer2int(Page$.MODULE$.DEFAULT_DEPTH());
    }

    public Seq<Folder> filterByPermissions(Seq<Folder> folders, boolean doDecorate) {
        return (Seq)((TraversableLike)(doDecorate ? this.decorateWithEffectiveSecurity(folders) : folders).filter((Function1 & Serializable & scala.Serializable)folder -> BoxesRunTime.boxToBoolean((boolean)this.canViewFolder(folder)))).map((Function1 & Serializable & scala.Serializable)folder -> this.filterChildren((Folder)folder), Seq$.MODULE$.canBuildFrom());
    }

    public Folder filterChildren(Folder folder2) {
        scala.collection.mutable.Set children = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(folder2.getChildren()).asScala();
        scala.collection.mutable.Set filteredChildren = (scala.collection.mutable.Set)children.filter((Function1 & Serializable & scala.Serializable)folder -> BoxesRunTime.boxToBoolean((boolean)this.canViewFolder(folder)));
        filteredChildren.foreach((Function1 & Serializable & scala.Serializable)folder -> this.filterChildren((Folder)folder));
        folder2.setChildren((Set)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(filteredChildren).asJava());
        return folder2;
    }

    public boolean canViewFolder(Folder folder) {
        return this.permissions().hasPermission(XLReleasePermissions.VIEW_FOLDER, folder.getId());
    }

    public JcrFolderRepository(RepositoryService repositoryService, RepositoryQueries repositoryQueries, XlrRepository xlrRepository, XlrQueries xlrQueries, InternalMetadataDecoratorService decoratorService, PermissionChecker permissions, PermissionEnforcer permissionEnforcer) {
        this.repositoryService = repositoryService;
        this.repositoryQueries = repositoryQueries;
        this.xlrRepository = xlrRepository;
        this.decoratorService = decoratorService;
        this.permissions = permissions;
        super(permissionEnforcer, repositoryService);
        Logging.$init$((Logging)this);
        FolderRepository.$init$((FolderRepository)this);
    }
}

