/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskAssessor;
import java.util.ArrayList;

@PublicApiRef
@Metadata(label="ReleaseStatusAssessor", versioned=false)
public class ReleaseStatusRiskAssessor
extends RiskAssessor {
    private static final int RELEASE_FAILED_SCORE = 90;
    private static final String RELEASE_FAILED_HEADLINE = "Release has failed";
    private static final int RELEASE_FAILING_SCORE = 70;
    private static final String RELEASE_FAILING_HEADLINE = "Release is failing";

    @Override
    public RiskAssessment execute(Release release) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());
        ArrayList<String> messages = new ArrayList<String>();
        if (release.isFailed()) {
            assessment.setScore(90);
            assessment.setHeadline(RELEASE_FAILED_HEADLINE);
            messages.add(String.format("%s has failed", release.getTitle()));
        } else if (release.isFailing()) {
            assessment.setScore(70);
            assessment.setHeadline(RELEASE_FAILING_HEADLINE);
            messages.add(String.format("%s is failing", release.getTitle()));
        } else {
            assessment.setScore(0);
            assessment.setHeadline("Release is on track");
        }
        assessment.setMessages(messages);
        return assessment;
    }
}

