/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseOverdueEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskAbortedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskFailedEvent;
import com.xebialabs.xlrelease.domain.events.TaskOverdueEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.risk.actors.extension.RiskReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.Risks;
import java.text.MessageFormat;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.AllowConcurrentEvents;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RiskService {
    private static final Logger logger = LoggerFactory.getLogger(Releases.class);
    private XLReleaseEventBus eventBus;
    private ReleaseActorService releaseActorService;
    private Risks risks;
    private List<RiskAssessor> riskAssessors = DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class)).stream().filter(type -> !type.getDescriptor().isVirtual()).map(type -> (RiskAssessor)type.getDescriptor().newInstance(this.generateAssessorId(type.getName()))).collect(Collectors.toList());

    @Autowired
    public RiskService(XLReleaseEventBus eventBus, ReleaseActorService releaseActorService, Risks risks) {
        this.eventBus = eventBus;
        this.releaseActorService = releaseActorService;
        this.risks = risks;
    }

    @PostConstruct
    public void register() {
        this.eventBus.register((Object)this);
    }

    @PreDestroy
    public void unregister() {
        this.eventBus.deregister((Object)this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void releaseCreated(ReleaseCreatedEvent releaseCreatedEvent) {
        this.calculateRiskAndUpdateRelease(releaseCreatedEvent.release());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void releaseUpdated(ReleaseUpdatedEvent releaseUpdatedEvent) {
        this.calculateRiskAndUpdateRelease(releaseUpdatedEvent.updated());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void releaseOverdue(ReleaseOverdueEvent releaseOverdueEvent) {
        this.calculateRiskAndUpdateRelease(releaseOverdueEvent.release());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void taskFailed(TaskFailedEvent taskFailedEvent) {
        this.calculateRiskAndUpdateRelease(taskFailedEvent.task());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void taskCompleted(TaskCompletedEvent taskCompletedEvent) {
        this.calculateRiskAndUpdateRelease(taskCompletedEvent.task());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void taskSkipped(TaskSkippedEvent taskSkippedEvent) {
        this.calculateRiskAndUpdateRelease(taskSkippedEvent.task());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void taskAborted(TaskAbortedEvent taskAbortedEvent) {
        this.calculateRiskAndUpdateRelease(taskAbortedEvent.task());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void taskUpdated(TaskUpdatedEvent taskUpdatedEvent) {
        this.calculateRiskAndUpdateRelease(taskUpdatedEvent.updated());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void taskOverdue(TaskOverdueEvent taskOverdueEvent) {
        this.calculateRiskAndUpdateRelease(taskOverdueEvent.task());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void taskDeleted(TaskDeletedEvent taskDeletedEvent) {
        this.calculateRiskAndUpdateRelease(taskDeletedEvent.task());
    }

    public Risk calculateRisk(Release release) {
        logger.debug("Running risk calculations for release {}", (Object)release.getId());
        Risk risk = (Risk)this.risks.findByIdOrDefault(release, this.generateRiskId(release.getId()));
        List<RiskAssessment> riskAssessments = this.riskAssessors.stream().map(riskAssessor -> riskAssessor.execute(release)).collect(Collectors.toList());
        risk.setRiskAssessments(riskAssessments);
        IntSummaryStatistics riskStatistics = riskAssessments.stream().collect(Collectors.summarizingInt(RiskAssessment::getScore));
        Integer totalRiskScore = Math.toIntExact(riskStatistics.getSum());
        risk.setScore(riskStatistics.getMax());
        risk.setTotalScore(totalRiskScore);
        Risk persistedRisk = this.risks.createOrUpdate(risk);
        logger.debug("Finished running risk calculations for release {} with score {} and total score {}", new Object[]{release.getId(), persistedRisk.getScore(), persistedRisk.getTotalScore()});
        return persistedRisk;
    }

    private void calculateRiskAndUpdateRelease(Task task) {
        this.calculateRiskAndUpdateRelease(task.getRelease());
    }

    private void calculateRiskAndUpdateRelease(Release release) {
        if (release.isActive() || release.isPlanned()) {
            Risk risk = this.calculateRisk(release);
            this.releaseActorService.executeCommandAsync(release.getId(), (ReleaseExecutionActorMessages.ExtensionCommand)new RiskReleaseExecutionActorMessages.UpdateRiskScore(risk.getScore(), risk.getTotalScore()));
        }
    }

    private String generateRiskId(String releaseId) {
        return MessageFormat.format("{0}/{1}", releaseId, "Risk");
    }

    private String generateAssessorId(String name) {
        return MessageFormat.format("{0}/{1}", Ids.ROOT_FOLDER_ID, name);
    }
}

