/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.export;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiReference;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnresolvedReferencesConfigurationItemConverter
extends PasswordEncryptingCiConverter {
    public static final String DECRYPTION_FAILED_VALUE = UnresolvedReferencesConfigurationItemConverter.class.getName() + ".DECRYPTION_FAILED_VALUE";
    private static final Logger logger = LoggerFactory.getLogger(UnresolvedReferencesConfigurationItemConverter.class);

    public void resolveReferences(Repository repository) {
        for (CiReference reference : this.getReferences()) {
            ArrayList resolvedCIs = Lists.newArrayList();
            for (String id : reference.getIds()) {
                ConfigurationItem alsoRead = (ConfigurationItem)this.getReadCIs().get(id);
                if (alsoRead != null) {
                    resolvedCIs.add(alsoRead);
                    continue;
                }
                resolvedCIs.add(repository.read(id));
            }
            reference.set((List)resolvedCIs);
        }
    }

    protected void readStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        if (propertyDescriptor.isPassword()) {
            try {
                super.readStringProperty(configurationItem, propertyDescriptor, reader);
            }
            catch (Exception exception) {
                propertyDescriptor.set(configurationItem, (Object)DECRYPTION_FAILED_VALUE);
                logger.info("Failed to read password field: '{}' with value: '{}'", new Object[]{propertyDescriptor, reader.getStringValue(), exception});
            }
        } else {
            super.readStringProperty(configurationItem, propertyDescriptor, reader);
        }
    }
}

