/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.google.common.io.Resources;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.script.ScriptExecutor;
import com.xebialabs.xlrelease.script.ScriptPermissionsProvider;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.PropertyPermission;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.security.auth.AuthPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Jsr223ScriptExecutor
implements ScriptExecutor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ScriptEngine scriptEngine;
    private ScriptPermissionsProvider scriptPermissionsProvider;
    private XlrConfig xlrConfig;

    public Jsr223ScriptExecutor(ScriptEngine scriptEngine, ScriptPermissionsProvider scriptPermissionsProvider, XlrConfig xlrConfig) {
        this.scriptEngine = scriptEngine;
        this.scriptPermissionsProvider = scriptPermissionsProvider;
        this.xlrConfig = xlrConfig;
    }

    @Override
    public Object evalScript(String script, ScriptContext scriptContext) throws Exception {
        return this.evalScript(script, scriptContext, true);
    }

    @Override
    public Object evalScript(String script, ScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        return this.evalScriptPrivileged(script, scriptContext, checkPolicyPermissions ? this.getAccessControlContext() : null);
    }

    @Override
    public Object evalScriptWithApi(String script, ScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        return this.evalScript(script, scriptContext, checkPolicyPermissions);
    }

    protected Object evalScriptPrivileged(String script, ScriptContext scriptContext, AccessControlContext accessControlContext) throws Exception {
        try {
            return AccessController.doPrivileged(() -> this.scriptEngine.eval(script.intern(), scriptContext), accessControlContext);
        }
        catch (PrivilegedActionException exceptionWrapper) {
            this.logger.debug("PrivilegedActionException: ", (Throwable)exceptionWrapper);
            throw exceptionWrapper.getException();
        }
    }

    protected void loadAndEval(String resourcePath, ScriptContext scriptContext) {
        String script = this.loadScript(resourcePath);
        this.evalUtilityScript(script, scriptContext);
    }

    protected void evalUtilityScript(String script, ScriptContext scriptContext) {
        try {
            this.scriptEngine.eval(script, scriptContext);
        }
        catch (ScriptException e) {
            this.logger.warn("Unable to evaluate utility script '{}'", (Object)script, (Object)e);
        }
    }

    private String loadScript(String resourcePath) {
        try {
            URL resourceUrl = Resources.getResource((String)resourcePath);
            return Resources.toString((URL)resourceUrl, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to load %s", resourcePath), e);
        }
    }

    protected AccessControlContext getAccessControlContext() {
        ProtectionDomain domain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), this.extendsMinimalPermissionsWith(this.scriptPermissionsProvider.getScriptPermissions()));
        return new AccessControlContext(new ProtectionDomain[]{domain});
    }

    private Permissions extendsMinimalPermissionsWith(PermissionCollection permissions) {
        Permissions minimalPermissions = new Permissions();
        minimalPermissions.add(new PropertyPermission("user.dir", "read"));
        minimalPermissions.add(new PropertyPermission("line.separator", "read"));
        minimalPermissions.add(new PropertyPermission("file.encoding", "read"));
        minimalPermissions.add(new RuntimePermission("createClassLoader"));
        minimalPermissions.add(new RuntimePermission("getProtectionDomain"));
        minimalPermissions.add(new RuntimePermission("getClassLoader"));
        minimalPermissions.add(new SecurityPermission("insertProvider.BC"));
        minimalPermissions.add(new RuntimePermission("accessClassInPackage.sun.util.calendar"));
        this.addInternalAccessPermissions(minimalPermissions);
        this.addJythonLibrariesReadPermission(minimalPermissions);
        this.addJsonSmartLibraryPermissions(minimalPermissions);
        this.addOvertherePermissions(minimalPermissions);
        this.addWorkDirPermissions(minimalPermissions);
        if (permissions != null) {
            Enumeration<Permission> permissionEnumeration = permissions.elements();
            while (permissionEnumeration.hasMoreElements()) {
                minimalPermissions.add(permissionEnumeration.nextElement());
            }
        }
        return minimalPermissions;
    }

    private void addInternalAccessPermissions(Permissions minimalPermissions) {
        minimalPermissions.add(new AuthPermission("modifyPrincipals"));
        minimalPermissions.add(new AuthPermission("modifyPublicCredentials"));
        minimalPermissions.add(new RuntimePermission("accessDeclaredMembers"));
        minimalPermissions.add(new ReflectPermission("suppressAccessChecks"));
        minimalPermissions.add(new RuntimePermission("accessClassInPackage.sun.reflect"));
    }

    private void addOvertherePermissions(Permissions minimalPermissions) {
        minimalPermissions.add(new NetPermission("specifyStreamHandler"));
        minimalPermissions.add(new PropertyPermission("jcifs.properties", "read"));
    }

    private void addJythonLibrariesReadPermission(Permissions minimalPermissions) {
        this.addReadPermissionOnJar("jython-standalone", minimalPermissions);
        minimalPermissions.add(new PropertyPermission("os.name", "read"));
        minimalPermissions.add(new PropertyPermission("os.arch", "read"));
    }

    private void addJsonSmartLibraryPermissions(Permissions minimalPermissions) {
        this.addReadPermissionOnJar("json-smart", minimalPermissions);
        minimalPermissions.add(new PropertyPermission("JSON_SMART_SIMPLE", "read"));
    }

    private void addWorkDirPermissions(Permissions minimalPermissions) {
        String userDir = System.getProperty("user.dir");
        String workdirPath = Paths.get(userDir, this.xlrConfig.repository().workDir()).toString();
        minimalPermissions.add(new FilePermission(workdirPath + File.separator + "-", "delete"));
    }

    private void addReadPermissionOnJar(String jarName, Permissions minimalPermissions) {
        String classPath = System.getProperty("java.class.path");
        String classPathSeparator = System.getProperty("path.separator");
        Pattern pattern = Pattern.compile("([^" + classPathSeparator + "]*" + jarName + "[^" + classPathSeparator + "]*)");
        Matcher matcher = pattern.matcher(classPath);
        while (matcher.find()) {
            String group = matcher.group();
            minimalPermissions.add(new FilePermission(group, "read"));
            this.logger.debug("Minimal permission added on: {}", (Object)group);
        }
    }
}

