/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.service.AttachmentService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UploadService {
    private static final Logger logger = LoggerFactory.getLogger(UploadService.class);
    private AttachmentService attachmentService;

    @Autowired
    public UploadService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    @Timed
    public List<Attachment> addAttachment(String ciId, FileItemIterator fileItems) throws IOException, FileUploadException {
        ArrayList<Attachment> attachmentList = new ArrayList<Attachment>();
        while (fileItems.hasNext()) {
            FileItemStream item = fileItems.next();
            if (item.isFormField()) continue;
            String filename = item.getName();
            String contentType = item.getContentType();
            InputStream stream = item.openStream();
            Throwable throwable = null;
            try {
                logger.debug("Attaching {} to {}", (Object)filename, (Object)ciId);
                attachmentList.add(this.attachmentService.attach(ciId, filename, contentType, stream));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        return attachmentList;
    }

    @Timed
    public Attachment addAttachment(String ciId, String fileName, byte[] fileByteArray) throws IOException {
        logger.debug("Attaching {} to {}", (Object)fileName, (Object)ciId);
        return this.attachmentService.attach(ciId, fileName, MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(fileName), new ByteArrayInputStream(fileByteArray));
    }
}

