/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.io;

import com.typesafe.config.Config;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.DirectoryStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamer;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory$;
import com.xebialabs.xldeploy.packager.io.UnsupportedArchiveExtensionException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%q!B\u0001\u0003\u0011\u0003i\u0011aD*ue\u0016\fW.\u001a:GC\u000e$xN]=\u000b\u0005\r!\u0011AA5p\u0015\t)a!\u0001\u0005qC\u000e\\\u0017mZ3s\u0015\t9\u0001\"\u0001\u0005yY\u0012,\u0007\u000f\\8z\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0005\u0011CA\bTiJ,\u0017-\\3s\r\u0006\u001cGo\u001c:z'\ty!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\u0005\u00063=!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035Aq\u0001H\bC\u0002\u0013\u0005Q$\u0001\u0004m_\u001e<WM]\u000b\u0002=A\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0006g24GG\u001b\u0006\u0002G\u0005\u0019qN]4\n\u0005\u0015\u0002#A\u0002'pO\u001e,'\u000f\u0003\u0004(\u001f\u0001\u0006IAH\u0001\bY><w-\u001a:!\u0011\u0015Is\u0002\"\u0001+\u0003=!WMZ1vYRl\u0015\r\u001d9j]\u001e\u001cH#A\u0016\u0011\u00059ac\u0001\u0002\t\u0003\u00015\u001a\"\u0001\f\n\t\u0011=b#\u0011!Q\u0001\nA\nq\"\u0019:dQ&4X-T1qa&twm\u001d\t\u0005caZ4H\u0004\u00023mA\u00111\u0007F\u0007\u0002i)\u0011Q\u0007D\u0001\u0007yI|w\u000e\u001e \n\u0005]\"\u0012A\u0002)sK\u0012,g-\u0003\u0002:u\t\u0019Q*\u00199\u000b\u0005]\"\u0002CA\u0019=\u0013\ti$H\u0001\u0004TiJLgn\u001a\u0005\u000631\"\ta\u0010\u000b\u0003W\u0001CQa\f A\u0002ABaA\u0011\u0017!\n\u0013\u0019\u0015\u0001D4fi\u0016CH/\u001a8tS>tGCA\u001eE\u0011\u0015)\u0015\t1\u0001<\u0003\u0011q\u0017-\\3\t\u000b\u001dcC\u0011\u0001%\u0002!\u001d,G/\u0011:dQ&4Xm\u0015;sK\u0006lGcA%V-B\u0011!jU\u0007\u0002\u0017*\u0011A*T\u0001\nCJ\u001c\u0007.\u001b<feNT!AT(\u0002\u0011\r|W\u000e\u001d:fgNT!\u0001U)\u0002\u000f\r|W.\\8og*\u0011!KI\u0001\u0007CB\f7\r[3\n\u0005Q[%AE!sG\"Lg/Z%oaV$8\u000b\u001e:fC6DQ!\u0012$A\u0002mBQa\u0016$A\u0002a\u000b!![:\u0011\u0005ekV\"\u0001.\u000b\u0005\rY&\"\u0001/\u0002\t)\fg/Y\u0005\u0003=j\u00131\"\u00138qkR\u001cFO]3b[\")\u0001\r\fC\u0001C\u0006I\u0011n]!sG\"Lg/\u001a\u000b\u0003E\u0016\u0004\"aE2\n\u0005\u0011$\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u000b~\u0003\ra\u000f\u0005\u0006O2\"\t\u0001[\u0001\tgR\u0014X-Y7feR\u0019\u0011\u000e\\7\u0011\u00059Q\u0017BA6\u0003\u0005!\u0019FO]3b[\u0016\u0014\b\"B,g\u0001\u0004A\u0006\"B#g\u0001\u0004Y\u0004\"B4-\t\u0003yGCA5q\u0011\u0015\th\u000e1\u0001s\u0003\u00111\u0017\u000e\\3\u0011\u0005M4X\"\u0001;\u000b\u0005UD\u0011!C8wKJ$\b.\u001a:f\u0013\t9HOA\u0007Pm\u0016\u0014H\u000f[3sK\u001aKG.\u001a\u0005\u0006s>!\tA_\u0001\nM>\u00148i\u001c8gS\u001e$\"aK>\t\u000bqD\b\u0019A?\u0002\r\r|gNZ5h!\rq\u0018QA\u0007\u0002\u007f*\u0019A0!\u0001\u000b\u0007\u0005\r!\"\u0001\u0005usB,7/\u00194f\u0013\r\t9a \u0002\u0007\u0007>tg-[4")
public class StreamerFactory {
    private final Map<String, String> archiveMappings;

    public static StreamerFactory forConfig(Config config) {
        return StreamerFactory$.MODULE$.forConfig(config);
    }

    public static StreamerFactory defaultMappings() {
        return StreamerFactory$.MODULE$.defaultMappings();
    }

    public static Logger logger() {
        return StreamerFactory$.MODULE$.logger();
    }

    private String getExtension(String name) {
        int i = name.indexOf(46);
        return i > 0 ? name.substring(i + 1) : "";
    }

    public ArchiveInputStream getArchiveStream(String name, InputStream is) {
        JarArchiveInputStream jarArchiveInputStream;
        String origExt = this.getExtension(name);
        String ext = (String)this.archiveMappings.apply((Object)origExt);
        StreamerFactory$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected mapped archive extension ", "->", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{origExt, ext, name})));
        String string = ext;
        if ("jar".equals(string)) {
            jarArchiveInputStream = new JarArchiveInputStream(is);
        } else if ("zip".equals(string)) {
            jarArchiveInputStream = new ZipArchiveInputStream(is);
        } else if ("tar".equals(string)) {
            jarArchiveInputStream = new TarArchiveInputStream(is);
        } else if ("tar.gz".equals(string)) {
            jarArchiveInputStream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(is));
        } else if ("tar.bz2".equals(string)) {
            jarArchiveInputStream = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(is));
        } else {
            throw new UnsupportedArchiveExtensionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with extension ", " mapped to ", ", which is not a supported archive"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, origExt, ext})));
        }
        return jarArchiveInputStream;
    }

    public boolean isArchive(String name) {
        String ext = this.getExtension(name);
        StreamerFactory$.MODULE$.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detecting whether ", " is an archive (Found extension ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, ext})));
        return this.archiveMappings.contains((Object)ext);
    }

    public Streamer streamer(InputStream is, String name) {
        return this.isArchive(name) ? new ArchiveStreamStreamer(is, name, this) : new FileStreamStreamer(is, name);
    }

    public Streamer streamer(OverthereFile file) {
        return file.isDirectory() ? new DirectoryStreamer(file, this) : (this.isArchive(file.getName()) ? new ArchiveStreamer(file, this) : new FileStreamer(file));
    }

    public StreamerFactory(Map<String, String> archiveMappings) {
        this.archiveMappings = archiveMappings;
    }
}

