/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.export;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.SharedConfigurationService;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiReference;
import com.xebialabs.xltype.serialization.CiWriter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnresolvedReferencesConfigurationItemConverter
extends PasswordEncryptingCiConverter {
    public static final String DECRYPTION_FAILED_VALUE = UnresolvedReferencesConfigurationItemConverter.class.getName() + ".DECRYPTION_FAILED_VALUE";
    private SharedConfigurationService sharedConfigurationService;
    private static final Logger logger = LoggerFactory.getLogger(UnresolvedReferencesConfigurationItemConverter.class);

    public UnresolvedReferencesConfigurationItemConverter(SharedConfigurationService sharedConfigurationService) {
        this.sharedConfigurationService = sharedConfigurationService;
    }

    protected void writeCiProperty(Object value, PropertyDescriptor propertyDescriptor, CiWriter writer) {
        ConfigurationItem ci;
        if (value instanceof ConfigurationItem && Ids.isCustomConfigurationId((String)(ci = (ConfigurationItem)value).getId())) {
            writer.ciReference(Ids.CUSTOM_CONFIGURATION_ROOT + "/" + ci.getProperty("title"));
            return;
        }
        super.writeCiProperty(value, propertyDescriptor, writer);
    }

    public void resolveReferences(Repository repository) {
        for (CiReference reference : this.getReferences()) {
            ArrayList resolvedCIs = Lists.newArrayList();
            for (String id : reference.getIds()) {
                ConfigurationItem alsoRead = (ConfigurationItem)this.getReadCIs().get(id);
                if (alsoRead != null) {
                    resolvedCIs.add(alsoRead);
                    continue;
                }
                ConfigurationItem ci = repository.read(id);
                if (ci != null) {
                    resolvedCIs.add(ci);
                    continue;
                }
                if (!Ids.isCustomConfigurationId((String)id)) continue;
                String name = Ids.getName((String)id);
                List<Configuration> list = this.sharedConfigurationService.searchByTypeAndTitle(reference.getProperty().getReferencedType(), name);
                if (list.size() != 1) continue;
                resolvedCIs.add(repository.read(list.get(0).getId()));
            }
            reference.set((List)resolvedCIs);
        }
    }

    protected void readStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        if (propertyDescriptor.isPassword()) {
            try {
                super.readStringProperty(configurationItem, propertyDescriptor, reader);
            }
            catch (Exception exception) {
                propertyDescriptor.set(configurationItem, (Object)DECRYPTION_FAILED_VALUE);
                logger.info("Failed to read password field: '{}' with value: '{}'", new Object[]{propertyDescriptor, reader.getStringValue(), exception});
            }
        } else {
            super.readStringProperty(configurationItem, propertyDescriptor, reader);
        }
    }
}

