/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.CiListAsReferencesReader;
import com.xebialabs.xlrelease.repository.CiListMemoryReader;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

public class CiMemoryReader
implements CiReader {
    protected final ConfigurationItem ci;
    private final Iterator<PropertyDescriptor> propertyIterator;
    private PropertyDescriptor currentProperty;

    public CiMemoryReader(ConfigurationItem ci) {
        this.ci = ci;
        this.propertyIterator = this.ci.getType().getDescriptor().getPropertyDescriptors().iterator();
    }

    public String getType() {
        return this.ci.getType().toString();
    }

    public String getId() {
        return this.ci.getId();
    }

    public String getToken() {
        if (this.ci instanceof BaseConfigurationItem) {
            return ((BaseConfigurationItem)this.ci).get$token();
        }
        return null;
    }

    public CiAttributes getCiAttributes() {
        if (this.ci instanceof BaseConfigurationItem) {
            return ((BaseConfigurationItem)this.ci).get$ciAttributes();
        }
        return null;
    }

    public boolean hasMoreProperties() {
        return this.propertyIterator.hasNext();
    }

    public void moveIntoProperty() {
        this.currentProperty = this.propertyIterator.next();
    }

    public CiReader moveIntoNestedProperty() {
        ConfigurationItem nestedCi = (ConfigurationItem)this.currentProperty.get(this.ci);
        return new CiMemoryReader(nestedCi);
    }

    public void moveOutOfProperty() {
    }

    public String getCurrentPropertyName() {
        return this.currentProperty.getName();
    }

    public String getStringValue() {
        Object value = this.currentProperty.get(this.ci);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime((Date)value);
            return DatatypeConverter.printDateTime((Calendar)calendar);
        }
        if (value instanceof ConfigurationItem) {
            return ((ConfigurationItem)value).getId();
        }
        return String.valueOf(value);
    }

    public List<String> getStringValues() {
        Collection values = (Collection)this.currentProperty.get(this.ci);
        return values == null ? null : new ArrayList(values);
    }

    public Map<String, String> getStringMap() {
        Map values = (Map)this.currentProperty.get(this.ci);
        return values == null ? null : new LinkedHashMap(values);
    }

    public boolean isCiReference() {
        if (this.currentProperty == null || this.currentProperty.getKind() != PropertyKind.CI) {
            return false;
        }
        ConfigurationItem value = (ConfigurationItem)this.currentProperty.get(this.ci);
        return value == null || !CiHelper.isChildViaOneOfChildProperties((ConfigurationItem)value, (ConfigurationItem)this.ci);
    }

    public String getCiReference() {
        return this.getStringValue();
    }

    public List<String> getCiReferences() {
        return this.getStringValues();
    }

    public CiListReader getCurrentCiListReader() {
        Collection referencedCis = (Collection)this.currentProperty.get(this.ci);
        if (this.currentProperty.isAsContainment()) {
            return new CiListMemoryReader(referencedCis);
        }
        return new CiListAsReferencesReader(referencedCis);
    }

    public List<ValidationMessage> getValidationMessages() {
        return Collections.emptyList();
    }
}

