/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.git;

import com.xebialabs.xlrelease.plugin.git.GitConnectionSettings;
import com.xebialabs.xlrelease.plugin.git.XlrGitHttpConnectionFactory;
import java.util.Collection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;

public class GitClient {
    static final ThreadLocal<GitConnectionSettings> currentGitConnectionSettings = new ThreadLocal();

    public GitClient(GitConnectionSettings gitConnectionSettings) {
        currentGitConnectionSettings.set(gitConnectionSettings);
    }

    public String getLatestRevision() throws GitAPIException {
        return this.getLatestRevisionObjectId().getName();
    }

    public ObjectId getLatestRevisionObjectId() throws GitAPIException {
        Collection<Ref> refs = this.fetchRemoteReferences();
        String branch = currentGitConnectionSettings.get().getBranch();
        return branch != null && !branch.isEmpty() ? this.findBranchSha1(refs, currentGitConnectionSettings.get().getBranch()) : this.findDefaultBranchSha1(refs);
    }

    private Collection<Ref> fetchRemoteReferences() throws GitAPIException {
        LsRemoteCommand lsRemoteCommand = Git.lsRemoteRepository().setRemote(currentGitConnectionSettings.get().getUrl()).setTags(false);
        return lsRemoteCommand.call();
    }

    private ObjectId findBranchSha1(Collection<Ref> refs, String branch) {
        return this.findSha1(refs, "refs/heads/" + branch);
    }

    private ObjectId findDefaultBranchSha1(Collection<Ref> refs) {
        return this.findSha1(refs, "HEAD");
    }

    private ObjectId findSha1(Collection<Ref> refs, String input) {
        for (Ref ref : refs) {
            if (!ref.getName().equals(input)) continue;
            return ref.getObjectId();
        }
        throw new IllegalArgumentException(String.format("'%s' not found on %s", input, currentGitConnectionSettings.get().getUrl()));
    }

    static {
        HttpTransport.setConnectionFactory((HttpConnectionFactory)new XlrGitHttpConnectionFactory());
    }
}

