/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.DefaultCiProperty;
import com.xebialabs.xlrelease.repository.IndexedCiProperty;
import com.xebialabs.xlrelease.repository.ListOfStringCiProperty;
import com.xebialabs.xlrelease.repository.MapStringStringCiProperty;
import com.xebialabs.xlrelease.repository.SetOfStringCiProperty;
import com.xebialabs.xlrelease.repository.StringCiProperty;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CiProperty {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\.");
    private CiProperty wrapped;
    private Property lastProperty;
    private ConfigurationItem parent;
    private boolean exists = true;
    private static Map<PropertyKind, Function<CiProperty, CiProperty>> ciPropertyBuilderPerKind = ImmutableMap.of((Object)PropertyKind.STRING, StringCiProperty::new, (Object)PropertyKind.LIST_OF_STRING, ListOfStringCiProperty::new, (Object)PropertyKind.SET_OF_STRING, SetOfStringCiProperty::new, (Object)PropertyKind.MAP_STRING_STRING, MapStringStringCiProperty::new);

    public static Optional<CiProperty> of(ConfigurationItem rootCi, String fqPropertyExpression) {
        CiProperty ciProperty = new DefaultCiProperty(rootCi, fqPropertyExpression);
        if (ciProperty.exists()) {
            if (ciProperty.isIndexed()) {
                ciProperty = new IndexedCiProperty(ciProperty, ciProperty.lastProperty.index);
            }
            if (ciPropertyBuilderPerKind.containsKey(ciProperty.getKind())) {
                ciProperty = ciPropertyBuilderPerKind.get(ciProperty.getKind()).apply(ciProperty);
            }
            return Optional.of(ciProperty);
        }
        return Optional.empty();
    }

    protected CiProperty(CiProperty wrapped) {
        this.parent = wrapped.parent;
        this.exists = wrapped.exists;
        this.lastProperty = wrapped.lastProperty;
        this.wrapped = wrapped;
    }

    protected CiProperty(ConfigurationItem rootCi, String fqPropertyExpression) {
        Optional<Object> newParent = Optional.ofNullable(rootCi);
        for (String propertyExpression : PROPERTY_PATTERN.split(fqPropertyExpression)) {
            if (newParent.isPresent()) {
                this.parent = newParent.get();
                this.lastProperty = Property.of(propertyExpression);
                if (this.parent.hasProperty(this.lastProperty.propertyName)) {
                    Collection collection;
                    newParent = Optional.ofNullable(this.getDescriptor().get(this.getParentCi()));
                    if (!this.lastProperty.isIndexed() || (newParent = (collection = (Collection)newParent.orElse(Collections.emptyList())).stream().skip(this.lastProperty.index.intValue()).findFirst()).isPresent()) continue;
                    this.exists = false;
                    break;
                }
                this.exists = false;
                break;
            }
            this.exists = false;
            break;
        }
    }

    public String getPropertyName() {
        return this.lastProperty.propertyName;
    }

    public <T> T getValue() {
        return this.wrapped.getValue();
    }

    public void setValue(Object value) {
        this.wrapped.setValue(value);
    }

    public ConfigurationItem getParentCi() {
        return this.parent;
    }

    public PropertyDescriptor getDescriptor() {
        return this.parent.getType().getDescriptor().getPropertyDescriptor(this.lastProperty.propertyName);
    }

    public PropertyKind getKind() {
        return this.getDescriptor().getKind();
    }

    public String getCategory() {
        return this.getDescriptor().getCategory();
    }

    public boolean isPassword() {
        return this.getDescriptor().isPassword();
    }

    public boolean isIndexed() {
        return this.lastProperty.isIndexed();
    }

    public boolean exists() {
        return this.exists;
    }

    public void replaceInValue(Variable variable, VariableOrValue replacement) {
        String newValue;
        String key = VariableHelper.withVariableSyntax(variable.getKey());
        if (replacement.getVariable() != null) {
            newValue = VariableHelper.formatVariableIfNeeded(replacement.getVariable());
        } else {
            Variable dummy = (Variable)variable.getType().getDescriptor().newInstance("dummy");
            dummy.setUntypedValue(replacement.getValue());
            newValue = dummy.getValueAsString();
        }
        this.replaceInStrings(key, newValue);
    }

    protected abstract void replaceInStrings(String var1, String var2);

    private static class Property {
        private String INDEXED_PROPERTY_PATTERN = "^([^\\.\\[\\]]+)\\[(\\d+)\\]$";
        String propertyName;
        Integer index;

        public static Property of(String expression) {
            return new Property(expression);
        }

        public boolean isIndexed() {
            return null != this.index;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Property(String expression) {
            if (this.isIndexed(expression)) {
                Matcher matcher = Pattern.compile(this.INDEXED_PROPERTY_PATTERN).matcher(expression);
                if (!matcher.matches()) throw new IllegalStateException(String.format("Expression '%s' is not indexed propery.", expression));
                this.propertyName = matcher.group(1);
                this.index = Integer.valueOf(matcher.group(2));
                return;
            } else {
                this.propertyName = expression;
            }
        }

        private boolean isIndexed(String expression) {
            return expression.matches(this.INDEXED_PROPERTY_PATTERN);
        }
    }
}

