/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.approval;

import java.util.Calendar;
import java.util.Date;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.security.oauth2.common.util.JsonDateDeserializer;
import org.springframework.security.oauth2.common.util.JsonDateSerializer;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Approval {
    private String userId;
    private String clientId;
    private String scope;
    private ApprovalStatus status;
    private Date expiresAt;
    private Date lastUpdatedAt;

    public Approval(String userId, String clientId, String scope, int expiresIn, ApprovalStatus status) {
        this(userId, clientId, scope, new Date(), status, new Date());
        Calendar expiresAt = Calendar.getInstance();
        expiresAt.add(14, expiresIn);
        this.setExpiresAt(expiresAt.getTime());
    }

    public Approval(String userId, String clientId, String scope, Date expiresAt, ApprovalStatus status) {
        this(userId, clientId, scope, expiresAt, status, new Date());
    }

    public Approval(String userId, String clientId, String scope, Date expiresAt, ApprovalStatus status, Date lastUpdatedAt) {
        this.setUserId(userId);
        this.setClientId(clientId);
        this.setScope(scope);
        this.setExpiresAt(expiresAt);
        this.status = status;
        this.lastUpdatedAt = lastUpdatedAt;
    }

    protected Approval() {
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId == null ? "" : userId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId == null ? "" : clientId;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope == null ? "" : scope;
    }

    @JsonSerialize(using=JsonDateSerializer.class, include=JsonSerialize.Inclusion.NON_NULL)
    public Date getExpiresAt() {
        return this.expiresAt;
    }

    @JsonDeserialize(using=JsonDateDeserializer.class)
    public void setExpiresAt(Date expiresAt) {
        if (expiresAt == null) {
            Calendar thirtyMinFromNow = Calendar.getInstance();
            thirtyMinFromNow.add(12, 30);
            expiresAt = thirtyMinFromNow.getTime();
        }
        this.expiresAt = expiresAt;
    }

    @JsonSerialize(using=JsonDateSerializer.class, include=JsonSerialize.Inclusion.NON_NULL)
    public Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    @JsonDeserialize(using=JsonDateDeserializer.class)
    public void setLastUpdatedAt(Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    @JsonIgnore
    public boolean isCurrentlyActive() {
        return this.expiresAt != null && this.expiresAt.after(new Date());
    }

    @JsonIgnore
    public boolean isApproved() {
        return this.isCurrentlyActive() && this.status == ApprovalStatus.APPROVED;
    }

    public void setStatus(ApprovalStatus status) {
        this.status = status;
    }

    public ApprovalStatus getStatus() {
        return this.status;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.userId.hashCode();
        result = 31 * result + this.clientId.hashCode();
        result = 31 * result + this.scope.hashCode();
        result = 31 * result + this.status.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Approval)) {
            return false;
        }
        Approval other = (Approval)o;
        return this.userId.equals(other.userId) && this.clientId.equals(other.clientId) && this.scope.equals(other.scope) && this.status == other.status;
    }

    public String toString() {
        return String.format("[%s, %s, %s, %s, %s, %s]", this.userId, this.scope, this.clientId, this.expiresAt, this.status.toString(), this.lastUpdatedAt);
    }

    public static enum ApprovalStatus {
        APPROVED,
        DENIED;

    }
}

