/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.io.ArtifactAwareFile;
import com.xebialabs.deployit.io.ArtifactByteSource;
import com.xebialabs.deployit.io.ArtifactFile;
import com.xebialabs.deployit.io.Exploder;
import com.xebialabs.deployit.io.ResolvedArtifactInputStream;
import com.xebialabs.deployit.io.WorkDirInContext;
import com.xebialabs.deployit.io.WorkDirSupplier;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceArtifactFile
extends ArtifactFile
implements ArtifactAwareFile,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(SourceArtifactFile.class);
    private final SourceArtifact sourceArtifact;
    private final Supplier<WorkDir> workDirSupplier;
    private final String fileName;
    private transient OverthereFile resolvedFile;

    private SourceArtifactFile(String fileName, SourceArtifact sourceArtifact, Supplier<WorkDir> workDirSupplier) {
        this.fileName = fileName;
        this.sourceArtifact = sourceArtifact;
        this.workDirSupplier = workDirSupplier;
    }

    @Override
    protected synchronized OverthereFile getLazyFile() {
        if (this.workDirSupplier.get() == null) {
            throw new RuntimeException("Cannot resolve source artifact without a working directory");
        }
        if (this.resolvedFile == null) {
            this.resolvedFile = this.resolveToLocalFile();
        }
        return this.resolvedFile;
    }

    @Override
    public InputStream getRawStream() {
        return new ResolvedArtifactInputStream(this.resolve());
    }

    @Override
    public boolean isResolvable() {
        return this.isResolved() || this.workDirSupplier.get() != null;
    }

    @Override
    public boolean isResolved() {
        return this.resolvedFile != null;
    }

    private LocalFile resolveToLocalFile() {
        LocalFile localFile = this.workDirSupplier.get().newFile(this.getName());
        logger.trace("Resolving SourceArtifact to: {}", (Object)localFile.getPath());
        ResolvedArtifactFile resolvedArtifactFile = this.resolve();
        try {
            if (this.isDirectory()) {
                this.resolveDirectory(localFile, resolvedArtifactFile);
            } else {
                this.resolveFile(localFile, resolvedArtifactFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot resolve artifact " + this.sourceArtifact.getId(), e);
        }
        return localFile;
    }

    private ResolvedArtifactFile resolve() {
        return ArtifactResolverRegistry.resolve(this.sourceArtifact);
    }

    private void resolveFile(LocalFile localFile, ResolvedArtifactFile resolvedArtifactFile) throws IOException {
        try (ArtifactByteSource artifactByteSource = new ArtifactByteSource(resolvedArtifactFile);
             OutputStream outputStream = localFile.getOutputStream();
             InputStream is = artifactByteSource.get();){
            OverthereUtils.write((InputStream)is, (OutputStream)outputStream);
        }
    }

    private void resolveDirectory(LocalFile localFile, ResolvedArtifactFile resolvedArtifactFile) throws IOException {
        localFile.mkdir();
        try (ArtifactByteSource artifactByteSource = new ArtifactByteSource(resolvedArtifactFile);){
            Exploder.explode(artifactByteSource, localFile.getFile(), null);
        }
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public boolean exists() {
        return this.resolvedFile == null || this.resolvedFile.exists();
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    public boolean isDirectory() {
        return this.sourceArtifact instanceof FolderArtifact;
    }

    @Override
    public Artifact underlyingArtifact() {
        return this.sourceArtifact;
    }

    public String toString() {
        return this.getLazyFile().toString();
    }

    public static SourceArtifactFile withNullableWorkDir(String fileName, SourceArtifact sourceArtifact, WorkDir workDir) {
        Checks.checkArgument((fileName != null ? 1 : 0) != 0, (String)"File name cannot be null", (Object[])new Object[0]);
        if (workDir == null) {
            return new SourceArtifactFile(fileName, sourceArtifact, new WorkDirInContext());
        }
        return new SourceArtifactFile(fileName, sourceArtifact, new WorkDirSupplier(workDir));
    }
}

