/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import javax.jcr.NamespaceException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.api.jsr283.nodetype.NodeTypeDefinition;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeDefinitionImpl
implements NodeTypeDefinition {
    private static Logger log = LoggerFactory.getLogger((Class)NodeTypeDefinitionImpl.class);
    private final NodeTypeDef ntd;
    private final NamePathResolver resolver;

    public NodeTypeDefinitionImpl(NodeTypeDef ntd, NamePathResolver resolver) {
        this.ntd = ntd;
        this.resolver = resolver;
    }

    public String getName() {
        try {
            return this.resolver.getJCRName(this.ntd.getName());
        }
        catch (NamespaceException e) {
            log.error("encountered unregistered namespace in node type name", (Throwable)e);
            return this.ntd.getName().toString();
        }
    }

    public String[] getDeclaredSupertypeNames() {
        Name[] ntNames = this.ntd.getSupertypes();
        String[] supertypes = new String[ntNames.length];
        for (int i = 0; i < ntNames.length; ++i) {
            try {
                supertypes[i] = this.resolver.getJCRName(this.ntd.getName());
                continue;
            }
            catch (NamespaceException e) {
                log.error("encountered unregistered namespace in node type name", (Throwable)e);
                supertypes[i] = this.ntd.getName().toString();
            }
        }
        return supertypes;
    }

    public boolean isAbstract() {
        return this.ntd.isAbstract();
    }

    public boolean isMixin() {
        return this.ntd.isMixin();
    }

    public boolean hasOrderableChildNodes() {
        return this.ntd.hasOrderableChildNodes();
    }

    public String getPrimaryItemName() {
        try {
            Name piName = this.ntd.getPrimaryItemName();
            if (piName != null) {
                return this.resolver.getJCRName(piName);
            }
            return null;
        }
        catch (NamespaceException e) {
            log.error("encountered unregistered namespace in name of primary item", (Throwable)e);
            return this.ntd.getName().toString();
        }
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        NodeDef[] cnda = this.ntd.getChildNodeDefs();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        for (int i = 0; i < cnda.length; ++i) {
            nodeDefs[i] = new NodeDefinitionImpl(cnda[i], null, this.resolver);
        }
        return nodeDefs;
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        PropDef[] pda = this.ntd.getPropertyDefs();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        for (int i = 0; i < pda.length; ++i) {
            propDefs[i] = new PropertyDefinitionImpl(pda[i], null, this.resolver);
        }
        return propDefs;
    }
}

