/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.data;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Arrays;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnfoldingReader
extends PushbackReader {
    private Log log;
    private static final char[] DEFAULT_FOLD_PATTERN_1 = new char[]{'\r', '\n', ' '};
    private static final char[] DEFAULT_FOLD_PATTERN_2 = new char[]{'\r', '\n', '\t'};
    private static final char[] RELAXED_FOLD_PATTERN_1 = new char[]{'\n', ' '};
    private static final char[] RELAXED_FOLD_PATTERN_2 = new char[]{'\n', '\t'};
    private char[][] patterns;
    private char[][] buffers;
    private int linesUnfolded;
    private int maxPatternLength;
    static /* synthetic */ Class class$0;

    public UnfoldingReader(Reader in) {
        this(in, DEFAULT_FOLD_PATTERN_1.length, CompatibilityHints.isHintEnabled("ical4j.unfolding.relaxed"));
    }

    public UnfoldingReader(Reader in, int size) {
        this(in, size, CompatibilityHints.isHintEnabled("ical4j.unfolding.relaxed"));
    }

    public UnfoldingReader(Reader in, boolean relaxed) {
        this(in, DEFAULT_FOLD_PATTERN_1.length, relaxed);
    }

    public UnfoldingReader(Reader in, int size, boolean relaxed) {
        super(in, size);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.fortuna.ical4j.data.UnfoldingReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.maxPatternLength = 0;
        if (relaxed) {
            this.patterns = new char[4][];
            this.patterns[0] = DEFAULT_FOLD_PATTERN_1;
            this.patterns[1] = DEFAULT_FOLD_PATTERN_2;
            this.patterns[2] = RELAXED_FOLD_PATTERN_1;
            this.patterns[3] = RELAXED_FOLD_PATTERN_2;
        } else {
            this.patterns = new char[2][];
            this.patterns[0] = DEFAULT_FOLD_PATTERN_1;
            this.patterns[1] = DEFAULT_FOLD_PATTERN_2;
        }
        this.buffers = new char[this.patterns.length][];
        int i = 0;
        while (i < this.patterns.length) {
            this.buffers[i] = new char[this.patterns[i].length];
            this.maxPatternLength = Math.max(this.maxPatternLength, this.patterns[i].length);
            ++i;
        }
    }

    public final int getLinesUnfolded() {
        return this.linesUnfolded;
    }

    public final int read() throws IOException {
        int c = super.read();
        boolean doUnfold = false;
        int i = 0;
        while (i < this.patterns.length) {
            if (c == this.patterns[i][0]) {
                doUnfold = true;
                break;
            }
            ++i;
        }
        if (!doUnfold) {
            return c;
        }
        this.unread(c);
        this.unfold();
        return super.read();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = super.read(cbuf, off, len);
        boolean doUnfold = false;
        int i = 0;
        while (i < this.patterns.length) {
            if (read > 0 && cbuf[0] == this.patterns[i][0]) {
                doUnfold = true;
                break;
            }
            int j = 0;
            while (j < read) {
                if (cbuf[j] == this.patterns[i][0]) {
                    this.unread(cbuf, j, read - j);
                    return j;
                }
                ++j;
            }
            ++i;
        }
        if (!doUnfold) {
            return read;
        }
        this.unread(cbuf, off, read);
        this.unfold();
        return super.read(cbuf, off, this.maxPatternLength);
    }

    private void unfold() throws IOException {
        boolean didUnfold;
        do {
            didUnfold = false;
            int i = 0;
            while (i < this.buffers.length) {
                int read = 0;
                while (read < this.buffers[i].length) {
                    int partialRead = super.read(this.buffers[i], read, this.buffers[i].length - read);
                    if (partialRead < 0) break;
                    read += partialRead;
                }
                if (read > 0) {
                    if (!Arrays.equals(this.patterns[i], this.buffers[i])) {
                        this.unread(this.buffers[i], 0, read);
                    } else {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Unfolding...");
                        }
                        ++this.linesUnfolded;
                        didUnfold = true;
                    }
                }
                ++i;
            }
        } while (didUnfold);
    }
}

