/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.DateRange;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.Validator;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.FbType;
import net.fortuna.ical4j.model.property.Contact;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.PropertyValidator;

public class VFreeBusy
extends CalendarComponent {
    private static final long serialVersionUID = 1046534053331139832L;
    private final Map methodValidators = new HashMap();

    public VFreeBusy() {
        super("VFREEBUSY");
        this.methodValidators.put(Method.PUBLISH, new PublishValidator());
        this.methodValidators.put(Method.REPLY, new ReplyValidator());
        this.methodValidators.put(Method.REQUEST, new RequestValidator());
        this.getProperties().add(new DtStamp());
    }

    public VFreeBusy(PropertyList properties) {
        super("VFREEBUSY", properties);
        this.methodValidators.put(Method.PUBLISH, new PublishValidator());
        this.methodValidators.put(Method.REPLY, new ReplyValidator());
        this.methodValidators.put(Method.REQUEST, new RequestValidator());
    }

    public VFreeBusy(DateTime start, DateTime end) {
        this();
        this.getProperties().add(new DtStart(start, true));
        this.getProperties().add(new DtEnd(end, true));
    }

    public VFreeBusy(DateTime start, DateTime end, Dur duration) {
        this();
        this.getProperties().add(new DtStart(start, true));
        this.getProperties().add(new DtEnd(end, true));
        this.getProperties().add(new Duration(duration));
    }

    public VFreeBusy(VFreeBusy request, ComponentList components) {
        this();
        DtStart start = (DtStart)request.getProperty("DTSTART");
        DtEnd end = (DtEnd)request.getProperty("DTEND");
        Duration duration = (Duration)request.getProperty("DURATION");
        this.getProperties().add(new DtStart(start.getDate(), true));
        this.getProperties().add(new DtEnd(end.getDate(), true));
        if (duration != null) {
            this.getProperties().add(new Duration(duration.getDuration()));
            DateTime freeStart = new DateTime(start.getDate());
            DateTime freeEnd = new DateTime(end.getDate());
            FreeBusy fb = new FreeTimeBuilder().start(freeStart).end(freeEnd).duration(duration.getDuration()).components(components).build();
            if (fb != null && !fb.getPeriods().isEmpty()) {
                this.getProperties().add(fb);
            }
        } else {
            DateTime busyStart = new DateTime(start.getDate());
            DateTime busyEnd = new DateTime(end.getDate());
            FreeBusy fb = new BusyTimeBuilder().start(busyStart).end(busyEnd).components(components).build();
            if (fb != null && !fb.getPeriods().isEmpty()) {
                this.getProperties().add(fb);
            }
        }
    }

    private PeriodList getConsumedTime(ComponentList components, DateTime rangeStart, DateTime rangeEnd) {
        PeriodList periods = new PeriodList();
        Iterator i = components.getComponents("VEVENT").iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            periods.addAll((Collection)((VEvent)component).getConsumedTime(rangeStart, rangeEnd, false));
        }
        return periods.normalise();
    }

    public final void validate(boolean recurse) throws ValidationException {
        if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
            PropertyValidator.getInstance().assertOne("UID", this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        }
        PropertyValidator validator = PropertyValidator.getInstance();
        validator.assertOneOrLess("CONTACT", this.getProperties());
        validator.assertOneOrLess("DTSTART", this.getProperties());
        validator.assertOneOrLess("DTEND", this.getProperties());
        validator.assertOneOrLess("DURATION", this.getProperties());
        validator.assertOneOrLess("DTSTAMP", this.getProperties());
        validator.assertOneOrLess("ORGANIZER", this.getProperties());
        validator.assertOneOrLess("UID", this.getProperties());
        validator.assertOneOrLess("URL", this.getProperties());
        validator.assertNone("RRULE", this.getProperties());
        validator.assertNone("EXRULE", this.getProperties());
        validator.assertNone("RDATE", this.getProperties());
        validator.assertNone("EXDATE", this.getProperties());
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        if (dtStart != null && !dtStart.isUtc()) {
            throw new ValidationException("DTSTART must be specified in UTC time");
        }
        DtEnd dtEnd = (DtEnd)this.getProperty("DTEND");
        if (dtEnd != null && !dtEnd.isUtc()) {
            throw new ValidationException("DTEND must be specified in UTC time");
        }
        if (dtStart != null && dtEnd != null && !dtStart.getDate().before(dtEnd.getDate())) {
            throw new ValidationException("Property [DTEND] must be later in time than [DTSTART]");
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    protected Validator getValidator(Method method) {
        return (Validator)this.methodValidators.get(method);
    }

    public final Contact getContact() {
        return (Contact)this.getProperty("CONTACT");
    }

    public final DtStart getStartDate() {
        return (DtStart)this.getProperty("DTSTART");
    }

    public final DtEnd getEndDate() {
        return (DtEnd)this.getProperty("DTEND");
    }

    public final Duration getDuration() {
        return (Duration)this.getProperty("DURATION");
    }

    public final DtStamp getDateStamp() {
        return (DtStamp)this.getProperty("DTSTAMP");
    }

    public final Organizer getOrganizer() {
        return (Organizer)this.getProperty("ORGANIZER");
    }

    public final Url getUrl() {
        return (Url)this.getProperty("URL");
    }

    public final Uid getUid() {
        return (Uid)this.getProperty("UID");
    }

    private class BusyTimeBuilder {
        private DateTime start;
        private DateTime end;
        private ComponentList components;

        private BusyTimeBuilder() {
        }

        public BusyTimeBuilder start(DateTime start) {
            this.start = start;
            return this;
        }

        public BusyTimeBuilder end(DateTime end) {
            this.end = end;
            return this;
        }

        public BusyTimeBuilder components(ComponentList components) {
            this.components = components;
            return this;
        }

        public FreeBusy build() {
            PeriodList periods = VFreeBusy.this.getConsumedTime(this.components, this.start, this.end);
            DateRange range = new DateRange(this.start, this.end);
            periods.setUtc(true);
            Iterator i = periods.iterator();
            while (i.hasNext()) {
                Period period = (Period)i.next();
                if (range.intersects(period)) continue;
                i.remove();
            }
            return new FreeBusy(periods);
        }
    }

    private class FreeTimeBuilder {
        private DateTime start;
        private DateTime end;
        private Dur duration;
        private ComponentList components;

        private FreeTimeBuilder() {
        }

        public FreeTimeBuilder start(DateTime start) {
            this.start = start;
            return this;
        }

        public FreeTimeBuilder end(DateTime end) {
            this.end = end;
            return this;
        }

        private FreeTimeBuilder duration(Dur duration) {
            this.duration = duration;
            return this;
        }

        public FreeTimeBuilder components(ComponentList components) {
            this.components = components;
            return this;
        }

        public FreeBusy build() {
            FreeBusy fb = new FreeBusy();
            fb.getParameters().add(FbType.FREE);
            PeriodList periods = VFreeBusy.this.getConsumedTime(this.components, this.start, this.end);
            DateRange range = new DateRange(this.start, this.end);
            periods.add(new Period(this.end, this.end));
            DateTime lastPeriodEnd = new DateTime(this.start);
            Iterator i = periods.iterator();
            while (i.hasNext()) {
                Duration freeDuration;
                Period period = (Period)i.next();
                if ((range.contains(period) || range.intersects(period) && period.getStart().after(range.getRangeStart())) && (freeDuration = new Duration(lastPeriodEnd, period.getStart())).getDuration().compareTo(this.duration) >= 0) {
                    fb.getPeriods().add(new Period(lastPeriodEnd, freeDuration.getDuration()));
                }
                if (!period.getEnd().after(lastPeriodEnd)) continue;
                lastPeriodEnd = period.getEnd();
            }
            return fb;
        }
    }

    private class PublishValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private PublishValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOneOrMore("FREEBUSY", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTART", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTEND", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone("ATTENDEE", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone("DURATION", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone("REQUEST-STATUS", VFreeBusy.this.getProperties());
        }
    }

    private class ReplyValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private ReplyValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("ATTENDEE", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTEND", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTART", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone("DURATION", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone("SEQUENCE", VFreeBusy.this.getProperties());
        }
    }

    private class RequestValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private RequestValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOneOrMore("ATTENDEE", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTEND", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTART", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone("FREEBUSY", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone("DURATION", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone("REQUEST-STATUS", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone("URL", VFreeBusy.this.getProperties());
        }
    }
}

