/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.nio.ByteBuffer;
import jnr.ffi.Pointer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.UnsafeBuffer;
import org.lmdbjava.BufferProxy;
import org.lmdbjava.UnsafeAccess;

public final class DirectBufferProxy
extends BufferProxy<DirectBuffer> {
    public static final BufferProxy<DirectBuffer> PROXY_DB = new DirectBufferProxy();
    private static final ThreadLocal<OneToOneConcurrentArrayQueue<DirectBuffer>> BUFFERS = ThreadLocal.withInitial(() -> new OneToOneConcurrentArrayQueue(16));

    @Override
    protected DirectBuffer allocate() {
        OneToOneConcurrentArrayQueue<DirectBuffer> q = BUFFERS.get();
        DirectBuffer buffer = (DirectBuffer)q.poll();
        if (buffer != null && buffer.capacity() >= 0) {
            return buffer;
        }
        ByteBuffer bb = ByteBuffer.allocateDirect(0);
        return new UnsafeBuffer(bb);
    }

    @Override
    protected void deallocate(DirectBuffer buff) {
        OneToOneConcurrentArrayQueue<DirectBuffer> q = BUFFERS.get();
        q.offer((Object)buff);
    }

    @Override
    protected byte[] getBytes(DirectBuffer buffer) {
        byte[] dest = new byte[buffer.capacity()];
        buffer.getBytes(0, dest, 0, buffer.capacity());
        return dest;
    }

    @Override
    protected void in(DirectBuffer buffer, Pointer ptr, long ptrAddr) {
        long addr = buffer.addressOffset();
        long size = buffer.capacity();
        UnsafeAccess.UNSAFE.putLong(ptrAddr + 8L, addr);
        UnsafeAccess.UNSAFE.putLong(ptrAddr + 0L, size);
    }

    @Override
    protected void in(DirectBuffer buffer, int size, Pointer ptr, long ptrAddr) {
        long addr = buffer.addressOffset();
        UnsafeAccess.UNSAFE.putLong(ptrAddr + 8L, addr);
        UnsafeAccess.UNSAFE.putLong(ptrAddr + 0L, size);
    }

    @Override
    protected DirectBuffer out(DirectBuffer buffer, Pointer ptr, long ptrAddr) {
        long addr = UnsafeAccess.UNSAFE.getLong(ptrAddr + 8L);
        long size = UnsafeAccess.UNSAFE.getLong(ptrAddr + 0L);
        buffer.wrap(addr, (int)size);
        return buffer;
    }
}

