/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.google.common.base.Preconditions;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.dsl.service.DslExporter;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ReleaseService;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/dsl")
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class DslApi
implements ApiService {
    private static final String RELEASEFILE = "Releasefile.groovy";
    private PermissionChecker permissions;
    private ReleaseService releaseService;
    private DslExporter dslExporter;

    @Autowired
    public DslApi(PermissionChecker permissions, ReleaseService releaseService, DslExporter dslExporter) {
        this.permissions = permissions;
        this.releaseService = releaseService;
        this.dslExporter = dslExporter;
    }

    public String serviceName() {
        return "dslApi";
    }

    @GET
    @Path(value="/export/{templateId:.*Release[^/]*}")
    @Produces(value={"text/plain"})
    public Response exportTemplateToXFile(@PathParam(value="templateId") String templateId, @QueryParam(value="exportTemplate") boolean asTemplate) {
        this.permissions.checkView(templateId);
        Preconditions.checkArgument((boolean)this.releaseService.isTemplate(templateId), (Object)"Only templates can be exported.");
        Release template = this.releaseService.findById(templateId);
        StreamingOutput output = outputStream -> this.dslExporter.exportTemplate(template, outputStream, asTemplate);
        return Response.ok((Object)output, (String)"text/plain").header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", RELEASEFILE)).build();
    }

    @PublicApiMember
    public String exportTemplate(Release template) {
        return this.exportTemplate(template, false);
    }

    @PublicApiMember
    public String exportTemplate(Release template, boolean asTemplate) {
        return this.apiExportTemplate(template, asTemplate);
    }

    private String apiExportTemplate(Release template, boolean renderAsTemplate) {
        Preconditions.checkArgument((boolean)this.releaseService.isTemplate(template.getId()), (Object)"Only templates can be exported.");
        this.permissions.checkView(template.getId());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.dslExporter.exportTemplate(template, baos, renderAsTemplate);
        try {
            return baos.toString(StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

