/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.dsl.service.CiProcessor;
import com.xebialabs.xlrelease.dsl.service.DslError;
import com.xebialabs.xlrelease.dsl.service.DslProcessingContext;
import com.xebialabs.xlrelease.dsl.service.PathUtils;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CreateReleaseTaskCiProcessor
implements CiProcessor<CreateReleaseTask> {
    private ReleaseService releaseService;
    private FolderService folderService;
    private PermissionChecker permissionChecker;

    @Autowired
    public CreateReleaseTaskCiProcessor(ReleaseService releaseService, FolderService folderService, PermissionChecker permissionChecker) {
        this.releaseService = releaseService;
        this.folderService = folderService;
        this.permissionChecker = permissionChecker;
    }

    @Override
    public Type getType() {
        return Type.valueOf(CreateReleaseTask.class);
    }

    @Override
    public void process(DslProcessingContext processingContext, CreateReleaseTask ci) {
        String templateIdOrPath = ci.getTemplateId();
        if (StringUtils.hasText((String)templateIdOrPath)) {
            if (Ids.isReleaseId((String)templateIdOrPath)) {
                if (!this.releaseService.exists(templateIdOrPath)) {
                    throw new DslError("No template found with id '%s'.", templateIdOrPath);
                }
            } else {
                String containerId = processingContext.getContainer() != null ? processingContext.getContainer().getId() : Ids.ROOT_FOLDER_ID;
                String defaultFolderId = Ids.findFolderId((String)containerId);
                ci.setTemplateId(this.resolveTemplateIdFromPath(defaultFolderId, templateIdOrPath));
            }
        }
    }

    private String resolveTemplateIdFromPath(String defaultFolderId, String fullTemplatePath) {
        String templateTitle;
        Optional<String> folderPath = PathUtils.folderPath(fullTemplatePath);
        String folderId = folderPath.map(path -> this.folderService.findByPath(path, 0).getId()).orElse(defaultFolderId);
        List templates = this.releaseService.findTemplatesByTitle(folderId, templateTitle = this.templateTitle(fullTemplatePath), 0, 2, Integer.MAX_VALUE);
        if (templates.isEmpty()) {
            throw new DslError("No template found with title '%s'.", templateTitle);
        }
        if (templates.size() > 1) {
            throw new DslError("More than one template found with title '%s'.", templateTitle);
        }
        if ((templates = this.permissionChecker.filter(templates, XLReleasePermissions.VIEW_TEMPLATE)).isEmpty()) {
            throw new DslError("You don't have view permissions on the template with title '%s'.", templateTitle);
        }
        return ((Release)templates.get(0)).getId();
    }

    private String templateTitle(String fullTemplatePath) {
        return PathUtils.releasePath(fullTemplatePath).orElseThrow(() -> new DslError("Unable to find template title in '%s'", fullTemplatePath));
    }
}

