/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtils {
    private static final Logger log = LoggerFactory.getLogger(PasswordUtils.class);
    private static final char[] hexTable = "0123456789abcdef".toCharArray();
    private static final char DELIMITER = '-';
    private static final int NO_ITERATIONS = 1;
    private static final String ENCODING = "UTF-8";
    private static final String DEFAULT_ALGORITHM = "SHA-256";
    private static final int DEFAULT_SALT_SIZE = 8;
    private static final int DEFAULT_ITERATIONS = 1000;

    private PasswordUtils() {
    }

    public static String buildPasswordHash(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return PasswordUtils.buildPasswordHash(password, DEFAULT_ALGORITHM, 8, 1000);
    }

    public static String buildPasswordHash(String password, String algorithm, int saltSize, int iterations) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (password == null) {
            throw new IllegalArgumentException("Password may not be null.");
        }
        if (iterations < 1) {
            iterations = 1000;
        }
        if (saltSize < 8) {
            saltSize = 8;
        }
        String salt = PasswordUtils.generateSalt(saltSize);
        String alg = algorithm == null ? DEFAULT_ALGORITHM : algorithm;
        return PasswordUtils.generateHash(password, alg, salt, iterations);
    }

    public static boolean isPlainTextPassword(String password) {
        return PasswordUtils.extractAlgorithm(password) == null;
    }

    public static boolean isSame(String hashedPassword, String password) {
        try {
            String algorithm = PasswordUtils.extractAlgorithm(hashedPassword);
            if (algorithm != null) {
                int startPos = algorithm.length() + 2;
                String salt = PasswordUtils.extractSalt(hashedPassword, startPos);
                int iterations = 1;
                if (salt != null) {
                    iterations = PasswordUtils.extractIterations(hashedPassword, startPos += salt.length() + 1);
                }
                String hash = PasswordUtils.generateHash(password, algorithm, salt, iterations);
                return PasswordUtils.compareSecure(hashedPassword, hash);
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.warn(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            log.warn(e.getMessage());
        }
        return false;
    }

    public static String extractAlgorithm(String hashedPwd) {
        if (hashedPwd != null && hashedPwd.length() > 0) {
            int end = hashedPwd.indexOf(125);
            if (hashedPwd.charAt(0) == '{' && end > 0 && end < hashedPwd.length() - 1) {
                String algorithm = hashedPwd.substring(1, end);
                try {
                    MessageDigest.getInstance(algorithm);
                    return algorithm;
                }
                catch (NoSuchAlgorithmException e) {
                    log.debug("Invalid algorithm detected " + algorithm);
                }
            }
        }
        return null;
    }

    private static String generateHash(String pwd, String algorithm, String salt, int iterations) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        StringBuilder passwordHash = new StringBuilder();
        passwordHash.append('{').append(algorithm).append('}');
        if (salt != null && salt.length() > 0) {
            StringBuilder data = new StringBuilder();
            data.append(salt).append(pwd);
            passwordHash.append(salt).append('-');
            if (iterations > 1) {
                passwordHash.append(iterations).append('-');
            }
            passwordHash.append(PasswordUtils.generateDigest(data.toString(), algorithm, iterations));
        } else {
            passwordHash.append(PasswordUtils.digest(algorithm, pwd.getBytes(ENCODING)));
        }
        return passwordHash.toString();
    }

    private static String generateSalt(int saltSize) {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[saltSize];
        random.nextBytes(salt);
        StringBuilder res = new StringBuilder(salt.length * 2);
        for (byte b : salt) {
            res.append(hexTable[b >> 4 & 0xF]);
            res.append(hexTable[b & 0xF]);
        }
        return res.toString();
    }

    private static String generateDigest(String data, String algorithm, int iterations) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] bytes = data.getBytes(ENCODING);
        MessageDigest md = MessageDigest.getInstance(algorithm);
        for (int i = 0; i < iterations; ++i) {
            md.reset();
            bytes = md.digest(bytes);
        }
        StringBuilder res = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            res.append(hexTable[b >> 4 & 0xF]);
            res.append(hexTable[b & 0xF]);
        }
        return res.toString();
    }

    private static String extractSalt(String hashedPwd, int start) {
        int end = hashedPwd.indexOf(45, start);
        if (end > -1) {
            return hashedPwd.substring(start, end);
        }
        return null;
    }

    private static int extractIterations(String hashedPwd, int start) {
        int end = hashedPwd.indexOf(45, start);
        if (end > -1) {
            String str = hashedPwd.substring(start, end);
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                log.debug("Expected number of iterations. Found: " + str);
            }
        }
        return 1;
    }

    private static boolean compareSecure(String a, String b) {
        if (a == null || b == null) {
            return a == null && b == null;
        }
        int len = a.length();
        if (len != b.length()) {
            return false;
        }
        if (len == 0) {
            return true;
        }
        int bits = 0;
        for (int i = 0; i < len; ++i) {
            bits |= a.charAt(i) ^ b.charAt(i);
        }
        return bits == 0;
    }

    private static String digest(String algorithm, byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] digest = md.digest(data);
        StringBuilder res = new StringBuilder(digest.length * 2);
        for (byte b : digest) {
            res.append(hexTable[b >> 4 & 0xF]);
            res.append(hexTable[b & 0xF]);
        }
        return res.toString();
    }
}

