/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.ddata;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Scheduler;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ddata.DurableStore;
import akka.cluster.ddata.DurableStore$LoadAll$;
import akka.cluster.ddata.DurableStore$LoadAllCompleted$;
import akka.cluster.ddata.LmdbDurableStore$;
import akka.cluster.ddata.LmdbDurableStore$WriteBehind$;
import akka.cluster.ddata.Replicator$Internal$DeletedData$;
import akka.event.LoggingAdapter;
import akka.io.DirectByteBufferPool$;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.serialization.SerializerWithStringManifest;
import akka.util.ByteString$;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import com.typesafe.config.Config;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.lmdbjava.CursorIterator;
import org.lmdbjava.Dbi;
import org.lmdbjava.DbiFlags;
import org.lmdbjava.Env;
import org.lmdbjava.EnvFlags;
import org.lmdbjava.PutFlags;
import org.lmdbjava.Txn;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rer!B%K\u0011\u0003\tf!B*K\u0011\u0003!\u0006\"B.\u0002\t\u0003a\u0006\"B/\u0002\t\u0003qv!\u00029\u0002\u0011\u0013\u000bh!B:\u0002\u0011\u0013#\b\"B.\u0006\t\u0003q\b\u0002C@\u0006\u0003\u0003%\t%!\u0001\t\u0013\u0005MQ!!A\u0005\u0002\u0005U\u0001\"CA\u000f\u000b\u0005\u0005I\u0011AA\u0010\u0011%\tY#BA\u0001\n\u0003\ni\u0003C\u0005\u0002<\u0015\t\t\u0011\"\u0001\u0002>!I\u0011qI\u0003\u0002\u0002\u0013\u0005\u0013\u0011\n\u0005\n\u0003\u0017*\u0011\u0011!C!\u0003\u001bB\u0011\"a\u0014\u0006\u0003\u0003%I!!\u0015\u0007\r\u0005e\u0013ARA.\u0011)\tif\u0004BK\u0002\u0013\u0005\u0011q\f\u0005\u000b\u0003{z!\u0011#Q\u0001\n\u0005\u0005\u0004BCA@\u001f\tU\r\u0011\"\u0001\u0002\u0002\"Q\u0011\u0011R\b\u0003\u0012\u0003\u0006I!a!\t\u0015\u0005-uB!f\u0001\n\u0003\ti\t\u0003\u0006\u0002\u0010>\u0011\t\u0012)A\u0005\u0003cB!\"!%\u0010\u0005+\u0007I\u0011AAG\u0011)\t\u0019j\u0004B\tB\u0003%\u0011\u0011\u000f\u0005\u00077>!\t!!&\t\u0013\u0005\u0005v\"!A\u0005\u0002\u0005\r\u0006\"CAW\u001fE\u0005I\u0011AAX\u0011%\t)mDI\u0001\n\u0003\t9\rC\u0005\u0002L>\t\n\u0011\"\u0001\u0002N\"I\u0011\u0011[\b\u0012\u0002\u0013\u0005\u0011Q\u001a\u0005\t\u007f>\t\t\u0011\"\u0011\u0002\u0002!I\u00111C\b\u0002\u0002\u0013\u0005\u0011Q\u0003\u0005\n\u0003;y\u0011\u0011!C\u0001\u0003'D\u0011\"a\u000b\u0010\u0003\u0003%\t%!\f\t\u0013\u0005mr\"!A\u0005\u0002\u0005]\u0007\"CA$\u001f\u0005\u0005I\u0011IA%\u0011%\tYeDA\u0001\n\u0003\ni\u0005C\u0005\u0002\\>\t\t\u0011\"\u0011\u0002^\u001eI\u0011\u0011]\u0001\u0002\u0002#%\u00111\u001d\u0004\n\u00033\n\u0011\u0011!E\u0005\u0003KDaaW\u0014\u0005\u0002\u0005M\b\"CA&O\u0005\u0005IQIA'\u0011%\t)pJA\u0001\n\u0003\u000b9\u0010C\u0005\u0003\u0002\u001d\n\t\u0011\"!\u0003\u0004!I\u0011qJ\u0014\u0002\u0002\u0013%\u0011\u0011\u000b\u0004\u0006'*\u0013!Q\u0003\u0005\tM6\u0012\t\u0011)A\u0005O\"11,\fC\u0001\u0005GA\u0011B!\u000b.\u0005\u0004%\tAa\u000b\t\u0011\t]R\u0006)A\u0005\u0005[A\u0011B!\u000f.\u0005\u0004%\tAa\u000f\t\u0011\t\rS\u0006)A\u0005\u0005{A\u0011B!\u0012.\u0005\u0004%\tAa\u0012\t\u0011\tuS\u0006)A\u0005\u0005\u0013B\u0011Ba\u0018.\u0005\u0004%\tA!\u0019\t\u0011\tMT\u0006)A\u0005\u0005GB\u0011B!\u001e.\u0005\u0004%\tAa\u001e\t\u0011\t\u0015U\u0006)A\u0005\u0005sB\u0011Ba\".\u0001\u0004%IA!#\t\u0013\tmU\u00061A\u0005\n\tu\u0005\u0002\u0003BT[\u0001\u0006KAa#\t\u000f\t%V\u0006\"\u0003\u0003,\"9!QV\u0017\u0005\u0002\t=\u0006b\u0002BY[\u0011\u0005!1\u0017\u0005\n\u0005sk#\u0019!C\u0001\u0005wC\u0001Ba<.A\u0003%!Q\u0018\u0005\b\u0005clC\u0011\tBz\u0011\u001d\u0019Y!\fC!\u0007\u001bAqaa\u0004.\t\u0003\u0019\t\u0002C\u0004\u0004\u001c5\"\ta!\u0005\t\u000f\ruQ\u0006\"\u0001\u0004\u0012!91qD\u0017\u0005\u0002\r\u0005\u0002bBB\u001c[\u0011\u00051QB\u0001\u0011\u00196$'\rR;sC\ndWm\u0015;pe\u0016T!a\u0013'\u0002\u000b\u0011$\u0017\r^1\u000b\u00055s\u0015aB2mkN$XM\u001d\u0006\u0002\u001f\u0006!\u0011m[6b\u0007\u0001\u0001\"AU\u0001\u000e\u0003)\u0013\u0001\u0003T7eE\u0012+(/\u00192mKN#xN]3\u0014\u0005\u0005)\u0006C\u0001,Z\u001b\u00059&\"\u0001-\u0002\u000bM\u001c\u0017\r\\1\n\u0005i;&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002#\u0006)\u0001O]8qgR\u0011q,\u001a\t\u0003A\u000el\u0011!\u0019\u0006\u0003E:\u000bQ!Y2u_JL!\u0001Z1\u0003\u000bA\u0013x\u000e]:\t\u000b\u0019\u001c\u0001\u0019A4\u0002\r\r|gNZ5h!\tAg.D\u0001j\u0015\t1'N\u0003\u0002lY\u0006AA/\u001f9fg\u00064WMC\u0001n\u0003\r\u0019w.\\\u0005\u0003_&\u0014aaQ8oM&<\u0017aC,sSR,')\u001a5j]\u0012\u0004\"A]\u0003\u000e\u0003\u0005\u00111b\u0016:ji\u0016\u0014U\r[5oIN)Q!V;ywB\u0011\u0001M^\u0005\u0003o\u0006\u0014Q\u0003R3bI2+G\u000f^3s'V\u0004\bO]3tg&|g\u000e\u0005\u0002Ws&\u0011!p\u0016\u0002\b!J|G-^2u!\t1F0\u0003\u0002~/\na1+\u001a:jC2L'0\u00192mKR\t\u0011/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003mC:<'BAA\u0007\u0003\u0011Q\u0017M^1\n\t\u0005E\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005]\u0001c\u0001,\u0002\u001a%\u0019\u00111D,\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0005\u0012q\u0005\t\u0004-\u0006\r\u0012bAA\u0013/\n\u0019\u0011I\\=\t\u0013\u0005%\u0012\"!AA\u0002\u0005]\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00020A1\u0011\u0011GA\u001c\u0003Ci!!a\r\u000b\u0007\u0005Ur+\u0001\u0006d_2dWm\u0019;j_:LA!!\u000f\u00024\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty$!\u0012\u0011\u0007Y\u000b\t%C\u0002\u0002D]\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002*-\t\t\u00111\u0001\u0002\"\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u0018\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u0004\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\u0006\u0005\u0003\u0002\u0006\u0005U\u0013\u0002BA,\u0003\u000f\u0011aa\u00142kK\u000e$(\u0001\u0002'nI\n\u001cBaD+yw\u0006\u0019QM\u001c<\u0016\u0005\u0005\u0005\u0004CBA2\u0003[\n\t(\u0004\u0002\u0002f)!\u0011qMA5\u0003!aW\u000e\u001a2kCZ\f'BAA6\u0003\ry'oZ\u0005\u0005\u0003_\n)GA\u0002F]Z\u0004B!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0005\u0003o\nY!A\u0002oS>LA!a\u001f\u0002v\tQ!)\u001f;f\u0005V4g-\u001a:\u0002\t\u0015tg\u000fI\u0001\u0003I\n,\"!a!\u0011\r\u0005\r\u0014QQA9\u0013\u0011\t9)!\u001a\u0003\u0007\u0011\u0013\u0017.A\u0002eE\u0002\n\u0011b[3z\u0005V4g-\u001a:\u0016\u0005\u0005E\u0014AC6fs\n+hMZ3sA\u0005Ya/\u00197vK\n+hMZ3s\u000311\u0018\r\\;f\u0005V4g-\u001a:!))\t9*!'\u0002\u001c\u0006u\u0015q\u0014\t\u0003e>Aq!!\u0018\u0019\u0001\u0004\t\t\u0007C\u0004\u0002\u0000a\u0001\r!a!\t\u000f\u0005-\u0005\u00041\u0001\u0002r!9\u0011\u0011\u0013\rA\u0002\u0005E\u0014\u0001B2paf$\"\"a&\u0002&\u0006\u001d\u0016\u0011VAV\u0011%\ti&\u0007I\u0001\u0002\u0004\t\t\u0007C\u0005\u0002\u0000e\u0001\n\u00111\u0001\u0002\u0004\"I\u00111R\r\u0011\u0002\u0003\u0007\u0011\u0011\u000f\u0005\n\u0003#K\u0002\u0013!a\u0001\u0003c\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00022*\"\u0011\u0011MAZW\t\t)\f\u0005\u0003\u00028\u0006\u0005WBAA]\u0015\u0011\tY,!0\u0002\u0013Ut7\r[3dW\u0016$'bAA`/\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0017\u0011\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0013TC!a!\u00024\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAAhU\u0011\t\t(a-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iQ!\u0011\u0011EAk\u0011%\tI\u0003IA\u0001\u0002\u0004\t9\u0002\u0006\u0003\u0002@\u0005e\u0007\"CA\u0015E\u0005\u0005\t\u0019AA\u0011\u0003\u0019)\u0017/^1mgR!\u0011qHAp\u0011%\tI#JA\u0001\u0002\u0004\t\t#\u0001\u0003M[\u0012\u0014\u0007C\u0001:('\u00119\u0013q]>\u0011\u001d\u0005%\u0018q^A1\u0003\u0007\u000b\t(!\u001d\u0002\u00186\u0011\u00111\u001e\u0006\u0004\u0003[<\u0016a\u0002:v]RLW.Z\u0005\u0005\u0003c\fYOA\tBEN$(/Y2u\rVt7\r^5p]R\"\"!a9\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\u0005]\u0015\u0011`A~\u0003{\fy\u0010C\u0004\u0002^)\u0002\r!!\u0019\t\u000f\u0005}$\u00061\u0001\u0002\u0004\"9\u00111\u0012\u0016A\u0002\u0005E\u0004bBAIU\u0001\u0007\u0011\u0011O\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)A!\u0005\u0011\u000bY\u00139Aa\u0003\n\u0007\t%qK\u0001\u0004PaRLwN\u001c\t\f-\n5\u0011\u0011MAB\u0003c\n\t(C\u0002\u0003\u0010]\u0013a\u0001V;qY\u0016$\u0004\"\u0003B\nW\u0005\u0005\t\u0019AAL\u0003\rAH\u0005M\n\u0007[U\u00139B!\b\u0011\u0007\u0001\u0014I\"C\u0002\u0003\u001c\u0005\u0014Q!Q2u_J\u00042\u0001\u0019B\u0010\u0013\r\u0011\t#\u0019\u0002\r\u0003\u000e$xN\u001d'pO\u001eLgn\u001a\u000b\u0005\u0005K\u00119\u0003\u0005\u0002S[!)am\fa\u0001O\u0006i1/\u001a:jC2L'0\u0019;j_:,\"A!\f\u0011\t\t=\"1G\u0007\u0003\u0005cQ1A!\u000bO\u0013\u0011\u0011)D!\r\u0003\u001bM+'/[1mSj\fG/[8o\u00039\u0019XM]5bY&T\u0018\r^5p]\u0002\n!b]3sS\u0006d\u0017N_3s+\t\u0011i\u0004\u0005\u0003\u00030\t}\u0012\u0002\u0002B!\u0005c\u0011AdU3sS\u0006d\u0017N_3s/&$\bn\u0015;sS:<W*\u00198jM\u0016\u001cH/A\u0006tKJL\u0017\r\\5{KJ\u0004\u0013\u0001C7b]&4Wm\u001d;\u0016\u0005\t%\u0003\u0003\u0002B&\u00053rAA!\u0014\u0003VA\u0019!qJ,\u000e\u0005\tE#b\u0001B*!\u00061AH]8pizJ1Aa\u0016X\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011\u0003B.\u0015\r\u00119fV\u0001\n[\u0006t\u0017NZ3ti\u0002\n1c\u001e:ji\u0016\u0014U\r[5oI&sG/\u001a:wC2,\"Aa\u0019\u0011\t\t\u0015$qN\u0007\u0003\u0005ORAA!\u001b\u0003l\u0005AA-\u001e:bi&|gNC\u0002\u0003n]\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\u0011\tHa\u001a\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006!rO]5uK\n+\u0007.\u001b8e\u0013:$XM\u001d<bY\u0002\n1\u0001Z5s+\t\u0011I\b\u0005\u0003\u0003|\t\u0005UB\u0001B?\u0015\u0011\u0011y(a\u0003\u0002\u0005%|\u0017\u0002\u0002BB\u0005{\u0012AAR5mK\u0006!A-\u001b:!\u0003\u0015yF.\u001c3c+\t\u0011Y\t\u0005\u0004\u0003\u000e\nM%qS\u0007\u0003\u0005\u001fS1A!%O\u0003\u0011)H/\u001b7\n\t\tU%q\u0012\u0002\n\u001fB$\u0018n\u001c8WC2\u00042A!'\u0010\u001d\t\u0011\u0006!A\u0005`Y6$'m\u0018\u0013fcR!!q\u0014BS!\r1&\u0011U\u0005\u0004\u0005G;&\u0001B+oSRD\u0011\"!\u000b<\u0003\u0003\u0005\rAa#\u0002\r}cW\u000e\u001a2!\u0003\u0011aW\u000e\u001a2\u0015\u0005\t]\u0015aD5t\t\nLe.\u001b;jC2L'0\u001a3\u0016\u0005\u0005}\u0012!F3ogV\u0014XMV1mk\u0016\u0014UO\u001a4feNK'0\u001a\u000b\u0005\u0005?\u0013)\fC\u0004\u00038~\u0002\r!a\u0006\u0002\tML'0Z\u0001\ba\u0016tG-\u001b8h+\t\u0011i\f\u0005\u0005\u0003@\n\r'q\u0019Bq\u001b\t\u0011\tM\u0003\u0003\u0003\u0012\u0006-\u0011\u0002\u0002Bc\u0005\u0003\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0003J\nmg\u0002\u0002Bf\u0005/tAA!4\u0003V:!!q\u001aBj\u001d\u0011\u0011yE!5\n\u0003=K!!\u0014(\n\u0005-c\u0015b\u0001Bm\u0015\u0006\u00191*Z=\n\t\tu'q\u001c\u0002\u0006\u0017\u0016L\u0018\n\u001a\u0006\u0004\u00053T\u0005\u0003\u0002Br\u0005St1A\u0015Bs\u0013\r\u00119OS\u0001\r\tV\u0014\u0018M\u00197f'R|'/Z\u0005\u0005\u0005W\u0014iOA\nEkJ\f'\r\\3ECR\fWI\u001c<fY>\u0004XMC\u0002\u0003h*\u000b\u0001\u0002]3oI&tw\rI\u0001\fa>\u001cHOU3ti\u0006\u0014H\u000f\u0006\u0003\u0003 \nU\bb\u0002B|\u0005\u0002\u0007!\u0011`\u0001\u0007e\u0016\f7o\u001c8\u0011\t\tm8Q\u0001\b\u0005\u0005{\u001c\tA\u0004\u0003\u0003P\t}\u0018\"\u0001-\n\u0007\r\rq+A\u0004qC\u000e\\\u0017mZ3\n\t\r\u001d1\u0011\u0002\u0002\n)\"\u0014xn^1cY\u0016T1aa\u0001X\u0003!\u0001xn\u001d;Ti>\u0004HC\u0001BP\u0003\u001d\u0011XmY3jm\u0016,\"aa\u0005\u0011\t\rU1qC\u0007\u0002[%!1\u0011\u0004B\r\u0005\u001d\u0011VmY3jm\u0016\fA!\u001b8ji\u00061\u0011m\u0019;jm\u0016\fQ\u0001\u001a2QkR$\u0002Ba(\u0004$\r=21\u0007\u0005\b\u0007K9\u0005\u0019AB\u0014\u0003\t!\b\u0010\u0005\u0004\u0003\u000e\nM5\u0011\u0006\t\u0007\u0003G\u001aY#!\u001d\n\t\r5\u0012Q\r\u0002\u0004)bt\u0007bBB\u0019\u000f\u0002\u0007!qY\u0001\u0004W\u0016L\bbBB\u001b\u000f\u0002\u0007!\u0011]\u0001\u0005I\u0006$\u0018-A\u0006xe&$XMQ3iS:$\u0007")
public final class LmdbDurableStore
implements Actor,
ActorLogging {
    private final Config config;
    private final Serialization serialization;
    private final SerializerWithStringManifest serializer;
    private final String manifest;
    private final FiniteDuration writeBehindInterval;
    private final File dir;
    private Lmdb _lmdb;
    private final HashMap<String, DurableStore.DurableDataEnvelope> pending;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public static Props props(Config config) {
        return LmdbDurableStore$.MODULE$.props(config);
    }

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Serialization serialization() {
        return this.serialization;
    }

    public SerializerWithStringManifest serializer() {
        return this.serializer;
    }

    public String manifest() {
        return this.manifest;
    }

    public FiniteDuration writeBehindInterval() {
        return this.writeBehindInterval;
    }

    public File dir() {
        return this.dir;
    }

    private Lmdb _lmdb() {
        return this._lmdb;
    }

    private void _lmdb_$eq(Lmdb x$1) {
        this._lmdb = x$1;
    }

    public Lmdb akka$cluster$ddata$LmdbDurableStore$$lmdb() {
        Lmdb lmdb;
        Lmdb lmdb2 = this._lmdb();
        Lmdb lmdb3 = (Lmdb)OptionVal.Some$.MODULE$.unapply((Object)lmdb2);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)lmdb3)) {
            Lmdb l;
            lmdb = l = (Lmdb)OptionVal$.MODULE$.get$extension((Object)lmdb3);
        } else {
            OptionVal$.MODULE$.None();
            Lmdb lmdb4 = lmdb2;
            if (!(null != null ? !((Object)null).equals(lmdb4) : lmdb4 != null)) {
                long t0 = System.nanoTime();
                this.log().info("Using durable data in LMDB directory [{}]", (Object)this.dir().getCanonicalPath());
                Long mapSize = this.config.getBytes("lmdb.map-size");
                this.dir().mkdirs();
                Env env = Env.create().setMapSize(Predef$.MODULE$.Long2long(mapSize)).setMaxDbs(1).open(this.dir(), new EnvFlags[]{EnvFlags.MDB_NOLOCK});
                Dbi db = env.openDbi("ddata", new DbiFlags[]{DbiFlags.MDB_CREATE});
                ByteBuffer keyBuffer = ByteBuffer.allocateDirect(env.getMaxKeySize());
                ByteBuffer valueBuffer = ByteBuffer.allocateDirect(102400);
                if (this.log().isDebugEnabled()) {
                    this.log().debug("Init of LMDB in directory [{}] took [{} ms]", (Object)this.dir().getCanonicalPath(), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
                }
                Lmdb l = new Lmdb((Env<ByteBuffer>)env, (Dbi<ByteBuffer>)db, keyBuffer, valueBuffer);
                this._lmdb_$eq((Lmdb)OptionVal.Some$.MODULE$.apply((Object)l));
                lmdb = l;
            } else {
                throw new MatchError((Object)new OptionVal((Object)lmdb2));
            }
        }
        return lmdb;
    }

    public boolean isDbInitialized() {
        return OptionVal$.MODULE$.isDefined$extension((Object)this._lmdb());
    }

    public void ensureValueBufferSize(int size) {
        block0: {
            ByteBuffer valueBuffer = this.akka$cluster$ddata$LmdbDurableStore$$lmdb().valueBuffer();
            if (valueBuffer.remaining() >= size) break block0;
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(valueBuffer);
            Lmdb qual$1 = this.akka$cluster$ddata$LmdbDurableStore$$lmdb();
            ByteBuffer x$1 = ByteBuffer.allocateDirect(size * 2);
            Env<ByteBuffer> x$2 = qual$1.copy$default$1();
            Dbi<ByteBuffer> x$3 = qual$1.copy$default$2();
            ByteBuffer x$4 = qual$1.copy$default$3();
            this._lmdb_$eq((Lmdb)OptionVal.Some$.MODULE$.apply((Object)qual$1.copy(x$2, x$3, x$4, x$1)));
        }
    }

    public HashMap<String, DurableStore.DurableDataEnvelope> pending() {
        return this.pending;
    }

    public void postRestart(Throwable reason) {
        Actor.postRestart$((Actor)this, (Throwable)reason);
        this.context().become(this.active());
    }

    public void postStop() {
        block0: {
            Actor.postStop$((Actor)this);
            this.writeBehind();
            if (!this.isDbInitialized()) break block0;
            Lmdb l = this.akka$cluster$ddata$LmdbDurableStore$$lmdb();
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> l.db().close());
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> l.env().close());
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(l.keyBuffer());
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(l.valueBuffer());
        }
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.init();
    }

    public PartialFunction<Object, BoxedUnit> init() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LmdbDurableStore $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (DurableStore$LoadAll$.MODULE$.equals(A1)) {
                    BoxedUnit boxedUnit;
                    block14: {
                        if (this.$outer.dir().exists() && this.$outer.dir().list().length > 0) {
                            Lmdb l = this.$outer.akka$cluster$ddata$LmdbDurableStore$$lmdb();
                            long t0 = System.nanoTime();
                            Txn tx = l.env().txnRead();
                            try {
                                try {
                                    CursorIterator iter = l.db().iterate(tx);
                                    try {
                                        IntRef n = IntRef.create((int)0);
                                        DurableStore.LoadData loadData = new DurableStore.LoadData((Map<String, DurableStore.DurableDataEnvelope>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)iter).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> {
                                            ++n$1.elem;
                                            byte[] keyArray = new byte[((Buffer)entry.key()).remaining()];
                                            ((ByteBuffer)entry.key()).get(keyArray);
                                            String key = new String(keyArray, ByteString$.MODULE$.UTF_8());
                                            byte[] valArray = new byte[((Buffer)entry.val()).remaining()];
                                            ((ByteBuffer)entry.val()).get(valArray);
                                            DurableStore.DurableDataEnvelope envelope = (DurableStore.DurableDataEnvelope)$this.$outer.serializer().fromBinary(valArray, $this.$outer.manifest());
                                            return Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)envelope);
                                        }).toMap(Predef$.MODULE$.$conforms()));
                                        if (loadData.data().nonEmpty()) {
                                            package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)loadData, this.$outer.self());
                                        }
                                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)DurableStore$LoadAllCompleted$.MODULE$, this.$outer.self());
                                        if (this.$outer.log().isDebugEnabled()) {
                                            this.$outer.log().debug("load all of [{}] entries took [{} ms]", (Object)BoxesRunTime.boxToInteger((int)n.elem), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
                                        }
                                        this.$outer.context().become(this.$outer.active());
                                        boxedUnit = BoxedUnit.UNIT;
                                        break block14;
                                    }
                                    finally {
                                        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> iter.close());
                                    }
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable2 = throwable;
                                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                                    if (!option.isEmpty()) {
                                        Throwable e = (Throwable)option.get();
                                        throw new DurableStore.LoadFailed("failed to load durable distributed-data", e);
                                    }
                                    throw throwable;
                                }
                            }
                            finally {
                                Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> tx.close());
                            }
                        }
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)DurableStore$LoadAllCompleted$.MODULE$, this.$outer.self());
                        this.$outer.context().become(this.$outer.active());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = DurableStore$LoadAll$.MODULE$.equals(object);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(akka.cluster.ddata.LmdbDurableStore$$anonfun$init$1 scala.runtime.IntRef org.lmdbjava.CursorIterator$KeyVal ), $anonfun$applyOrElse$2(org.lmdbjava.CursorIterator ), $anonfun$applyOrElse$3(org.lmdbjava.Txn )}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LmdbDurableStore $outer;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_36;
                A1 A1 = x1;
                if (A1 instanceof DurableStore.Store) {
                    BoxedUnit boxedUnit;
                    DurableStore.Store store = (DurableStore.Store)A1;
                    String key = store.key();
                    DurableStore.DurableDataEnvelope data = store.data();
                    Option<DurableStore.StoreReply> reply = store.reply();
                    try {
                        Some some;
                        DurableStore.StoreReply storeReply;
                        Object object;
                        this.$outer.akka$cluster$ddata$LmdbDurableStore$$lmdb();
                        if (this.$outer.writeBehindInterval().length() == 0L) {
                            OptionVal$.MODULE$.None();
                            this.$outer.dbPut(null, key, data);
                            object = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit2;
                            if (this.$outer.pending().isEmpty()) {
                                Scheduler qual$1 = this.$outer.context().system().scheduler();
                                FiniteDuration x$1 = this.$outer.writeBehindInterval();
                                ActorRef x$2 = this.$outer.self();
                                LmdbDurableStore$WriteBehind$ x$3 = LmdbDurableStore$WriteBehind$.MODULE$;
                                ExecutionContextExecutor x$4 = this.$outer.context().system().dispatcher();
                                ActorRef x$5 = qual$1.scheduleOnce$default$5(x$1, x$2, (Object)x$3);
                                boxedUnit2 = qual$1.scheduleOnce(x$1, x$2, (Object)x$3, (ExecutionContext)x$4, x$5);
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            object = this.$outer.pending().put(key, data);
                        }
                        Option<DurableStore.StoreReply> option = reply;
                        if (option instanceof Some && (storeReply = (DurableStore.StoreReply)(some = (Some)option).value()) != null) {
                            Object successMsg = storeReply.successMsg();
                            ActorRef replyTo = storeReply.replyTo();
                            package$.MODULE$.actorRef2Scala(replyTo).$bang(successMsg, this.$outer.self());
                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Some some;
                        DurableStore.StoreReply storeReply;
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) throw throwable;
                        Throwable e = (Throwable)option.get();
                        this.$outer.log().error(e, "failed to store [{}]", (Object)key);
                        Option<DurableStore.StoreReply> option2 = reply;
                        if (option2 instanceof Some && (storeReply = (DurableStore.StoreReply)(some = (Some)option2).value()) != null) {
                            Object failureMsg = storeReply.failureMsg();
                            ActorRef replyTo = storeReply.replyTo();
                            package$.MODULE$.actorRef2Scala(replyTo).$bang(failureMsg, this.$outer.self());
                            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                            BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit8 = boxedUnit;
                    return var3_36;
                }
                if (LmdbDurableStore$WriteBehind$.MODULE$.equals(A1)) {
                    this.$outer.writeBehind();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var3_36;
                } else {
                    Object object = function1.apply(x1);
                }
                return var3_36;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DurableStore.Store ? true : LmdbDurableStore$WriteBehind$.MODULE$.equals(object);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void dbPut(Txn<ByteBuffer> tx, String key, DurableStore.DurableDataEnvelope data) {
        block5: {
            try {
                byte[] value = this.serializer().toBinary((Object)data);
                this.ensureValueBufferSize(value.length);
                Lmdb l = this.akka$cluster$ddata$LmdbDurableStore$$lmdb();
                l.keyBuffer().put(key.getBytes(ByteString$.MODULE$.UTF_8())).flip();
                l.valueBuffer().put(value).flip();
                Txn<ByteBuffer> txn = tx;
                OptionVal$.MODULE$.None();
                Txn<ByteBuffer> txn2 = txn;
                if (!(null != null ? !((Object)null).equals(txn2) : txn2 != null)) {
                    l.db().put((Object)l.keyBuffer(), (Object)l.valueBuffer());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                Txn txn3 = (Txn)OptionVal.Some$.MODULE$.unapply(txn);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)txn3)) {
                    Txn t = (Txn)OptionVal$.MODULE$.get$extension((Object)txn3);
                    l.db().put(t, (Object)l.keyBuffer(), (Object)l.valueBuffer(), new PutFlags[0]);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                throw new MatchError((Object)new OptionVal(txn));
            }
            finally {
                Lmdb l = this.akka$cluster$ddata$LmdbDurableStore$$lmdb();
                l.keyBuffer().clear();
                l.valueBuffer().clear();
            }
        }
    }

    public void writeBehind() {
        block9: {
            if (!this.pending().isEmpty()) {
                long t0 = System.nanoTime();
                Txn tx = this.akka$cluster$ddata$LmdbDurableStore$$lmdb().env().txnWrite();
                try {
                    try {
                        for (Map.Entry<String, DurableStore.DurableDataEnvelope> entry : this.pending().entrySet()) {
                            this.dbPut((Txn<ByteBuffer>)((Txn)OptionVal.Some$.MODULE$.apply((Object)tx)), entry.getKey(), entry.getValue());
                        }
                        tx.commit();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("store and commit of [{}] entries took [{} ms]", (Object)BoxesRunTime.boxToInteger((int)this.pending().size()), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.log().error(e, "failed to store [{}]", (Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.pending().keySet()).asScala()).mkString(","));
                            tx.abort();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block9;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.pending().clear();
                }
            }
        }
    }

    public LmdbDurableStore(Config config) {
        this.config = config;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.context().system());
        this.serializer = (SerializerWithStringManifest)this.serialization().serializerFor(DurableStore.DurableDataEnvelope.class);
        this.manifest = this.serializer().manifest((Object)new DurableStore.DurableDataEnvelope(Replicator$Internal$DeletedData$.MODULE$));
        String string = config.getString("lmdb.write-behind-interval").toLowerCase();
        FiniteDuration finiteDuration = "off".equals(string) ? Duration$.MODULE$.Zero() : new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(config.getDuration("lmdb.write-behind-interval", TimeUnit.MILLISECONDS))).millis();
        this.writeBehindInterval = finiteDuration;
        String string2 = config.getString("lmdb.dir");
        File file = string2.endsWith("ddata") ? new File(new StringBuilder(3).append(string2).append("-").append(this.context().system().name()).append("-").append(this.self().path().parent().name()).append("-").append(((Cluster)Cluster$.MODULE$.apply(this.context().system())).selfAddress().port().get()).toString()) : new File(string2);
        this.dir = file;
        OptionVal$.MODULE$.None();
        this._lmdb = null;
        this.pending = new HashMap();
    }

    public static final class Lmdb
    implements Product,
    scala.Serializable {
        private final Env<ByteBuffer> env;
        private final Dbi<ByteBuffer> db;
        private final ByteBuffer keyBuffer;
        private final ByteBuffer valueBuffer;

        public Env<ByteBuffer> env() {
            return this.env;
        }

        public Dbi<ByteBuffer> db() {
            return this.db;
        }

        public ByteBuffer keyBuffer() {
            return this.keyBuffer;
        }

        public ByteBuffer valueBuffer() {
            return this.valueBuffer;
        }

        public Lmdb copy(Env<ByteBuffer> env, Dbi<ByteBuffer> db, ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
            return new Lmdb(env, db, keyBuffer, valueBuffer);
        }

        public Env<ByteBuffer> copy$default$1() {
            return this.env();
        }

        public Dbi<ByteBuffer> copy$default$2() {
            return this.db();
        }

        public ByteBuffer copy$default$3() {
            return this.keyBuffer();
        }

        public ByteBuffer copy$default$4() {
            return this.valueBuffer();
        }

        public String productPrefix() {
            return "Lmdb";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.env();
                    break;
                }
                case 1: {
                    object = this.db();
                    break;
                }
                case 2: {
                    object = this.keyBuffer();
                    break;
                }
                case 3: {
                    object = this.valueBuffer();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Lmdb;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Lmdb)) return false;
            boolean bl = true;
            if (!bl) return false;
            Lmdb lmdb = (Lmdb)x$1;
            Env<ByteBuffer> env = this.env();
            Env<ByteBuffer> env2 = lmdb.env();
            if (env == null) {
                if (env2 != null) {
                    return false;
                }
            } else if (!env.equals(env2)) return false;
            Dbi<ByteBuffer> dbi = this.db();
            Dbi<ByteBuffer> dbi2 = lmdb.db();
            if (dbi == null) {
                if (dbi2 != null) {
                    return false;
                }
            } else if (!dbi.equals(dbi2)) return false;
            ByteBuffer byteBuffer = this.keyBuffer();
            ByteBuffer byteBuffer2 = lmdb.keyBuffer();
            if (byteBuffer == null) {
                if (byteBuffer2 != null) {
                    return false;
                }
            } else if (!((Object)byteBuffer).equals(byteBuffer2)) return false;
            ByteBuffer byteBuffer3 = this.valueBuffer();
            ByteBuffer byteBuffer4 = lmdb.valueBuffer();
            if (byteBuffer3 == null) {
                if (byteBuffer4 == null) return true;
                return false;
            } else {
                if (!((Object)byteBuffer3).equals(byteBuffer4)) return false;
                return true;
            }
        }

        public Lmdb(Env<ByteBuffer> env, Dbi<ByteBuffer> db, ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
            this.env = env;
            this.db = db;
            this.keyBuffer = keyBuffer;
            this.valueBuffer = valueBuffer;
            Product.$init$((Product)this);
        }
    }
}

