/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.api.internal;

import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.notifications.actors.extension.TaskWatcherExecutionActorMessages;
import com.xebialabs.xlrelease.notifications.package$;
import com.xebialabs.xlrelease.notifications.service.TaskWatchersService;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;

@Path(value="/tasks")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001\u0002\u0007\u000e\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!a\u0004A!A!\u0002\u0013i\u0004\"B#\u0001\t\u00031\u0005\"B/\u0001\t\u0003q\u0006bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\b\u0003\u001b\u0002A\u0011AA(\u0011\u001d\ti\u0007\u0001C\u0001\u0003_Bq!!\"\u0001\t\u0013\t9I\u0001\u000bUCN\\w+\u0019;dQ\u0016\u00148OU3t_V\u00148-\u001a\u0006\u0003\u001d=\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003!E\t1!\u00199j\u0015\t\u00112#A\u0007o_RLg-[2bi&|gn\u001d\u0006\u0003)U\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005Y9\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005A\u0012aA2p[\u000e\u00011C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fM\u0006Y\u0001/\u001a:nSN\u001c\u0018n\u001c8t!\t\u0019c%D\u0001%\u0015\t)3#\u0001\u0005tK\u000e,(/\u001b;z\u0013\t9CEA\tQKJl\u0017n]:j_:\u001c\u0005.Z2lKJ\f1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\"AK\u0017\u000e\u0003-R!\u0001L\n\u0002\r\u0005\u001cGo\u001c:t\u0013\tq3FA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW-A\nuCN\\w+\u0019;dQ\u0016\u00148oU3sm&\u001cW\r\u0005\u00022i5\t!G\u0003\u00024#\u000591/\u001a:wS\u000e,\u0017BA\u001b3\u0005M!\u0016m]6XCR\u001c\u0007.\u001a:t'\u0016\u0014h/[2f\u0003-!\u0018m]6TKJ4\u0018nY3\u0011\u0005aRT\"A\u001d\u000b\u0005M\u001a\u0012BA\u001e:\u0005-!\u0016m]6TKJ4\u0018nY3\u0002#U\u001cXM\u001d,jK^\u001cuN\u001c<feR,'\u000f\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006Q1m\u001c8wKJ$XM]:\u000b\u0005\t\u001b\u0012!\u0002<jK^\u001c\u0018B\u0001#@\u0005E)6/\u001a:WS\u0016<8i\u001c8wKJ$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u001dK%j\u0013'N!\tA\u0005!D\u0001\u000e\u0011\u0015\tc\u00011\u0001#\u0011\u0015Ac\u00011\u0001*\u0011\u0015yc\u00011\u00011\u0011\u00151d\u00011\u00018\u0011\u0015ad\u00011\u0001>Q\t1q\n\u0005\u0002Q76\t\u0011K\u0003\u0002S'\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005Q+\u0016a\u00024bGR|'/\u001f\u0006\u0003-^\u000bQAY3b]NT!\u0001W-\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AW\u0001\u0004_J<\u0017B\u0001/R\u0005%\tU\u000f^8xSJ,G-A\u0006hKR<\u0016\r^2iKJ\u001cHCA0l!\r\u0001WmZ\u0007\u0002C*\u0011!mY\u0001\u0005kRLGNC\u0001e\u0003\u0011Q\u0017M^1\n\u0005\u0019\f'aA*fiB\u0011\u0001.[\u0007\u0002\u0003&\u0011!.\u0011\u0002\t+N,'OV5fo\")An\u0002a\u0001[\u00061A/Y:l\u0013\u0012\u0004\"A\\;\u000f\u0005=\u001c\bC\u00019\u001e\u001b\u0005\t(B\u0001:\u001a\u0003\u0019a$o\\8u}%\u0011A/H\u0001\u0007!J,G-\u001a4\n\u0005Y<(AB*ue&twM\u0003\u0002u;!\u00121.\u001f\t\u0004u\u0006\rQ\"A>\u000b\u0005ql\u0018AA5e\u0015\tqx0\u0001\u0005qYVl'-\u001b8h\u0015\r\t\t!F\u0001\tI\u0016\u0004Hn\\=ji&\u0019\u0011QA>\u0003\u000f%#\u0007+\u0019:b[\":1.!\u0003\u0002\u001e\u0005}\u0001\u0003BA\u0006\u00033i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u0003eNTA!a\u0005\u0002\u0016\u0005\u0011qo\u001d\u0006\u0003\u0003/\tQA[1wCbLA!a\u0007\u0002\u000e\tI\u0001+\u0019;i!\u0006\u0014\u0018-\\\u0001\u0006m\u0006dW/Z\u0011\u0002Y\"\u001aq!a\t\u0011\t\u0005-\u0011QE\u0005\u0005\u0003O\tiAA\u0002H\u000bRCsaBA\u0016\u0003;\t\t\u0004\u0005\u0003\u0002\f\u00055\u0012\u0002BA\u0018\u0003\u001b\u0011A\u0001U1uQ\u0006\u0012\u00111G\u0001\u001fwR\f7o[%eu9RC+Y:l7z{S&\u0018\u0016~_]\fGo\u00195feN\f!\"\u00193e/\u0006$8\r[3s)\u0015y\u0016\u0011HA \u0011\u0015a\u0007\u00021\u0001nQ\r\tI$\u001f\u0015\t\u0003s\tI!!\b\u0002 !1\u0011\u0011\t\u0005A\u0002\u001d\f1b^1uG\",'OV5fo\"\u001a\u0001\"!\u0012\u0011\t\u0005-\u0011qI\u0005\u0005\u0003\u0013\niA\u0001\u0003Q\u001fN#\u0006f\u0002\u0005\u0002,\u0005u\u0011\u0011G\u0001\u000ee\u0016lwN^3XCR\u001c\u0007.\u001a:\u0015\u000b}\u000b\t&a\u0016\t\u000b1L\u0001\u0019A7)\u0007\u0005E\u0013\u0010\u000b\u0005\u0002R\u0005%\u0011QDA\u0010\u0011\u0019\tI&\u0003a\u0001[\u0006AQo]3s]\u0006lW\r\u000b\u0005\u0002X\u0005%\u0011QDA/C\t\tI\u0006K\u0002\n\u0003C\u0002B!a\u0003\u0002d%!\u0011QMA\u0007\u0005\u0019!U\tT#U\u000b\":\u0011\"a\u000b\u0002\u001e\u0005%\u0014EAA6\u0003%ZH/Y:l\u0013\u0012TdF\u000b+bg.\\flL\u0017^Uu|s/\u0019;dQ\u0016\u00148oL>vg\u0016\u0014h.Y7f{\u0006qQ\u000f\u001d3bi\u0016<\u0016\r^2iKJ\u001cH#B0\u0002r\u0005]\u0004\"\u00027\u000b\u0001\u0004i\u0007fAA9s\"B\u0011\u0011OA\u0005\u0003;\ty\u0002\u0003\u0004\u0002z)\u0001\raX\u0001\ro\u0006$8\r[3sgZKWm\u001e\u0015\u0004\u0015\u0005u\u0004\u0003BA\u0006\u0003\u007fJA!!!\u0002\u000e\t\u0019\u0001+\u0016+)\u000f)\tY#!\b\u00022\u0005i1m\u001c8wKJ$Hk\u001c,jK^$2aXAE\u0011\u001d\tYi\u0003a\u0001\u0003\u001b\u000b\u0001b^1uG\",'o\u001d\t\u0005]\u0006=U.\u0003\u0002go\"\u001a\u0001!a%\u0011\t\u0005U\u00151T\u0007\u0003\u0003/S1!!'X\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003;\u000b9J\u0001\u0006D_:$(o\u001c7mKJDs\u0001AAQ\u0003;\t9\u000b\u0005\u0003\u0002\f\u0005\r\u0016\u0002BAS\u0003\u001b\u0011\u0001\u0002\u0015:pIV\u001cWm\u001d\u0017\u0003\u0003S\u000b#!a+\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007f\u0002\u0001\u00020\u0006u\u0011Q\u0017\t\u0005\u0003\u0017\t\t,\u0003\u0003\u00024\u00065!\u0001C\"p]N,X.Z:-\u0005\u0005%\u0006f\u0002\u0001\u0002,\u0005u\u0011\u0011X\u0011\u0003\u0003w\u000baa\f;bg.\u001c\b")
public class TaskWatchersResource {
    private final PermissionChecker permissions;
    private final ReleaseActorService releaseActorService;
    private final TaskService taskService;
    private final UserViewConverter userViewConverter;

    @Path(value="{taskId:.*Task[^/-]*}/watchers")
    @GET
    public java.util.Set<UserView> getWatchers(@PathParam(value="taskId") @IdParam String taskId) {
        Task task = this.taskService.findByIdIncludingArchived(taskId);
        this.permissions.checkViewTask(task);
        return this.convertToView(package$.MODULE$.TaskWithNotificationFields(task).getWatchers());
    }

    @Path(value="{taskId:.*Task[^/-]*}/watchers")
    @POST
    public java.util.Set<UserView> addWatcher(@PathParam(value="taskId") @IdParam String taskId, UserView watcherView) {
        String string = User.AUTHENTICATED_USER.getName();
        String string2 = watcherView.getUsername();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        }
        scala.collection.immutable.Set watchers = (scala.collection.immutable.Set)this.releaseActorService.executeCommand(taskId, (ReleaseExecutionActorMessages.ExtensionCommand)new TaskWatcherExecutionActorMessages.AddWatcher(taskId, watcherView.getUsername()));
        return this.convertToView((scala.collection.immutable.Set<String>)watchers);
    }

    @Path(value="{taskId:.*Task[^/-]*}/watchers/{username}")
    @DELETE
    public java.util.Set<UserView> removeWatcher(@PathParam(value="taskId") @IdParam String taskId, @PathParam(value="username") String username) {
        String string = User.AUTHENTICATED_USER.getName();
        String string2 = username;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        }
        scala.collection.immutable.Set watchers = (scala.collection.immutable.Set)this.releaseActorService.executeCommand(taskId, (ReleaseExecutionActorMessages.ExtensionCommand)new TaskWatcherExecutionActorMessages.RemoveWatcher(taskId, username));
        return this.convertToView((scala.collection.immutable.Set<String>)watchers);
    }

    @Path(value="{taskId:.*Task[^/-]*}/watchers")
    @PUT
    public java.util.Set<UserView> updateWatchers(@PathParam(value="taskId") @IdParam String taskId, java.util.Set<UserView> watchersView) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        scala.collection.immutable.Set watchers = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(watchersView).asScala()).map((Function1 & Serializable & scala.Serializable)userView -> userView.getUsername(), Set$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set updatedWatchers = (scala.collection.immutable.Set)this.releaseActorService.executeCommand(taskId, (ReleaseExecutionActorMessages.ExtensionCommand)new TaskWatcherExecutionActorMessages.UpdateWatchers(taskId, (scala.collection.immutable.Set<String>)watchers));
        return this.convertToView((scala.collection.immutable.Set<String>)updatedWatchers);
    }

    private java.util.Set<UserView> convertToView(scala.collection.immutable.Set<String> watchers) {
        return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)watchers.map((Function1 & Serializable & scala.Serializable)username -> $this.userViewConverter.toUserView(username), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).asJava();
    }

    @Autowired
    public TaskWatchersResource(PermissionChecker permissions, ReleaseActorService releaseActorService, TaskWatchersService taskWatchersService, TaskService taskService, UserViewConverter userViewConverter) {
        this.permissions = permissions;
        this.releaseActorService = releaseActorService;
        this.taskService = taskService;
        this.userViewConverter = userViewConverter;
    }
}

