/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.kohsuke.github.EnforcementLevel;
import org.kohsuke.github.GHBranchProtection;
import org.kohsuke.github.GHBranchProtectionBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
public class GHBranch {
    private GitHub root;
    private GHRepository owner;
    private String name;
    private Commit commit;
    @JsonProperty(value="protected")
    private boolean protection;
    private String protection_url;

    public GitHub getRoot() {
        return this.root;
    }

    public GHRepository getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    @Preview
    @Deprecated
    public boolean isProtected() {
        return this.protection;
    }

    @Preview
    @Deprecated
    public URL getProtectionUrl() {
        return GitHub.parseURL(this.protection_url);
    }

    @Preview
    @Deprecated
    public GHBranchProtection getProtection() throws IOException {
        return (GHBranchProtection)((Object)this.root.retrieve().withPreview("application/vnd.github.loki-preview+json").to(this.protection_url, GHBranchProtection.class));
    }

    public String getSHA1() {
        return this.commit.sha;
    }

    @Preview
    @Deprecated
    public void disableProtection() throws IOException {
        new Requester(this.root).method("DELETE").withPreview("application/vnd.github.loki-preview+json").to(this.protection_url);
    }

    @Preview
    @Deprecated
    public GHBranchProtectionBuilder enableProtection() {
        return new GHBranchProtectionBuilder(this);
    }

    @Deprecated
    public void enableProtection(EnforcementLevel level, Collection<String> contexts) throws IOException {
        switch (level) {
            case OFF: {
                this.disableProtection();
                break;
            }
            case NON_ADMINS: 
            case EVERYONE: {
                this.enableProtection().addRequiredChecks(contexts).includeAdmins(level == EnforcementLevel.EVERYONE).enable();
            }
        }
    }

    String getApiRoute() {
        return this.owner.getApiTailUrl("/branches/" + this.name);
    }

    public String toString() {
        String url = this.owner != null ? this.owner.getUrl().toString() : "unknown";
        return "Branch:" + this.name + " in " + url;
    }

    GHBranch wrap(GHRepository repo) {
        this.owner = repo;
        this.root = repo.root;
        return this;
    }

    public static class Commit {
        String sha;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String url;
    }
}

