/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data.db;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.data.db.DbDataStore;

public class Pool {
    protected final int maxSize;
    protected final ArrayList all = new ArrayList();
    protected final DbDataStore factory;
    protected final LinkedQueue pool = new LinkedQueue();

    protected Pool(DbDataStore factory, int maxSize) {
        this.factory = factory;
        this.maxSize = Math.max(1, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object get() throws InterruptedException, RepositoryException {
        Object o = this.pool.poll(0L);
        if (o == null) {
            ArrayList arrayList = this.all;
            synchronized (arrayList) {
                if (this.all.size() < this.maxSize) {
                    o = this.factory.createNewConnection();
                    this.all.add(o);
                }
            }
            if (o == null) {
                o = this.pool.take();
            }
        }
        return o;
    }

    protected void add(Object o) throws InterruptedException {
        this.pool.put(o);
    }

    protected ArrayList getAll() {
        return this.all;
    }
}

