/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.client;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Address;
import akka.actor.Address$;
import akka.actor.Cancellable;
import akka.actor.Props;
import akka.actor.Props$;
import akka.actor.Scheduler;
import akka.actor.SupervisorStrategy;
import akka.actor.Terminated;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.Member$;
import akka.cluster.MemberStatus;
import akka.cluster.client.ClusterClientUnreachable;
import akka.cluster.client.ClusterClientUp;
import akka.cluster.client.ClusterClients;
import akka.cluster.client.ClusterReceptionist;
import akka.cluster.client.ClusterReceptionist$;
import akka.cluster.client.ClusterReceptionist$Internal$CheckDeadlines$;
import akka.cluster.client.ClusterReceptionist$Internal$GetContacts$;
import akka.cluster.client.ClusterReceptionist$Internal$Heartbeat$;
import akka.cluster.client.ClusterReceptionist$Internal$HeartbeatRsp$;
import akka.cluster.client.ClusterReceptionist$Internal$Ping$;
import akka.cluster.client.ClusterReceptionist$Internal$ReceptionistShutdown$;
import akka.cluster.client.ClusterReceptionistSettings;
import akka.cluster.client.GetClusterClients$;
import akka.cluster.client.SubscribeClusterClients$;
import akka.cluster.client.UnsubscribeClusterClients$;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.event.LoggingAdapter;
import akka.remote.DeadlineFailureDetector;
import akka.remote.FailureDetector$;
import akka.routing.ConsistentHash;
import akka.routing.ConsistentHash$;
import akka.routing.MurmurHash$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URLEncoder;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericCompanion;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\r\u0005x\u0001CA\b\u0003#A\t!a\b\u0007\u0011\u0005\r\u0012\u0011\u0003E\u0001\u0003KAq!a\r\u0002\t\u0003\t)\u0004C\u0004\u00028\u0005!\t!!\u000f\b\u0013\u0005m\u0013\u0001#\u0001\u0002\u001a\u0005uc!CA1\u0003!\u0005\u0011\u0011DA2\u0011\u001d\t\u0019$\u0002C\u0001\u0003K:q!a\u001a\u0006\u0011\u0003\u000bIGB\u0004\u0002n\u0015A\t)a\u001c\t\u000f\u0005M\u0002\u0002\"\u0001\u0002\n\"I\u00111\u0012\u0005\u0002\u0002\u0013\u0005\u0013Q\u0012\u0005\n\u0003?C\u0011\u0011!C\u0001\u0003CC\u0011\"!+\t\u0003\u0003%\t!a+\t\u0013\u0005]\u0006\"!A\u0005B\u0005e\u0006\"CAd\u0011\u0005\u0005I\u0011AAe\u0011%\t\u0019\u000eCA\u0001\n\u0003\n)\u000eC\u0005\u0002X\"\t\t\u0011\"\u0011\u0002Z\"I\u00111\u001c\u0005\u0002\u0002\u0013%\u0011Q\u001c\u0004\u0007\u0003g,!)!>\t\u0015\u0005](C!f\u0001\n\u0003\tI\u0010\u0003\u0006\u0003\u001cI\u0011\t\u0012)A\u0005\u0003wDq!a\r\u0013\t\u0003\u0011i\u0002C\u0005\u0003$I\t\t\u0011\"\u0001\u0003&!I!\u0011\u0006\n\u0012\u0002\u0013\u0005!1\u0006\u0005\n\u0003\u0017\u0013\u0012\u0011!C!\u0003\u001bC\u0011\"a(\u0013\u0003\u0003%\t!!)\t\u0013\u0005%&#!A\u0005\u0002\t\u0005\u0003\"CA\\%\u0005\u0005I\u0011IA]\u0011%\t9MEA\u0001\n\u0003\u0011)\u0005C\u0005\u0002TJ\t\t\u0011\"\u0011\u0002V\"I\u0011q\u001b\n\u0002\u0002\u0013\u0005\u0013\u0011\u001c\u0005\n\u0005\u0013\u0012\u0012\u0011!C!\u0005\u0017:\u0011B!\u0015\u0006\u0003\u0003E\tAa\u0015\u0007\u0013\u0005MX!!A\t\u0002\tU\u0003bBA\u001aC\u0011\u0005!1\r\u0005\n\u0003/\f\u0013\u0011!C#\u00033D\u0011B!\u001a\"\u0003\u0003%\tIa\u001a\t\u0013\t-\u0014%!A\u0005\u0002\n5\u0004\"CAnC\u0005\u0005I\u0011BAo\u000f\u001d\u0011I(\u0002EA\u0005w2qA! \u0006\u0011\u0003\u0013y\bC\u0004\u00024!\"\tA!!\t\u0013\u0005-\u0005&!A\u0005B\u00055\u0005\"CAPQ\u0005\u0005I\u0011AAQ\u0011%\tI\u000bKA\u0001\n\u0003\u0011\u0019\tC\u0005\u00028\"\n\t\u0011\"\u0011\u0002:\"I\u0011q\u0019\u0015\u0002\u0002\u0013\u0005!q\u0011\u0005\n\u0003'D\u0013\u0011!C!\u0003+D\u0011\"a6)\u0003\u0003%\t%!7\t\u0013\u0005m\u0007&!A\u0005\n\u0005uwa\u0002BH\u000b!\u0005%\u0011\u0013\u0004\b\u0005'+\u0001\u0012\u0011BK\u0011\u001d\t\u0019d\rC\u0001\u0005/C\u0011\"a#4\u0003\u0003%\t%!$\t\u0013\u0005}5'!A\u0005\u0002\u0005\u0005\u0006\"CAUg\u0005\u0005I\u0011\u0001BM\u0011%\t9lMA\u0001\n\u0003\nI\fC\u0005\u0002HN\n\t\u0011\"\u0001\u0003\u001e\"I\u00111[\u001a\u0002\u0002\u0013\u0005\u0013Q\u001b\u0005\n\u0003/\u001c\u0014\u0011!C!\u00033D\u0011\"a74\u0003\u0003%I!!8\b\u000f\t\u0015V\u0001#!\u0003(\u001a9!\u0011V\u0003\t\u0002\n-\u0006bBA\u001a}\u0011\u0005!Q\u0016\u0005\n\u0003\u0017s\u0014\u0011!C!\u0003\u001bC\u0011\"a(?\u0003\u0003%\t!!)\t\u0013\u0005%f(!A\u0005\u0002\t=\u0006\"CA\\}\u0005\u0005I\u0011IA]\u0011%\t9MPA\u0001\n\u0003\u0011\u0019\fC\u0005\u0002Tz\n\t\u0011\"\u0011\u0002V\"I\u0011q\u001b \u0002\u0002\u0013\u0005\u0013\u0011\u001c\u0005\n\u00037t\u0014\u0011!C\u0005\u0003;<qAa/\u0006\u0011\u0003\u0013iLB\u0004\u0003@\u0016A\tI!1\t\u000f\u0005M\u0012\n\"\u0001\u0003D\"I\u00111R%\u0002\u0002\u0013\u0005\u0013Q\u0012\u0005\n\u0003?K\u0015\u0011!C\u0001\u0003CC\u0011\"!+J\u0003\u0003%\tA!2\t\u0013\u0005]\u0016*!A\u0005B\u0005e\u0006\"CAd\u0013\u0006\u0005I\u0011\u0001Be\u0011%\t\u0019.SA\u0001\n\u0003\n)\u000eC\u0005\u0002X&\u000b\t\u0011\"\u0011\u0002Z\"I\u00111\\%\u0002\u0002\u0013%\u0011Q\\\u0004\b\u0005#,\u0001\u0012\u0011Bj\r\u001d\u0011).\u0002EA\u0005/Dq!a\rU\t\u0003\u0011I\u000eC\u0005\u0002\fR\u000b\t\u0011\"\u0011\u0002\u000e\"I\u0011q\u0014+\u0002\u0002\u0013\u0005\u0011\u0011\u0015\u0005\n\u0003S#\u0016\u0011!C\u0001\u00057D\u0011\"a.U\u0003\u0003%\t%!/\t\u0013\u0005\u001dG+!A\u0005\u0002\t}\u0007\"CAj)\u0006\u0005I\u0011IAk\u0011%\t9\u000eVA\u0001\n\u0003\nI\u000eC\u0005\u0002\\R\u000b\t\u0011\"\u0003\u0002^\u001a1!1]\u0003\u0001\u0005KD!\"a\u0005_\u0005\u0003\u0005\u000b\u0011BA&\u0011)\u0011\u0019P\u0018B\u0001B\u0003%!Q\u001f\u0005\b\u0003gqF\u0011AB\u0003\u0011%\u0019iA\u0018b\u0001\n\u0013\u0019y\u0001\u0003\u0005\u0004\u0012y\u0003\u000b\u0011BAf\u0011\u001d\u0019\u0019B\u0018C\u0001\u0007+1q!a\t\u0002\u0012\t\u0019\u0019\u0003\u0003\u0006\u0002J\u0015\u0014\t\u0011)A\u0005\u0003\u0017B!\"a\u0015f\u0005\u0003\u0005\u000b\u0011BA+\u0011\u001d\t\u0019$\u001aC\u0001\u0007KA\u0011\"a\u0006f\u0005\u0004%\ta!\f\t\u0011\r]R\r)A\u0005\u0007_A\u0011b!\u000ff\u0005\u0004%\taa\u0004\t\u0011\rmR\r)A\u0005\u0003\u0017D\u0011b!\u0010f\u0001\u0004%\taa\u0010\t\u0013\r5S\r1A\u0005\u0002\r=\u0003\u0002CB*K\u0002\u0006Ka!\u0011\t\u0013\rUSM1A\u0005\u0002\u0005\u0005\u0006\u0002CB,K\u0002\u0006I!a)\t\u0013\reS\r1A\u0005\u0002\rm\u0003\"CB5K\u0002\u0007I\u0011AB6\u0011!\u0019y'\u001aQ!\n\ru\u0003\"CB9K\u0002\u0007I\u0011AB:\u0011%\u00199)\u001aa\u0001\n\u0003\u0019I\t\u0003\u0005\u0004\u000e\u0016\u0004\u000b\u0015BB;\u0011%\u0019y)\u001aa\u0001\n\u0003\u0019\t\nC\u0005\u0004\u001a\u0016\u0004\r\u0011\"\u0001\u0004\u001c\"A1qT3!B\u0013\u0019\u0019\nC\u0005\u0004\"\u0016\u0004\r\u0011\"\u0001\u0004$\"I11V3A\u0002\u0013\u00051Q\u0016\u0005\t\u0007c+\u0007\u0015)\u0003\u0004&\"I11W3C\u0002\u0013\u00051Q\u0017\u0005\t\u0007{+\u0007\u0015!\u0003\u00048\"91qX3\u0005B\r\u0005\u0007bBBbK\u0012\u00053\u0011\u0019\u0005\b\u0007\u000b,G\u0011ABd\u0011\u001d\u0019\u0019.\u001aC\u0001\u0007+Dqaa\u0005f\t\u0003\u0019)\u0002C\u0004\u0004Z\u0016$\taa7\t\u000f\r}W\r\"\u0001\u0004B\u0006\u00192\t\\;ti\u0016\u0014(+Z2faRLwN\\5ti*!\u00111CA\u000b\u0003\u0019\u0019G.[3oi*!\u0011qCA\r\u0003\u001d\u0019G.^:uKJT!!a\u0007\u0002\t\u0005\\7.Y\u0002\u0001!\r\t\t#A\u0007\u0003\u0003#\u00111c\u00117vgR,'OU3dKB$\u0018n\u001c8jgR\u001c2!AA\u0014!\u0011\tI#a\f\u000e\u0005\u0005-\"BAA\u0017\u0003\u0015\u00198-\u00197b\u0013\u0011\t\t$a\u000b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\u0011\u0011qD\u0001\u0006aJ|\u0007o\u001d\u000b\u0007\u0003w\t9%!\u0015\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQA!!\u0011\u0002\u001a\u0005)\u0011m\u0019;pe&!\u0011QIA \u0005\u0015\u0001&o\u001c9t\u0011\u001d\tIe\u0001a\u0001\u0003\u0017\na\u0002];c'V\u0014W*\u001a3jCR|'\u000f\u0005\u0003\u0002>\u00055\u0013\u0002BA(\u0003\u007f\u0011\u0001\"Q2u_J\u0014VM\u001a\u0005\b\u0003'\u001a\u0001\u0019AA+\u0003!\u0019X\r\u001e;j]\u001e\u001c\b\u0003BA\u0011\u0003/JA!!\u0017\u0002\u0012\tY2\t\\;ti\u0016\u0014(+Z2faRLwN\\5tiN+G\u000f^5oON\f\u0001\"\u00138uKJt\u0017\r\u001c\t\u0004\u0003?*Q\"A\u0001\u0003\u0011%sG/\u001a:oC2\u001c2!BA\u0014)\t\ti&A\u0006HKR\u001cuN\u001c;bGR\u001c\bcAA6\u00115\tQAA\u0006HKR\u001cuN\u001c;bGR\u001c8c\u0003\u0005\u0002(\u0005E\u0014qOA?\u0003\u0007\u0003B!!\t\u0002t%!\u0011QOA\t\u0005Q\u0019E.^:uKJ\u001cE.[3oi6+7o]1hKB!\u0011QHA=\u0013\u0011\tY(a\u0010\u0003+\u0011+\u0017\r\u001a'fiR,'oU;qaJ,7o]5p]B!\u0011\u0011FA@\u0013\u0011\t\t)a\u000b\u0003\u000fA\u0013x\u000eZ;diB!\u0011\u0011FAC\u0013\u0011\t9)a\u000b\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005%\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0010B!\u0011\u0011SAN\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006]\u0015\u0001\u00027b]\u001eT!!!'\u0002\t)\fg/Y\u0005\u0005\u0003;\u000b\u0019J\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003G\u0003B!!\u000b\u0002&&!\u0011qUA\u0016\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ti+a-\u0011\t\u0005%\u0012qV\u0005\u0005\u0003c\u000bYCA\u0002B]fD\u0011\"!.\r\u0003\u0003\u0005\r!a)\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\f\u0005\u0004\u0002>\u0006\r\u0017QV\u0007\u0003\u0003\u007fSA!!1\u0002,\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0015\u0017q\u0018\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002L\u0006E\u0007\u0003BA\u0015\u0003\u001bLA!a4\u0002,\t9!i\\8mK\u0006t\u0007\"CA[\u001d\u0005\u0005\t\u0019AAW\u0003!A\u0017m\u001d5D_\u0012,GCAAR\u0003!!xn\u0015;sS:<GCAAH\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005}\u0007\u0003BAI\u0003CLA!a9\u0002\u0014\n1qJ\u00196fGRDs\u0001CAt\u0003[\fy\u000f\u0005\u0003\u0002*\u0005%\u0018\u0002BAv\u0003W\u0011\u0001cU3sS\u0006dg+\u001a:tS>tW+\u0013#\u0002\u000bY\fG.^3\u001f\u0003\u0005AsaBAt\u0003[\fyO\u0001\u0005D_:$\u0018m\u0019;t'%\u0011\u0012qEA9\u0003{\n\u0019)A\u0007d_:$\u0018m\u0019;Q_&tGo]\u000b\u0003\u0003w\u0004b!!@\u0003\u0004\t\u001dQBAA\u0000\u0015\u0011\u0011\t!a0\u0002\u0013%lW.\u001e;bE2,\u0017\u0002\u0002B\u0003\u0003\u007f\u0014!\"\u00138eKb,GmU3r!\u0011\u0011IAa\u0006\u000f\t\t-!1\u0003\t\u0005\u0005\u001b\tY#\u0004\u0002\u0003\u0010)!!\u0011CA\u000f\u0003\u0019a$o\\8u}%!!QCA\u0016\u0003\u0019\u0001&/\u001a3fM&!\u0011Q\u0014B\r\u0015\u0011\u0011)\"a\u000b\u0002\u001d\r|g\u000e^1diB{\u0017N\u001c;tAQ!!q\u0004B\u0011!\r\tYG\u0005\u0005\b\u0003o,\u0002\u0019AA~\u0003\u0011\u0019w\u000e]=\u0015\t\t}!q\u0005\u0005\n\u0003o4\u0002\u0013!a\u0001\u0003w\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003.)\"\u00111 B\u0018W\t\u0011\t\u0004\u0005\u0003\u00034\tuRB\u0001B\u001b\u0015\u0011\u00119D!\u000f\u0002\u0013Ut7\r[3dW\u0016$'\u0002\u0002B\u001e\u0003W\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yD!\u000e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0006\u0003\u0002.\n\r\u0003\"CA[5\u0005\u0005\t\u0019AAR)\u0011\tYMa\u0012\t\u0013\u0005UF$!AA\u0002\u00055\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002L\n5\u0003\"CA[?\u0005\u0005\t\u0019AAWQ\u001d\u0011\u0012q]Aw\u0003_\f\u0001bQ8oi\u0006\u001cGo\u001d\t\u0004\u0003W\n3#B\u0011\u0003X\u0005\r\u0005\u0003\u0003B-\u0005?\nYPa\b\u000e\u0005\tm#\u0002\u0002B/\u0003W\tqA];oi&lW-\u0003\u0003\u0003b\tm#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011!1K\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0005?\u0011I\u0007C\u0004\u0002x\u0012\u0002\r!a?\u0002\u000fUt\u0017\r\u001d9msR!!q\u000eB;!\u0019\tIC!\u001d\u0002|&!!1OA\u0016\u0005\u0019y\u0005\u000f^5p]\"I!qO\u0013\u0002\u0002\u0003\u0007!qD\u0001\u0004q\u0012\u0002\u0014!\u0003%fCJ$(-Z1u!\r\tY\u0007\u000b\u0002\n\u0011\u0016\f'\u000f\u001e2fCR\u001c2\u0002KA\u0014\u0003c\n9(! \u0002\u0004R\u0011!1\u0010\u000b\u0005\u0003[\u0013)\tC\u0005\u000262\n\t\u00111\u0001\u0002$R!\u00111\u001aBE\u0011%\t)LLA\u0001\u0002\u0004\ti\u000bK\u0004)\u0003O\fi/a<)\u000f\u001d\n9/!<\u0002p\u0006a\u0001*Z1si\n,\u0017\r\u001e*taB\u0019\u00111N\u001a\u0003\u0019!+\u0017M\u001d;cK\u0006$(k\u001d9\u0014\u0017M\n9#!\u001d\u0002x\u0005u\u00141\u0011\u000b\u0003\u0005##B!!,\u0003\u001c\"I\u0011QW\u001c\u0002\u0002\u0003\u0007\u00111\u0015\u000b\u0005\u0003\u0017\u0014y\nC\u0005\u00026f\n\t\u00111\u0001\u0002.\":1'a:\u0002n\u0006=\bf\u0002\u001a\u0002h\u00065\u0018q^\u0001\u0015%\u0016\u001cW\r\u001d;j_:L7\u000f^*ikR$wn\u001e8\u0011\u0007\u0005-dH\u0001\u000bSK\u000e,\u0007\u000f^5p]&\u001cHo\u00155vi\u0012|wO\\\n\f}\u0005\u001d\u0012\u0011OA<\u0003{\n\u0019\t\u0006\u0002\u0003(R!\u0011Q\u0016BY\u0011%\t)LQA\u0001\u0002\u0004\t\u0019\u000b\u0006\u0003\u0002L\nU\u0006\"CA[\t\u0006\u0005\t\u0019AAWQ\u001dq\u0014q]Aw\u0003_Ds!PAt\u0003[\fy/\u0001\u0003QS:<\u0007cAA6\u0013\n!\u0001+\u001b8h'%I\u0015qEA<\u0003{\n\u0019\t\u0006\u0002\u0003>R!\u0011Q\u0016Bd\u0011%\t),TA\u0001\u0002\u0004\t\u0019\u000b\u0006\u0003\u0002L\n-\u0007\"CA[\u001f\u0006\u0005\t\u0019AAWQ\u001dI\u0015q]Aw\u0003_Ds\u0001SAt\u0003[\fy/\u0001\bDQ\u0016\u001c7\u000eR3bI2Lg.Z:\u0011\u0007\u0005-DK\u0001\bDQ\u0016\u001c7\u000eR3bI2Lg.Z:\u0014\u000fQ\u000b9#! \u0002\u0004R\u0011!1\u001b\u000b\u0005\u0003[\u0013i\u000eC\u0005\u00026b\u000b\t\u00111\u0001\u0002$R!\u00111\u001aBq\u0011%\t)LWA\u0001\u0002\u0004\tiK\u0001\u000bDY&,g\u000e\u001e*fgB|gn]3Uk:tW\r\\\n\b=\u0006\u001d\"q\u001dBw!\u0011\tiD!;\n\t\t-\u0018q\b\u0002\u0006\u0003\u000e$xN\u001d\t\u0005\u0003{\u0011y/\u0003\u0003\u0003r\u0006}\"\u0001D!di>\u0014Hj\\4hS:<\u0017a\u0002;j[\u0016|W\u000f\u001e\t\u0005\u0005o\u001c\t!\u0004\u0002\u0003z*!!1 B\u007f\u0003!!WO]1uS>t'\u0002\u0002B\u0000\u0003W\t!bY8oGV\u0014(/\u001a8u\u0013\u0011\u0019\u0019A!?\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]R11qAB\u0005\u0007\u0017\u00012!a\u001b_\u0011\u001d\t\u0019\"\u0019a\u0001\u0003\u0017BqAa=b\u0001\u0004\u0011)0A\u0003jg\u0006\u001b8.\u0006\u0002\u0002L\u00061\u0011n]!tW\u0002\nqA]3dK&4X-\u0006\u0002\u0004\u0018AA\u0011\u0011FB\r\u0003[\u001bi\"\u0003\u0003\u0004\u001c\u0005-\"a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\u0011\t\u0005%2qD\u0005\u0005\u0007C\tYC\u0001\u0003V]&$8cB3\u0002(\t\u001d(Q\u001e\u000b\u0007\u0007O\u0019Ica\u000b\u0011\u0007\u0005\u0005R\rC\u0004\u0002J!\u0004\r!a\u0013\t\u000f\u0005M\u0003\u000e1\u0001\u0002VU\u00111q\u0006\t\u0005\u0007c\u0019\u0019$\u0004\u0002\u0002\u0016%!1QGA\u000b\u0005\u001d\u0019E.^:uKJ\f\u0001b\u00197vgR,'\u000fI\u0001\u0011m\u0016\u0014(m\\:f\u0011\u0016\f'\u000f\u001e2fCR\f\u0011C^3sE>\u001cX\rS3beR\u0014W-\u0019;!\u0003\u0015qw\u000eZ3t+\t\u0019\t\u0005\u0005\u0004\u0002~\u000e\r3qI\u0005\u0005\u0007\u000b\nyPA\u0005T_J$X\rZ*fiB!\u0011QHB%\u0013\u0011\u0019Y%a\u0010\u0003\u000f\u0005#GM]3tg\u0006Ian\u001c3fg~#S-\u001d\u000b\u0005\u0007;\u0019\t\u0006C\u0005\u00026:\f\t\u00111\u0001\u0004B\u00051an\u001c3fg\u0002\n!C^5siV\fGNT8eKN4\u0015m\u0019;pe\u0006\u0019b/\u001b:uk\u0006dgj\u001c3fg\u001a\u000b7\r^8sA\u0005q1m\u001c8tSN$XM\u001c;ICNDWCAB/!\u0019\u0019yf!\u001a\u0004H5\u00111\u0011\r\u0006\u0005\u0007G\nI\"A\u0004s_V$\u0018N\\4\n\t\r\u001d4\u0011\r\u0002\u000f\u0007>t7/[:uK:$\b*Y:i\u0003I\u0019wN\\:jgR,g\u000e\u001e%bg\"|F%Z9\u0015\t\ru1Q\u000e\u0005\n\u0003k\u001b\u0018\u0011!a\u0001\u0007;\nqbY8og&\u001cH/\u001a8u\u0011\u0006\u001c\b\u000eI\u0001\u0013G2LWM\u001c;J]R,'/Y2uS>t7/\u0006\u0002\u0004vAA\u0011Q`B<\u0003\u0017\u001aY(\u0003\u0003\u0004z\u0005}(a\u0002%bg\"l\u0015\r\u001d\t\u0005\u0007{\u001a\u0019)\u0004\u0002\u0004\u0000)!1\u0011QA\r\u0003\u0019\u0011X-\\8uK&!1QQB@\u0005]!U-\u00193mS:,g)Y5mkJ,G)\u001a;fGR|'/\u0001\fdY&,g\u000e^%oi\u0016\u0014\u0018m\u0019;j_:\u001cx\fJ3r)\u0011\u0019iba#\t\u0013\u0005Uf/!AA\u0002\rU\u0014aE2mS\u0016tG/\u00138uKJ\f7\r^5p]N\u0004\u0013\u0001E2mS\u0016tGo\u001d)vE2L7\u000f[3e+\t\u0019\u0019\n\u0005\u0004\u0002~\u000eU\u00151J\u0005\u0005\u0007/\u000byPA\u0004ICND7+\u001a;\u0002)\rd\u0017.\u001a8ugB+(\r\\5tQ\u0016$w\fJ3r)\u0011\u0019ib!(\t\u0013\u0005U\u00160!AA\u0002\rM\u0015!E2mS\u0016tGo\u001d)vE2L7\u000f[3eA\u0005Y1/\u001e2tGJL'-\u001a:t+\t\u0019)\u000b\u0005\u0004\u0002~\u000e\u001d\u00161J\u0005\u0005\u0007S\u000byP\u0001\u0004WK\u000e$xN]\u0001\u0010gV\u00147o\u0019:jE\u0016\u00148o\u0018\u0013fcR!1QDBX\u0011%\t)\f`A\u0001\u0002\u0004\u0019)+\u0001\u0007tk\n\u001c8M]5cKJ\u001c\b%\u0001\ndQ\u0016\u001c7\u000eR3bI2Lg.Z:UCN\\WCAB\\!\u0011\tid!/\n\t\rm\u0016q\b\u0002\f\u0007\u0006t7-\u001a7mC\ndW-A\ndQ\u0016\u001c7\u000eR3bI2Lg.Z:UCN\\\u0007%\u0001\u0005qe\u0016\u001cF/\u0019:u)\t\u0019i\"\u0001\u0005q_N$8\u000b^8q\u00031i\u0017\r^2iS:<'k\u001c7f)\u0011\tYm!3\t\u0011\r-\u0017Q\u0001a\u0001\u0007\u001b\f\u0011!\u001c\t\u0005\u0007c\u0019y-\u0003\u0003\u0004R\u0006U!AB'f[\n,'/\u0001\bsKN\u0004xN\\:f)Vtg.\u001a7\u0015\t\u0005-3q\u001b\u0005\t\u0003'\t9\u00011\u0001\u0002L\u0005AR\u000f\u001d3bi\u0016\u001cE.[3oi&sG/\u001a:bGRLwN\\:\u0015\t\ru1Q\u001c\u0005\t\u0003'\tY\u00011\u0001\u0002L\u0005I\u0002/\u001e2mSND7\t\\5f]R\u001cXK\u001c:fC\u000eD\u0017M\u00197f\u0001")
public final class ClusterReceptionist
implements Actor,
ActorLogging {
    public final ActorRef akka$cluster$client$ClusterReceptionist$$pubSubMediator;
    public final ClusterReceptionistSettings akka$cluster$client$ClusterReceptionist$$settings;
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private SortedSet<Address> nodes;
    private final int virtualNodesFactor;
    private ConsistentHash<Address> consistentHash;
    private HashMap<ActorRef, DeadlineFailureDetector> clientInteractions;
    private HashSet<ActorRef> clientsPublished;
    private Vector<ActorRef> subscribers;
    private final Cancellable checkDeadlinesTask;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public static Props props(ActorRef actorRef, ClusterReceptionistSettings clusterReceptionistSettings) {
        return ClusterReceptionist$.MODULE$.props(actorRef, clusterReceptionistSettings);
    }

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    public SortedSet<Address> nodes() {
        return this.nodes;
    }

    public void nodes_$eq(SortedSet<Address> x$1) {
        this.nodes = x$1;
    }

    public int virtualNodesFactor() {
        return this.virtualNodesFactor;
    }

    public ConsistentHash<Address> consistentHash() {
        return this.consistentHash;
    }

    public void consistentHash_$eq(ConsistentHash<Address> x$1) {
        this.consistentHash = x$1;
    }

    public HashMap<ActorRef, DeadlineFailureDetector> clientInteractions() {
        return this.clientInteractions;
    }

    public void clientInteractions_$eq(HashMap<ActorRef, DeadlineFailureDetector> x$1) {
        this.clientInteractions = x$1;
    }

    public HashSet<ActorRef> clientsPublished() {
        return this.clientsPublished;
    }

    public void clientsPublished_$eq(HashSet<ActorRef> x$1) {
        this.clientsPublished = x$1;
    }

    public Vector<ActorRef> subscribers() {
        return this.subscribers;
    }

    public void subscribers_$eq(Vector<ActorRef> x$1) {
        this.subscribers = x$1;
    }

    public Cancellable checkDeadlinesTask() {
        return this.checkDeadlinesTask;
    }

    public void preStart() {
        Actor.preStart$((Actor)this);
        Predef$.MODULE$.require(!this.cluster().isTerminated(), (Function0 & Serializable & scala.Serializable)() -> "Cluster node must not be terminated");
        this.cluster().subscribe(this.self(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class}));
    }

    public void postStop() {
        Actor.postStop$((Actor)this);
        this.cluster().unsubscribe(this.self());
        this.checkDeadlinesTask().cancel();
        this.clientInteractions().keySet().foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            ClusterReceptionist.$anonfun$postStop$2(this, x$9);
            return BoxedUnit.UNIT;
        });
    }

    public boolean matchingRole(Member m) {
        return this.akka$cluster$client$ClusterReceptionist$$settings.role().forall((Function1 & Serializable & scala.Serializable)role -> BoxesRunTime.boxToBoolean((boolean)m.hasRole(role)));
    }

    public ActorRef responseTunnel(ActorRef client) {
        ActorRef actorRef;
        String encName = URLEncoder.encode(client.path().toSerializationFormat(), "utf-8");
        Option option = this.context().child(encName);
        if (option instanceof Some) {
            ActorRef tunnel;
            Some some = (Some)option;
            actorRef = tunnel = (ActorRef)some.value();
        } else if (None$.MODULE$.equals(option)) {
            actorRef = this.context().actorOf(Props$.MODULE$.apply(Internal.ClientResponseTunnel.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{client, this.akka$cluster$client$ClusterReceptionist$$settings.responseTunnelReceiveTimeout()})), encName);
        } else {
            throw new MatchError((Object)option);
        }
        return actorRef;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterReceptionist $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                boolean bl = A1 instanceof DistributedPubSubMediator.Send ? true : (A1 instanceof DistributedPubSubMediator.SendToAll ? true : A1 instanceof DistributedPubSubMediator.Publish);
                if (bl) {
                    ActorRef tunnel = this.$outer.responseTunnel(this.$outer.sender());
                    package$.MODULE$.actorRef2Scala(tunnel).$bang((Object)ClusterReceptionist$Internal$Ping$.MODULE$, this.$outer.self());
                    this.$outer.akka$cluster$client$ClusterReceptionist$$pubSubMediator.tell(A1, tunnel);
                    object = BoxedUnit.UNIT;
                } else if (ClusterReceptionist$Internal$Heartbeat$.MODULE$.equals(A1)) {
                    if (this.$outer.verboseHeartbeat()) {
                        this.$outer.log().debug("Heartbeat from client [{}]", (Object)this.$outer.sender().path());
                    }
                    package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)ClusterReceptionist$Internal$HeartbeatRsp$.MODULE$, this.$outer.self());
                    this.$outer.updateClientInteractions(this.$outer.sender());
                    object = BoxedUnit.UNIT;
                } else if (ClusterReceptionist$Internal$GetContacts$.MODULE$.equals(A1)) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.akka$cluster$client$ClusterReceptionist$$settings.numberOfContacts() >= this.$outer.nodes().size()) {
                        Internal.Contacts contacts = new Internal.Contacts((IndexedSeq<String>)((IndexedSeq)this.$outer.nodes().iterator().map((Function1 & Serializable & scala.Serializable)a -> $this.$outer.self().path().toStringWithAddress(a)).to(akka.util.ccompat.package$.MODULE$.genericCompanionToCBF((GenericCompanion)IndexedSeq$.MODULE$))));
                        if (this.$outer.log().isDebugEnabled()) {
                            this.$outer.log().debug("Client [{}] gets contactPoints [{}] (all nodes)", (Object)this.$outer.sender().path(), (Object)contacts.contactPoints().mkString(","));
                        }
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)contacts, this.$outer.self());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Address a2 = (Address)this.$outer.consistentHash().nodeFor(this.$outer.sender().path().toStringWithAddress(this.$outer.cluster().selfAddress()));
                        SortedSet first = (SortedSet)((IterableLike)((TraversableLike)akka.util.ccompat.package$.MODULE$.SortedExtensionMethods(this.$outer.nodes()).rangeFrom((Object)a2)).tail()).take(this.$outer.akka$cluster$client$ClusterReceptionist$$settings.numberOfContacts());
                        SortedSet slice = first.size() == this.$outer.akka$cluster$client$ClusterReceptionist$$settings.numberOfContacts() ? first : (SortedSet)first.union((GenSet)this.$outer.nodes().take(this.$outer.akka$cluster$client$ClusterReceptionist$$settings.numberOfContacts() - first.size()));
                        Internal.Contacts contacts = new Internal.Contacts((IndexedSeq<String>)((IndexedSeq)slice.iterator().map((Function1 & Serializable & scala.Serializable)a -> $this.$outer.self().path().toStringWithAddress(a)).to(akka.util.ccompat.package$.MODULE$.genericCompanionToCBF((GenericCompanion)IndexedSeq$.MODULE$))));
                        if (this.$outer.log().isDebugEnabled()) {
                            this.$outer.log().debug("Client [{}] gets contactPoints [{}]", (Object)this.$outer.sender().path(), (Object)contacts.contactPoints().mkString(","));
                        }
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)contacts, this.$outer.self());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    this.$outer.nodes_$eq((SortedSet<Address>)((SortedSet)this.$outer.nodes().empty().union((GenSet)currentClusterState.members().collect((PartialFunction)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$receive$2 $outer;

                        public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            MemberStatus memberStatus = A1.status();
                            MemberStatus.Joining$ joining$ = MemberStatus.Joining$.MODULE$;
                            Object object = (memberStatus == null ? joining$ != null : !memberStatus.equals(joining$)) && this.$outer.akka$cluster$client$ClusterReceptionist$$anonfun$$$outer().matchingRole(A1) ? A1.address() : function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Member x1) {
                            Member member = x1;
                            MemberStatus memberStatus = member.status();
                            MemberStatus.Joining$ joining$ = MemberStatus.Joining$.MODULE$;
                            boolean bl = (memberStatus == null ? joining$ != null : !memberStatus.equals(joining$)) && this.$outer.akka$cluster$client$ClusterReceptionist$$anonfun$$$outer().matchingRole(member);
                            return bl;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, SortedSet$.MODULE$.newCanBuildFrom(Address$.MODULE$.addressOrdering())))));
                    this.$outer.consistentHash_$eq((ConsistentHash<Address>)ConsistentHash$.MODULE$.apply(this.$outer.nodes(), this.$outer.virtualNodesFactor(), ClassTag$.MODULE$.apply(Address.class)));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberUp) {
                    BoxedUnit boxedUnit;
                    ClusterEvent.MemberUp memberUp = (ClusterEvent.MemberUp)A1;
                    Member m = memberUp.member();
                    if (this.$outer.matchingRole(m)) {
                        this.$outer.nodes_$eq((SortedSet<Address>)((SortedSet)this.$outer.nodes().$plus((Object)m.address())));
                        this.$outer.consistentHash_$eq((ConsistentHash<Address>)ConsistentHash$.MODULE$.apply(this.$outer.nodes(), this.$outer.virtualNodesFactor(), ClassTag$.MODULE$.apply(Address.class)));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    BoxedUnit boxedUnit;
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    Address address = m.address();
                    Address address2 = this.$outer.cluster().selfAddress();
                    if (!(address != null ? !address.equals(address2) : address2 != null)) {
                        this.$outer.context().stop(this.$outer.self());
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (this.$outer.matchingRole(m)) {
                        this.$outer.nodes_$eq((SortedSet<Address>)((SortedSet)this.$outer.nodes().$minus((Object)m.address())));
                        this.$outer.consistentHash_$eq((ConsistentHash<Address>)ConsistentHash$.MODULE$.apply(this.$outer.nodes(), this.$outer.virtualNodesFactor(), ClassTag$.MODULE$.apply(Address.class)));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else if (A1 instanceof ClusterEvent.MemberEvent) {
                    object = BoxedUnit.UNIT;
                } else if (SubscribeClusterClients$.MODULE$.equals(A1)) {
                    ActorRef subscriber = this.$outer.sender();
                    package$.MODULE$.actorRef2Scala(subscriber).$bang((Object)new ClusterClients((Set<ActorRef>)((Set)this.$outer.clientInteractions().keySet().to(akka.util.ccompat.package$.MODULE$.genericCompanionToCBF((GenericCompanion)HashSet$.MODULE$)))), this.$outer.self());
                    this.$outer.subscribers_$eq((Vector<ActorRef>)((Vector)this.$outer.subscribers().$colon$plus((Object)subscriber, Vector$.MODULE$.canBuildFrom())));
                    this.$outer.context().watch(subscriber);
                    object = BoxedUnit.UNIT;
                } else if (UnsubscribeClusterClients$.MODULE$.equals(A1)) {
                    ActorRef subscriber = this.$outer.sender();
                    this.$outer.subscribers_$eq((Vector<ActorRef>)((Vector)this.$outer.subscribers().filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receive$2.$anonfun$applyOrElse$11(subscriber, x$10)))));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof Terminated) {
                    Terminated terminated = (Terminated)A1;
                    ActorRef subscriber = terminated.actor();
                    this.$outer.self().tell((Object)UnsubscribeClusterClients$.MODULE$, subscriber);
                    object = BoxedUnit.UNIT;
                } else if (GetClusterClients$.MODULE$.equals(A1)) {
                    package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)new ClusterClients((Set<ActorRef>)((Set)this.$outer.clientInteractions().keySet().to(akka.util.ccompat.package$.MODULE$.genericCompanionToCBF((GenericCompanion)HashSet$.MODULE$)))), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (ClusterReceptionist$Internal$CheckDeadlines$.MODULE$.equals(A1)) {
                    this.$outer.clientInteractions_$eq((HashMap<ActorRef, DeadlineFailureDetector>)this.$outer.clientInteractions().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receive$2.$anonfun$applyOrElse$12(x0$1))));
                    this.$outer.publishClientsUnreachable();
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DistributedPubSubMediator.Send ? true : (object instanceof DistributedPubSubMediator.SendToAll ? true : object instanceof DistributedPubSubMediator.Publish);
                boolean bl2 = bl ? true : (ClusterReceptionist$Internal$Heartbeat$.MODULE$.equals(object) ? true : (ClusterReceptionist$Internal$GetContacts$.MODULE$.equals(object) ? true : (object instanceof ClusterEvent.CurrentClusterState ? true : (object instanceof ClusterEvent.MemberUp ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.MemberEvent ? true : (SubscribeClusterClients$.MODULE$.equals(object) ? true : (UnsubscribeClusterClients$.MODULE$.equals(object) ? true : (object instanceof Terminated ? true : (GetClusterClients$.MODULE$.equals(object) ? true : ClusterReceptionist$Internal$CheckDeadlines$.MODULE$.equals(object)))))))))));
                return bl2;
            }

            public /* synthetic */ ClusterReceptionist akka$cluster$client$ClusterReceptionist$$anonfun$$$outer() {
                return this.$outer;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$11(ActorRef subscriber$2, ActorRef x$10) {
                ActorRef actorRef = x$10;
                ActorRef actorRef2 = subscriber$2;
                return !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$12(Tuple2 x0$1) {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DeadlineFailureDetector failureDetector = (DeadlineFailureDetector)tuple2._2();
                boolean bl = failureDetector.isAvailable();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$8(akka.cluster.client.ClusterReceptionist$$anonfun$receive$2 akka.actor.Address ), $anonfun$applyOrElse$9(akka.cluster.client.ClusterReceptionist$$anonfun$receive$2 akka.actor.Address ), $anonfun$applyOrElse$11$adapted(akka.actor.ActorRef akka.actor.ActorRef ), $anonfun$applyOrElse$12$adapted(scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public void updateClientInteractions(ActorRef client) {
        Option option = this.clientInteractions().get((Object)client);
        if (option instanceof Some) {
            Some some = (Some)option;
            DeadlineFailureDetector failureDetector = (DeadlineFailureDetector)some.value();
            failureDetector.heartbeat();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            DeadlineFailureDetector failureDetector = new DeadlineFailureDetector(this.akka$cluster$client$ClusterReceptionist$$settings.acceptableHeartbeatPause(), this.akka$cluster$client$ClusterReceptionist$$settings.heartbeatInterval(), FailureDetector$.MODULE$.defaultClock());
            failureDetector.heartbeat();
            this.clientInteractions_$eq((HashMap<ActorRef, DeadlineFailureDetector>)this.clientInteractions().$plus(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)client), (Object)failureDetector)));
            this.log().debug("Received new contact from [{}]", (Object)client.path());
            ClusterClientUp clusterClientUp = new ClusterClientUp(client);
            this.subscribers().foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                ClusterReceptionist.$anonfun$updateClientInteractions$1(this, clusterClientUp, x$11);
                return BoxedUnit.UNIT;
            });
            this.clientsPublished_$eq((HashSet<ActorRef>)((HashSet)this.clientInteractions().keySet().to(akka.util.ccompat.package$.MODULE$.genericCompanionToCBF((GenericCompanion)HashSet$.MODULE$))));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public void publishClientsUnreachable() {
        HashSet publishableClients = (HashSet)this.clientInteractions().keySet().to(akka.util.ccompat.package$.MODULE$.genericCompanionToCBF((GenericCompanion)HashSet$.MODULE$));
        this.clientsPublished().withFilter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)ClusterReceptionist.$anonfun$publishClientsUnreachable$1(publishableClients, c))).foreach((Function1 & Serializable & scala.Serializable)c -> {
            ClusterReceptionist.$anonfun$publishClientsUnreachable$2(this, c);
            return BoxedUnit.UNIT;
        });
        this.clientsPublished_$eq((HashSet<ActorRef>)publishableClients);
    }

    private static final int hashFor$1(Address node) {
        String host;
        Option option;
        block3: {
            block2: {
                Address address = node;
                if (address == null) break block2;
                Option option2 = address.host();
                option = address.port();
                if (!(option2 instanceof Some)) break block2;
                Some some = (Some)option2;
                host = (String)some.value();
                if (option instanceof Some) break block3;
            }
            throw new IllegalStateException(new StringBuilder(40).append("Unexpected address without host/port: [").append(node).append("]").toString());
        }
        Some some = (Some)option;
        int port = BoxesRunTime.unboxToInt((Object)some.value());
        int n = MurmurHash$.MODULE$.stringHash(new StringBuilder(1).append(host).append(":").append(port).toString());
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$nodes$1(Address a, Address b) {
        int hb;
        int ha = ClusterReceptionist.hashFor$1(a);
        return ha < (hb = ClusterReceptionist.hashFor$1(b)) || ha == hb && Member$.MODULE$.addressOrdering().compare((Object)a, (Object)b) < 0;
    }

    public static final /* synthetic */ void $anonfun$postStop$2(ClusterReceptionist $this, ActorRef x$9) {
        package$.MODULE$.actorRef2Scala(x$9).$bang((Object)ClusterReceptionist$Internal$ReceptionistShutdown$.MODULE$, $this.self());
    }

    public static final /* synthetic */ void $anonfun$updateClientInteractions$1(ClusterReceptionist $this, ClusterClientUp clusterClientUp$1, ActorRef x$11) {
        package$.MODULE$.actorRef2Scala(x$11).$bang((Object)clusterClientUp$1, $this.self());
    }

    public static final /* synthetic */ boolean $anonfun$publishClientsUnreachable$1(HashSet publishableClients$1, ActorRef c) {
        return !publishableClients$1.contains((Object)c);
    }

    public static final /* synthetic */ void $anonfun$publishClientsUnreachable$3(ClusterReceptionist $this, ClusterClientUnreachable clusterClientUnreachable$1, ActorRef x$12) {
        package$.MODULE$.actorRef2Scala(x$12).$bang((Object)clusterClientUnreachable$1, $this.self());
    }

    public static final /* synthetic */ void $anonfun$publishClientsUnreachable$2(ClusterReceptionist $this, ActorRef c) {
        $this.log().debug("Lost contact with [{}]", (Object)c.path());
        ClusterClientUnreachable clusterClientUnreachable = new ClusterClientUnreachable(c);
        $this.subscribers().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            ClusterReceptionist.$anonfun$publishClientsUnreachable$3($this, clusterClientUnreachable, x$12);
            return BoxedUnit.UNIT;
        });
    }

    public ClusterReceptionist(ActorRef pubSubMediator, ClusterReceptionistSettings settings) {
        this.akka$cluster$client$ClusterReceptionist$$pubSubMediator = pubSubMediator;
        this.akka$cluster$client$ClusterReceptionist$$settings = settings;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        Set set = this.cluster().selfRoles();
        Predef$.MODULE$.require(settings.role().forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("This cluster member [").append(this.cluster().selfAddress()).append("] doesn't have the role [").append($this.akka$cluster$client$ClusterReceptionist$$settings.role()).append("]").toString());
        Ordering ringOrdering = scala.package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ClusterReceptionist.$anonfun$nodes$1(a, b)));
        this.nodes = (SortedSet)SortedSet$.MODULE$.apply((Seq)Nil$.MODULE$, ringOrdering);
        this.virtualNodesFactor = 10;
        this.consistentHash = ConsistentHash$.MODULE$.apply(this.nodes(), this.virtualNodesFactor(), ClassTag$.MODULE$.apply(Address.class));
        this.clientInteractions = HashMap$.MODULE$.empty();
        this.clientsPublished = (HashSet)HashSet$.MODULE$.empty();
        this.subscribers = scala.package$.MODULE$.Vector().empty();
        Scheduler qual$1 = this.context().system().scheduler();
        FiniteDuration x$1 = settings.failureDetectionInterval();
        FiniteDuration x$2 = settings.failureDetectionInterval();
        ActorRef x$3 = this.self();
        ClusterReceptionist$Internal$CheckDeadlines$ x$4 = ClusterReceptionist$Internal$CheckDeadlines$.MODULE$;
        ExecutionContextExecutor x$5 = this.context().dispatcher();
        ActorRef x$6 = qual$1.schedule$default$6(x$1, x$2, x$3, (Object)x$4);
        this.checkDeadlinesTask = qual$1.schedule(x$1, x$2, x$3, (Object)x$4, (ExecutionContext)x$5, x$6);
    }
}

