/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils$;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class SyntheticHelper {
    static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = SyntheticHelper.createDocumentBuilderFactory();
    private static final Logger logger = LoggerFactory.getLogger(SyntheticHelper.class);

    SyntheticHelper() {
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema syntheticSchema = schemaFactory.newSchema(ClassLoaderUtils$.MODULE$.classLoader().getResource("synthetic.xsd"));
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setSchema(syntheticSchema);
        }
        catch (SAXException exc) {
            throw new RuntimeException("Cannot read schema synthetic.xsd", exc);
        }
        return documentBuilderFactory;
    }

    static Document readSyntheticDocument(final URL syntheticXML) throws IOException {
        InputStream syntheticXMLStream = syntheticXML.openStream();
        try {
            final boolean[] validationErrorsFound = new boolean[1];
            DocumentBuilder builder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exc) throws SAXException {
                    logger.warn("Warning while parsing " + syntheticXML, (Throwable)exc);
                }

                @Override
                public void error(SAXParseException exc) throws SAXException {
                    logger.error("Error while parsing " + syntheticXML, (Throwable)exc);
                    validationErrorsFound[0] = true;
                }

                @Override
                public void fatalError(SAXParseException exc) throws SAXException {
                    logger.error("Fatal error while parsing " + syntheticXML, (Throwable)exc);
                    validationErrorsFound[0] = true;
                }
            });
            Document doc = builder.parse(syntheticXMLStream);
            if (validationErrorsFound[0]) {
                throw new RuntimeException("One or more errors were found while parsing " + syntheticXML);
            }
            Document document = doc;
            return document;
        }
        catch (RuntimeException exc) {
            throw new RuntimeException("Cannot read synthetic configuration " + syntheticXML, exc);
        }
        catch (ParserConfigurationException exc) {
            throw new RuntimeException("Cannot read synthetic configuration " + syntheticXML, exc);
        }
        catch (SAXException exc) {
            throw new RuntimeException("Cannot read synthetic configuration " + syntheticXML, exc);
        }
        finally {
            Closeables.closeQuietly(syntheticXMLStream);
        }
    }
}

