/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.ConfigurationException;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Address$;
import akka.actor.ExtendedActorSystem;
import akka.dispatch.Dispatchers;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.MarkerLoggingAdapter;
import akka.remote.RARP;
import akka.remote.RARP$;
import akka.remote.transport.AssociationHandle;
import akka.remote.transport.Transport;
import akka.remote.transport.netty.ClientHandler;
import akka.remote.transport.netty.NettyFutureBridge$;
import akka.remote.transport.netty.NettySSLSupport$;
import akka.remote.transport.netty.NettyTransport$;
import akka.remote.transport.netty.NettyTransportException;
import akka.remote.transport.netty.NettyTransportExceptionNoStack;
import akka.remote.transport.netty.NettyTransportSettings;
import akka.remote.transport.netty.NettyTransportSettings$Tcp$;
import akka.remote.transport.netty.NettyTransportSettings$Udp$;
import akka.remote.transport.netty.SSLEngineProvider;
import akka.remote.transport.netty.ServerHandler;
import akka.remote.transport.netty.TcpClientHandler;
import akka.remote.transport.netty.TcpServerHandler;
import akka.remote.transport.netty.UdpAssociationHandle;
import akka.remote.transport.netty.UdpClientHandler;
import akka.remote.transport.netty.UdpServerHandler;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rErAB A\u0011\u0003\u0011\u0005J\u0002\u0004K\u0001\"\u0005!i\u0013\u0005\u0006%\u0006!\t\u0001\u0016\u0005\b+\u0006\u0011\r\u0011\"\u0001W\u0011\u0019Q\u0016\u0001)A\u0005/\")1,\u0001C\u00019\"9Q/\u0001b\u0001\n\u00031\bbBA\u0003\u0003\u0001\u0006Ia\u001e\u0005\b\u0003\u000f\tA\u0011AA\u0005\u0011\u001d\t9!\u0001C\u0001\u0003/2QA\u0013!\u0001\u0003CB!\"a\u001b\u000b\u0005\u000b\u0007I\u0011AA7\u0011)\t)H\u0003B\u0001B\u0003%\u0011q\u000e\u0005\u000b\u0003oR!Q1A\u0005\u0002\u0005e\u0004BCAA\u0015\t\u0005\t\u0015!\u0003\u0002|!1!K\u0003C\u0001\u0003\u0007CaA\u0015\u0006\u0005\u0002\u0005-\u0005\"CAT\u0015\t\u0007I1AAU\u0011\u001d\tYK\u0003Q\u0001\n\rD\u0011\"a\f\u000b\u0005\u0004%\t%!,\t\u0011\u0005=&\u0002)A\u0005\u0003cAa!!-\u000b\t\u00032\u0006\"CAZ\u0015\t\u0007IQBA[\u0011!\tiL\u0003Q\u0001\u000e\u0005]\u0006bCA`\u0015\u0001\u0007\t\u0019!C\u0005\u0003\u0003D1\"a1\u000b\u0001\u0004\u0005\r\u0011\"\u0003\u0002F\"Y\u00111\u001a\u0006A\u0002\u0003\u0005\u000b\u0015BA\t\u0011-\t)N\u0003a\u0001\u0002\u0004%I!!1\t\u0017\u0005]'\u00021AA\u0002\u0013%\u0011\u0011\u001c\u0005\f\u0003;T\u0001\u0019!A!B\u0013\t\t\u0002C\u0006\u0002b*\u0001\r\u00111A\u0005\n\u0005\r\bbCAs\u0015\u0001\u0007\t\u0019!C\u0005\u0003OD!\"a;\u000b\u0001\u0004\u0005\t\u0015)\u0003l\u0011%\tyO\u0003b\u0001\n\u0013\t\t\u0010\u0003\u0005\u0002\u0000*\u0001\u000b\u0011BAz\u0011)\u0011\tA\u0003b\u0001\n\u000b\u0001%1\u0001\u0005\t\u0005OQ\u0001\u0015!\u0004\u0003\u0006!9!\u0011\u0006\u0006\u0005\n\t-\u0002\"\u0003B\u001a\u0015\t\u0007I\u0011\u0001B\u001b\u0011!\u0011\u0019E\u0003Q\u0001\n\t]\u0002\"\u0003B#\u0015\t\u0007I\u0011\u0002B$\u0011!\u0011yE\u0003Q\u0001\n\t%\u0003\"\u0003B)\u0015\t\u0007I\u0011\u0002B$\u0011!\u0011\u0019F\u0003Q\u0001\n\t%\u0003b\u0002B+\u0015\u0011%!q\u000b\u0005\n\u0005?R!\u0019!C\u0005\u0005CB\u0001Ba\u001e\u000bA\u0003%!1\r\u0005\n\u0005sR!\u0019!C\u0005\u0005wB\u0001B!$\u000bA\u0003%!Q\u0010\u0005\b\u0005\u001fSA\u0011\u0002BI\u0011%\u00119K\u0003b\u0001\n\u0013\u0011I\u000b\u0003\u0005\u00032*\u0001\u000b\u0011\u0002BV\u0011\u001d\u0011\u0019L\u0003C\u0005\u0005kCqAa/\u000b\t\u0013\u0011i\fC\u0005\u0003d*\u0011\r\u0011\"\u0003\u0003f\"A!q\u001d\u0006!\u0002\u0013\u0011\t\u000eC\u0004\u0003j*!IAa;\t\u000f\tU(\u0002\"\u0011\u0003x\"9!Q \u0006\u0005\u0002\t}\bbBB\b\u0015\u0011\u00053\u0011\u0003\u0005\t\u00077QA\u0011\u0001$\u0002B\"91Q\u0004\u0006\u0005B\r}\u0001bBB\u0016\u0015\u0011\u00053QF\u0001\u000f\u001d\u0016$H/\u001f+sC:\u001c\bo\u001c:u\u0015\t\t%)A\u0003oKR$\u0018P\u0003\u0002D\t\u0006IAO]1ogB|'\u000f\u001e\u0006\u0003\u000b\u001a\u000baA]3n_R,'\"A$\u0002\t\u0005\\7.\u0019\t\u0003\u0013\u0006i\u0011\u0001\u0011\u0002\u000f\u001d\u0016$H/\u001f+sC:\u001c\bo\u001c:u'\t\tA\n\u0005\u0002N!6\taJC\u0001P\u0003\u0015\u00198-\u00197b\u0013\t\tfJ\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0001*\u0001\fGe\u0006lW\rT3oORDg)[3mI2+gn\u001a;i+\u00059\u0006CA'Y\u0013\tIfJA\u0002J]R\fqC\u0012:b[\u0016dUM\\4uQ\u001aKW\r\u001c3MK:<G\u000f\u001b\u0011\u0002\u001b\u001d\u0014\u0018mY3gk2\u001cEn\\:f)\ti\u0016\u000e\u0006\u0002_CB\u0011QjX\u0005\u0003A:\u0013A!\u00168ji\")!-\u0002a\u0002G\u0006\u0011Qm\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003M:\u000b!bY8oGV\u0014(/\u001a8u\u0013\tAWM\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\")!.\u0002a\u0001W\u000691\r[1o]\u0016d\u0007C\u00017t\u001b\u0005i'B\u00016o\u0015\t\tuN\u0003\u0002qc\u0006)!NY8tg*\t!/A\u0002pe\u001eL!\u0001^7\u0003\u000f\rC\u0017M\u001c8fY\u0006yQO\\5rk\u0016LEmQ8v]R,'/F\u0001x!\rA\u0018\u0011A\u0007\u0002s*\u0011!p_\u0001\u0007CR|W.[2\u000b\u0005\u0019d(BA?\u007f\u0003\u0011)H/\u001b7\u000b\u0003}\fAA[1wC&\u0019\u00111A=\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003A)h.[9vK&#7i\\;oi\u0016\u0014\b%\u0001\rbI\u0012\u0014Xm]:Ge>l7k\\2lKR\fE\r\u001a:fgN$B\"a\u0003\u0002\u001e\u00055\u0012qIA&\u0003#\u0002R!TA\u0007\u0003#I1!a\u0004O\u0005\u0019y\u0005\u000f^5p]B!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018\u0019\u000bQ!Y2u_JLA!a\u0007\u0002\u0016\t9\u0011\t\u001a3sKN\u001c\bbBA\u0010\u0011\u0001\u0007\u0011\u0011E\u0001\u0005C\u0012$'\u000f\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9C`\u0001\u0004]\u0016$\u0018\u0002BA\u0016\u0003K\u0011QbU8dW\u0016$\u0018\t\u001a3sKN\u001c\bbBA\u0018\u0011\u0001\u0007\u0011\u0011G\u0001\u0011g\u000eDW-\\3JI\u0016tG/\u001b4jKJ\u0004B!a\r\u0002B9!\u0011QGA\u001f!\r\t9DT\u0007\u0003\u0003sQ1!a\u000fT\u0003\u0019a$o\\8u}%\u0019\u0011q\b(\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019%!\u0012\u0003\rM#(/\u001b8h\u0015\r\tyD\u0014\u0005\b\u0003\u0013B\u0001\u0019AA\u0019\u0003)\u0019\u0018p\u001d;f[:\u000bW.\u001a\u0005\b\u0003\u001bB\u0001\u0019AA(\u0003!Awn\u001d;OC6,\u0007#B'\u0002\u000e\u0005E\u0002bBA*\u0011\u0001\u0007\u0011QK\u0001\u0005a>\u0014H\u000f\u0005\u0003N\u0003\u001b9FCCA\u0006\u00033\nY&!\u0018\u0002`!9\u0011qD\u0005A\u0002\u0005\u0005\u0002bBA\u0018\u0013\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003\u0013J\u0001\u0019AA\u0019\u0011\u001d\ti%\u0003a\u0001\u0003\u001f\u001aBA\u0003'\u0002dA!\u0011QMA4\u001b\u0005\u0011\u0015bAA5\u0005\nIAK]1ogB|'\u000f^\u0001\tg\u0016$H/\u001b8hgV\u0011\u0011q\u000e\t\u0004\u0013\u0006E\u0014bAA:\u0001\n1b*\u001a;usR\u0013\u0018M\\:q_J$8+\u001a;uS:<7/A\u0005tKR$\u0018N\\4tA\u000511/_:uK6,\"!a\u001f\u0011\t\u0005M\u0011QP\u0005\u0005\u0003\u007f\n)BA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.A\u0004tsN$X-\u001c\u0011\u0015\r\u0005\u0015\u0015qQAE!\tI%\u0002C\u0004\u0002l=\u0001\r!a\u001c\t\u000f\u0005]t\u00021\u0001\u0002|Q1\u0011QQAG\u0003\u001fCq!a\u001e\u0011\u0001\u0004\tY\bC\u0004\u0002\u0012B\u0001\r!a%\u0002\t\r|gN\u001a\t\u0005\u0003+\u000b\u0019+\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003\u0019\u0019wN\u001c4jO*!\u0011QTAP\u0003!!\u0018\u0010]3tC\u001a,'BAAQ\u0003\r\u0019w.\\\u0005\u0005\u0003K\u000b9J\u0001\u0004D_:4\u0017nZ\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR,\u0012aY\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004SCAA\u0019\u0003E\u00198\r[3nK&#WM\u001c;jM&,'\u000fI\u0001\u0014[\u0006D\u0018.\\;n!\u0006LHn\\1e\u0005f$Xm]\u0001\u000bSN$\u0015\r^1he\u0006lWCAA\\!\ri\u0015\u0011X\u0005\u0004\u0003ws%a\u0002\"p_2,\u0017M\\\u0001\fSN$\u0015\r^1he\u0006l\u0007%\u0001\u0007m_\u000e\fG.\u00113ee\u0016\u001c8/\u0006\u0002\u0002\u0012\u0005\u0001Bn\\2bY\u0006#GM]3tg~#S-\u001d\u000b\u0004=\u0006\u001d\u0007\"CAe3\u0005\u0005\t\u0019AA\t\u0003\rAH%M\u0001\u000eY>\u001c\u0017\r\\!eIJ,7o\u001d\u0011)\u0007i\ty\rE\u0002N\u0003#L1!a5O\u0005!1x\u000e\\1uS2,\u0017a\u00022pk:$Gk\\\u0001\fE>,h\u000e\u001a+p?\u0012*\u0017\u000fF\u0002_\u00037D\u0011\"!3\u001d\u0003\u0003\u0005\r!!\u0005\u0002\u0011\t|WO\u001c3U_\u0002B3!HAh\u00035\u0019XM\u001d<fe\u000eC\u0017M\u001c8fYV\t1.A\ttKJ4XM]\"iC:tW\r\\0%KF$2AXAu\u0011!\tImHA\u0001\u0002\u0004Y\u0017AD:feZ,'o\u00115b]:,G\u000e\t\u0015\u0004A\u0005=\u0017a\u00017pOV\u0011\u00111\u001f\t\u0005\u0003k\fY0\u0004\u0002\u0002x*\u0019\u0011\u0011 $\u0002\u000b\u00154XM\u001c;\n\t\u0005u\u0018q\u001f\u0002\u0015\u001b\u0006\u00148.\u001a:M_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\t1|w\rI\u0001\u0013k\u0012\u00048i\u001c8oK\u000e$\u0018n\u001c8UC\ndW-\u0006\u0002\u0003\u0006AA!q\u0001B\u0005\u0003C\u0011i!D\u0001|\u0013\r\u0011Ya\u001f\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003\u0002B\b\u0005CqAA!\u0005\u0003\u001e9!!1\u0003B\u000e\u001d\u0011\u0011)B!\u0007\u000f\t\u0005]\"qC\u0005\u0002\u000f&\u0011QIR\u0005\u0003\u0007\u0012K1Aa\bC\u0003E\t5o]8dS\u0006$\u0018n\u001c8IC:$G.Z\u0005\u0005\u0005G\u0011)CA\nIC:$G.Z#wK:$H*[:uK:,'OC\u0002\u0003 \t\u000b1#\u001e3q\u0007>tg.Z2uS>tG+\u00192mK\u0002\nQc\u0019:fCR,W\t_3dkR|'oU3sm&\u001cW\r\u0006\u0002\u0003.A!!q\u0001B\u0018\u0013\r\u0011\td\u001f\u0002\t\u000bb,7-\u001e;pe\u0006a1\r[1o]\u0016dwI]8vaV\u0011!q\u0007\t\u0005\u0005s\u0011y$\u0004\u0002\u0003<)\u0019!QH7\u0002\u000b\u001d\u0014x.\u001e9\n\t\t\u0005#1\b\u0002\u0014\t\u00164\u0017-\u001e7u\u0007\"\fgN\\3m\u000fJ|W\u000f]\u0001\u000eG\"\fgN\\3m\u000fJ|W\u000f\u001d\u0011\u0002)\rd\u0017.\u001a8u\u0007\"\fgN\\3m\r\u0006\u001cGo\u001c:z+\t\u0011I\u0005E\u0002m\u0005\u0017J1A!\u0014n\u00059\u0019\u0005.\u00198oK24\u0015m\u0019;pef\fQc\u00197jK:$8\t[1o]\u0016dg)Y2u_JL\b%\u0001\u000btKJ4XM]\"iC:tW\r\u001c$bGR|'/_\u0001\u0016g\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7GC\u000e$xN]=!\u0003-qWm\u001e)ja\u0016d\u0017N\\3\u0016\u0005\te\u0003c\u00017\u0003\\%\u0019!QL7\u0003-\u0011+g-Y;mi\u000eC\u0017M\u001c8fYBK\u0007/\u001a7j]\u0016\f!$Y:t_\u000eL\u0017\r^5p]2K7\u000f^3oKJ\u0004&o\\7jg\u0016,\"Aa\u0019\u0011\u000b\u0011\u0014)G!\u001b\n\u0007\t\u001dTMA\u0004Qe>l\u0017n]3\u0011\t\t-$\u0011\u000f\b\u0005\u0005#\u0011i'C\u0002\u0003p\t\u000b\u0011\u0002\u0016:b]N\u0004xN\u001d;\n\t\tM$Q\u000f\u0002\u0019\u0003N\u001cxnY5bi&|g.\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014(b\u0001B8\u0005\u0006Y\u0012m]:pG&\fG/[8o\u0019&\u001cH/\u001a8feB\u0013x.\\5tK\u0002\n\u0011c]:m\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3s+\t\u0011i\b\u0005\u0004\u0003\u0000\t\r%qQ\u0007\u0003\u0005\u0003S!! $\n\t\t\u0015%\u0011\u0011\u0002\n\u001fB$\u0018n\u001c8WC2\u00042!\u0013BE\u0013\r\u0011Y\t\u0011\u0002\u0012'NcUI\\4j]\u0016\u0004&o\u001c<jI\u0016\u0014\u0018AE:tY\u0016sw-\u001b8f!J|g/\u001b3fe\u0002\n!b]:m\u0011\u0006tG\r\\3s)\u0011\u0011\u0019Ja)\u0011\t\tU%qT\u0007\u0003\u0005/SAA!'\u0003\u001c\u0006\u00191o\u001d7\u000b\u0007\tue.A\u0004iC:$G.\u001a:\n\t\t\u0005&q\u0013\u0002\u000b'Nd\u0007*\u00198eY\u0016\u0014\bb\u0002BSc\u0001\u0007\u0011qW\u0001\tSN\u001cE.[3oi\u0006)2/\u001a:wKJ\u0004\u0016\u000e]3mS:,g)Y2u_JLXC\u0001BV!\ra'QV\u0005\u0004\u0005_k'AF\"iC:tW\r\u001c)ja\u0016d\u0017N\\3GC\u000e$xN]=\u0002-M,'O^3s!&\u0004X\r\\5oK\u001a\u000b7\r^8ss\u0002\nQc\u00197jK:$\b+\u001b9fY&tWMR1di>\u0014\u0018\u0010\u0006\u0003\u0003,\n]\u0006b\u0002B]i\u0001\u0007\u0011\u0011C\u0001\u000ee\u0016lw\u000e^3BI\u0012\u0014Xm]:\u0002\u001dM,G/\u001e9C_>$8\u000f\u001e:baV!!q\u0018Bc)\u0019\u0011\tM!8\u0003`B!!1\u0019Bc\u0019\u0001!qAa26\u0005\u0004\u0011IMA\u0001C#\u0011\u0011YM!5\u0011\u00075\u0013i-C\u0002\u0003P:\u0013qAT8uQ&tw\r\u0005\u0003\u0003T\neWB\u0001Bk\u0015\r\u00119N\\\u0001\nE>|Go\u001d;sCBLAAa7\u0003V\nI!i\\8ugR\u0014\u0018\r\u001d\u0005\b\u0005/,\u0004\u0019\u0001Ba\u0011\u001d\u0011\t/\u000ea\u0001\u0005W\u000bq\u0002]5qK2Lg.\u001a$bGR|'/_\u0001\u0011S:\u0014w.\u001e8e\u0005>|Go\u001d;sCB,\"A!5\u0002#%t'm\\;oI\n{w\u000e^:ue\u0006\u0004\b%A\tpkR\u0014w.\u001e8e\u0005>|Go\u001d;sCB$BA!<\u0003tB!!1\u001bBx\u0013\u0011\u0011\tP!6\u0003\u001f\rc\u0017.\u001a8u\u0005>|Go\u001d;sCBDqA!/9\u0001\u0004\t\t\"\u0001\tjgJ+7\u000f]8og&\u0014G.\u001a$peR!\u0011q\u0017B}\u0011\u001d\u0011Y0\u000fa\u0001\u0003#\tq!\u00193ee\u0016\u001c8/\u0001\fbI\u0012\u0014Xm]:U_N{7m[3u\u0003\u0012$'/Z:t)\u0011\u0019\ta!\u0004\u0011\u000b\u0011\u001c\u0019aa\u0002\n\u0007\r\u0015QM\u0001\u0004GkR,(/\u001a\t\u0005\u0003G\u0019I!\u0003\u0003\u0004\f\u0005\u0015\"!E%oKR\u001cvnY6fi\u0006#GM]3tg\"9\u0011q\u0004\u001eA\u0002\u0005E\u0011A\u00027jgR,g.\u0006\u0002\u0004\u0014A)Ama\u0001\u0004\u0016A9Qja\u0006\u0002\u0012\t\r\u0014bAB\r\u001d\n1A+\u001e9mKJ\nABY8v]\u0012\fE\r\u001a:fgN\f\u0011\"Y:t_\u000eL\u0017\r^3\u0015\t\r\u00052\u0011\u0006\t\u0006I\u000e\r11\u0005\t\u0005\u0003K\u001a)#C\u0002\u0004(\t\u0013\u0011#Q:t_\u000eL\u0017\r^5p]\"\u000bg\u000e\u001a7f\u0011\u001d\u0011I,\u0010a\u0001\u0003#\t\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0007_\u0001R\u0001ZB\u0002\u0003o\u0003")
public class NettyTransport
implements Transport {
    private final NettyTransportSettings settings;
    private final ExtendedActorSystem system;
    private final ExecutionContext executionContext;
    private final String schemeIdentifier;
    private final boolean akka$remote$transport$netty$NettyTransport$$isDatagram;
    private volatile Address localAddress;
    private volatile Address boundTo;
    private volatile Channel serverChannel;
    private final MarkerLoggingAdapter akka$remote$transport$netty$NettyTransport$$log;
    private final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable;
    private final DefaultChannelGroup channelGroup;
    private final ChannelFactory clientChannelFactory;
    private final ChannelFactory serverChannelFactory;
    private final Promise<Transport.AssociationEventListener> akka$remote$transport$netty$NettyTransport$$associationListenerPromise;
    private final SSLEngineProvider sslEngineProvider;
    private final ChannelPipelineFactory serverPipelineFactory;
    private final Bootstrap inboundBootstrap;

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option);
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option, Option<Object> option2) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option, option2);
    }

    public static AtomicInteger uniqueIdCounter() {
        return NettyTransport$.MODULE$.uniqueIdCounter();
    }

    public static void gracefulClose(Channel channel, ExecutionContext executionContext) {
        NettyTransport$.MODULE$.gracefulClose(channel, executionContext);
    }

    public static int FrameLengthFieldLength() {
        return NettyTransport$.MODULE$.FrameLengthFieldLength();
    }

    @Override
    public Future<Object> managementCommand(Object cmd) {
        return Transport.managementCommand$(this, cmd);
    }

    public NettyTransportSettings settings() {
        return this.settings;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String schemeIdentifier() {
        return this.schemeIdentifier;
    }

    @Override
    public int maximumPayloadBytes() {
        return this.settings().MaxFrameSize();
    }

    public final boolean akka$remote$transport$netty$NettyTransport$$isDatagram() {
        return this.akka$remote$transport$netty$NettyTransport$$isDatagram;
    }

    private Address localAddress() {
        return this.localAddress;
    }

    private void localAddress_$eq(Address x$1) {
        this.localAddress = x$1;
    }

    private Address boundTo() {
        return this.boundTo;
    }

    private void boundTo_$eq(Address x$1) {
        this.boundTo = x$1;
    }

    private Channel serverChannel() {
        return this.serverChannel;
    }

    private void serverChannel_$eq(Channel x$1) {
        this.serverChannel = x$1;
    }

    public MarkerLoggingAdapter akka$remote$transport$netty$NettyTransport$$log() {
        return this.akka$remote$transport$netty$NettyTransport$$log;
    }

    public final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable() {
        return this.udpConnectionTable;
    }

    private Executor createExecutorService() {
        Dispatchers dispatchers = this.system().dispatchers();
        return (Executor)this.settings().UseDispatcherForIo().map((Function1 & Serializable & scala.Serializable)id -> dispatchers.lookup(id)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Executors.newCachedThreadPool(this.system().threadFactory()));
    }

    public DefaultChannelGroup channelGroup() {
        return this.channelGroup;
    }

    private ChannelFactory clientChannelFactory() {
        return this.clientChannelFactory;
    }

    private ChannelFactory serverChannelFactory() {
        return this.serverChannelFactory;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultChannelPipeline akka$remote$transport$netty$NettyTransport$$newPipeline() {
        void var1_1;
        block0: {
            DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
            if (this.akka$remote$transport$netty$NettyTransport$$isDatagram()) break block0;
            pipeline.addLast("FrameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.maximumPayloadBytes(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), true));
            pipeline.addLast("FrameEncoder", (ChannelHandler)new LengthFieldPrepender(NettyTransport$.MODULE$.FrameLengthFieldLength()));
        }
        return var1_1;
    }

    public Promise<Transport.AssociationEventListener> akka$remote$transport$netty$NettyTransport$$associationListenerPromise() {
        return this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise;
    }

    private SSLEngineProvider sslEngineProvider() {
        return this.sslEngineProvider;
    }

    public SslHandler akka$remote$transport$netty$NettyTransport$$sslHandler(boolean isClient) {
        SSLEngineProvider sSLEngineProvider = this.sslEngineProvider();
        SSLEngineProvider sSLEngineProvider2 = (SSLEngineProvider)OptionVal.Some$.MODULE$.unapply((Object)sSLEngineProvider);
        if (OptionVal$.MODULE$.isEmpty$extension((Object)sSLEngineProvider2)) {
            OptionVal$.MODULE$.None();
            SSLEngineProvider sSLEngineProvider3 = sSLEngineProvider;
            if (!(null != null ? !((Object)null).equals(sSLEngineProvider3) : sSLEngineProvider3 != null)) {
                throw new IllegalStateException("Expected enable-ssl=on");
            }
            throw new MatchError((Object)new OptionVal((Object)sSLEngineProvider));
        }
        SSLEngineProvider sslProvider = (SSLEngineProvider)OptionVal$.MODULE$.get$extension((Object)sSLEngineProvider2);
        SslHandler handler = NettySSLSupport$.MODULE$.apply(sslProvider, isClient);
        handler.setCloseOnSSLException(true);
        SslHandler sslHandler = handler;
        return sslHandler;
    }

    private ChannelPipelineFactory serverPipelineFactory() {
        return this.serverPipelineFactory;
    }

    private ChannelPipelineFactory clientPipelineFactory(Address remoteAddress) {
        return new ChannelPipelineFactory(this, remoteAddress){
            private final /* synthetic */ NettyTransport $outer;
            private final Address remoteAddress$1;

            /*
             * WARNING - void declaration
             */
            public ChannelPipeline getPipeline() {
                void var1_1;
                DefaultChannelPipeline pipeline = this.$outer.akka$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", (ChannelHandler)this.$outer.akka$remote$transport$netty$NettyTransport$$sslHandler(true));
                }
                ClientHandler handler = this.$outer.akka$remote$transport$netty$NettyTransport$$isDatagram() ? new UdpClientHandler(this.$outer, this.remoteAddress$1) : new TcpClientHandler(this.$outer, this.remoteAddress$1, (LoggingAdapter)this.$outer.akka$remote$transport$netty$NettyTransport$$log());
                pipeline.addLast("clienthandler", (ChannelHandler)handler);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.remoteAddress$1 = remoteAddress$1;
            }
        };
    }

    private <B extends Bootstrap> B setupBootstrap(B bootstrap, ChannelPipelineFactory pipelineFactory) {
        bootstrap.setPipelineFactory(pipelineFactory);
        bootstrap.setOption("backlog", (Object)BoxesRunTime.boxToInteger((int)this.settings().Backlog()));
        bootstrap.setOption("child.tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpNodelay()));
        bootstrap.setOption("child.keepAlive", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpKeepalive()));
        bootstrap.setOption("reuseAddress", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpReuseAddr()));
        if (this.akka$remote$transport$netty$NettyTransport$$isDatagram()) {
            bootstrap.setOption("receiveBufferSizePredictorFactory", (Object)new FixedReceiveBufferSizePredictorFactory(BoxesRunTime.unboxToInt((Object)this.settings().ReceiveBufferSize().get())));
        }
        this.settings().ReceiveBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("receiveBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().SendBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("sendBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferHighWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferLowWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        return bootstrap;
    }

    private Bootstrap inboundBootstrap() {
        return this.inboundBootstrap;
    }

    /*
     * WARNING - void declaration
     */
    private ClientBootstrap outboundBootstrap(Address remoteAddress) {
        void var2_2;
        ClientBootstrap bootstrap = this.setupBootstrap(new ClientBootstrap(this.clientChannelFactory()), this.clientPipelineFactory(remoteAddress));
        bootstrap.setOption("connectTimeoutMillis", (Object)BoxesRunTime.boxToLong((long)this.settings().ConnectionTimeout().toMillis()));
        bootstrap.setOption("tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpNodelay()));
        bootstrap.setOption("keepAlive", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpKeepalive()));
        this.settings().ReceiveBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("receiveBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().SendBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("sendBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferHighWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferLowWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        return var2_2;
    }

    @Override
    public boolean isResponsibleFor(Address address) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Future<InetSocketAddress> addressToSocketAddress(Address addr) {
        Address address = addr;
        if (address == null) return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(53).append("Address [").append(addr).append("] does not contain host or port information.").toString()));
        Option option = address.host();
        Option option2 = address.port();
        if (!(option instanceof Some)) return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(53).append("Address [").append(addr).append("] does not contain host or port information.").toString()));
        Some some = (Some)option;
        String host = (String)some.value();
        if (!(option2 instanceof Some)) return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(53).append("Address [").append(addr).append("] does not contain host or port information.").toString()));
        Some some2 = (Some)option2;
        int port = BoxesRunTime.unboxToInt((Object)some2.value());
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (InetSocketAddress)package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> new InetSocketAddress(InetAddress.getByName(host), port)), this.executionContext());
    }

    @Override
    public Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> listen() {
        return this.addressToSocketAddress(Address$.MODULE$.apply("", "", this.settings().BindHostname(), this.settings().BindPortSelector())).map((Function1 & Serializable & scala.Serializable)address -> {
            Tuple2 tuple2;
            try {
                Address address2;
                Channel channel;
                Bootstrap bootstrap = this.inboundBootstrap();
                if (bootstrap instanceof ServerBootstrap) {
                    ServerBootstrap serverBootstrap = (ServerBootstrap)bootstrap;
                    channel = serverBootstrap.bind((SocketAddress)address);
                } else if (bootstrap instanceof ConnectionlessBootstrap) {
                    ConnectionlessBootstrap connectionlessBootstrap = (ConnectionlessBootstrap)bootstrap;
                    channel = connectionlessBootstrap.bind((SocketAddress)address);
                } else {
                    throw new MatchError((Object)bootstrap);
                }
                Channel newServerChannel = channel;
                newServerChannel.setReadable(false);
                this.channelGroup().add(newServerChannel);
                this.serverChannel_$eq(newServerChannel);
                Option<Address> option = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)new Some((Object)this.settings().Hostname()), (Option<Object>)(this.settings().PortSelector() == 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)this.settings().PortSelector()))));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    address2 = (Address)some.value();
                    Option<Address> option2 = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    if (!(option2 instanceof Some)) {
                        if (None$.MODULE$.equals(option2)) {
                            throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.getLocalAddress().getClass().getName()).append("]").toString());
                        }
                        throw new MatchError(option2);
                    }
                    Some some2 = (Some)option2;
                    Address address3 = (Address)some2.value();
                    this.boundTo_$eq(address3);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.getLocalAddress().getClass().getName()).append("]").toString());
                    }
                    throw new MatchError(option);
                }
                this.localAddress_$eq(address2);
                this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise().future().foreach((Function1 & Serializable & scala.Serializable)x$4 -> newServerChannel.setReadable(true), this.executionContext());
                Tuple2 tuple22 = new Tuple2((Object)address2, this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise());
                tuple2 = tuple22;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    this.akka$remote$transport$netty$NettyTransport$$log().error("failed to bind to {}, shutting down Netty transport", address);
                    try {
                        boxedUnit = this.shutdown();
                    }
                    catch (Throwable throwable3) {
                        Throwable throwable4 = throwable3;
                        Option option3 = NonFatal$.MODULE$.unapply(throwable4);
                        if (option3.isEmpty()) {
                            throw throwable3;
                        }
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        boxedUnit = boxedUnit2;
                    }
                    throw e;
                }
                throw throwable;
            }
            return tuple2;
        }, this.executionContext());
    }

    public Address boundAddress() {
        return this.boundTo();
    }

    @Override
    public Future<AssociationHandle> associate(Address remoteAddress) {
        Future future;
        if (!this.serverChannel().isBound()) {
            future = Future$.MODULE$.failed((Throwable)new NettyTransportException("Transport is not bound"));
        } else {
            ClientBootstrap bootstrap = this.outboundBootstrap(remoteAddress);
            future = this.addressToSocketAddress(remoteAddress).flatMap((Function1 & Serializable & scala.Serializable)socketAddress -> NettyFutureBridge$.MODULE$.apply(bootstrap.connect((SocketAddress)socketAddress)).map((Function1 & Serializable & scala.Serializable)channel -> {
                Object object = this.settings().EnableSsl() ? package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> ((SslHandler)channel.getPipeline().get(SslHandler.class)).handshake().awaitUninterruptibly()) : BoxedUnit.UNIT;
                Object object2 = !this.akka$remote$transport$netty$NettyTransport$$isDatagram() ? channel.setReadable(false) : BoxedUnit.UNIT;
                return channel;
            }, this.executionContext()).flatMap((Function1 & Serializable & scala.Serializable)readyChannel -> (this.akka$remote$transport$netty$NettyTransport$$isDatagram() ? Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                SocketAddress socketAddress = readyChannel.getRemoteAddress();
                if (!(socketAddress instanceof InetSocketAddress)) {
                    throw new NettyTransportException(new StringBuilder(39).append("Unknown outbound remote address type [").append(socketAddress.getClass().getName()).append("]").toString());
                }
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                UdpAssociationHandle handle = new UdpAssociationHandle(this.localAddress(), remoteAddress, (Channel)readyChannel, this);
                handle.readHandlerPromise().future().foreach((Function1 & Serializable & scala.Serializable)listener -> this.udpConnectionTable().put(inetSocketAddress, (AssociationHandle.HandleEventListener)listener), this.executionContext());
                UdpAssociationHandle udpAssociationHandle = handle;
                return udpAssociationHandle;
            }, this.executionContext()) : ((ClientHandler)readyChannel.getPipeline().get(ClientHandler.class)).statusFuture()).map((Function1 & Serializable & scala.Serializable)handle -> handle, this.executionContext()), this.executionContext()), this.executionContext()).recover((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof CancellationException) {
                        throw new NettyTransportExceptionNoStack("Connection was cancelled");
                    }
                    Option option = NonFatal$.MODULE$.unapply(A1);
                    if (!option.isEmpty()) {
                        Throwable t = (Throwable)option.get();
                        String msg = t.getCause() == null ? t.getMessage() : (t.getCause().getCause() == null ? new StringBuilder(13).append(t.getMessage()).append(", caused by: ").append(t.getCause()).toString() : new StringBuilder(26).append(t.getMessage()).append(", caused by: ").append(t.getCause()).append(", caused by: ").append(t.getCause().getCause()).toString());
                        throw new NettyTransportExceptionNoStack(new StringBuilder(2).append(t.getClass().getName()).append(": ").append(msg).toString(), t.getCause());
                    }
                    Object object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Option option;
                    Throwable throwable = x1;
                    boolean bl = throwable instanceof CancellationException ? true : !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                    return bl;
                }
            }, this.executionContext());
        }
        return future;
    }

    @Override
    public Future<Object> shutdown() {
        return this.always$2(this.channelGroup().unbind()).flatMap((Function1 & Serializable & scala.Serializable)unbindStatus -> NettyTransport.$anonfun$shutdown$2(this, BoxesRunTime.unboxToBoolean((Object)unbindStatus)), this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$1(ChannelGroup x$5) {
        return true;
    }

    private final Future always$2(ChannelGroupFuture c) {
        return NettyFutureBridge$.MODULE$.apply(c).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$1(x$5)), this.executionContext()).recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)false);
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }, this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$5(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus$1, boolean closeStatus) {
        if ($this.settings().UseDispatcherForIo().isDefined()) {
            $this.clientChannelFactory().shutdown();
            $this.serverChannelFactory().shutdown();
        } else {
            $this.clientChannelFactory().releaseExternalResources();
            $this.serverChannelFactory().releaseExternalResources();
        }
        return lastWriteStatus$1 && unbindStatus$1 && disconnectStatus$1 && closeStatus;
    }

    public static final /* synthetic */ Future $anonfun$shutdown$4(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus) {
        return $this.always$2($this.channelGroup().close()).map((Function1 & Serializable & scala.Serializable)closeStatus -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$5($this, lastWriteStatus$1, unbindStatus$1, disconnectStatus, BoxesRunTime.unboxToBoolean((Object)closeStatus))), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$3(NettyTransport $this, boolean unbindStatus$1, boolean lastWriteStatus) {
        return $this.always$2($this.channelGroup().disconnect()).flatMap((Function1 & Serializable & scala.Serializable)disconnectStatus -> NettyTransport.$anonfun$shutdown$4($this, lastWriteStatus, unbindStatus$1, BoxesRunTime.unboxToBoolean((Object)disconnectStatus)), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$2(NettyTransport $this, boolean unbindStatus) {
        return $this.always$2($this.channelGroup().write((Object)ChannelBuffers.buffer((int)0))).flatMap((Function1 & Serializable & scala.Serializable)lastWriteStatus -> NettyTransport.$anonfun$shutdown$3($this, unbindStatus, BoxesRunTime.unboxToBoolean((Object)lastWriteStatus)), $this.executionContext());
    }

    public NettyTransport(NettyTransportSettings settings, ExtendedActorSystem system) {
        ServerBootstrap serverBootstrap;
        SSLEngineProvider sSLEngineProvider;
        NioDatagramChannelFactory nioDatagramChannelFactory;
        NioDatagramChannelFactory nioDatagramChannelFactory2;
        this.settings = settings;
        this.system = system;
        Transport.$init$(this);
        Dispatchers dispatchers = system.dispatchers();
        this.executionContext = (ExecutionContext)settings.UseDispatcherForIo().orElse((Function0 & Serializable & scala.Serializable)() -> {
            String string = ((RARP)RARP$.MODULE$.apply((ActorSystem)this.system())).provider().remoteSettings().Dispatcher();
            Object object = "".equals(string) ? None$.MODULE$ : new Some((Object)string);
            return object;
        }).map((Function1 & Serializable & scala.Serializable)id -> dispatchers.lookup(id)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.system().dispatcher());
        this.schemeIdentifier = new StringBuilder(0).append(settings.EnableSsl() ? "ssl." : "").append(settings.TransportMode()).toString();
        NettyTransportSettings.Mode mode = settings.TransportMode();
        NettyTransportSettings$Udp$ nettyTransportSettings$Udp$ = NettyTransportSettings$Udp$.MODULE$;
        this.akka$remote$transport$netty$NettyTransport$$isDatagram = !(mode != null ? !mode.equals(nettyTransportSettings$Udp$) : nettyTransportSettings$Udp$ != null);
        this.akka$remote$transport$netty$NettyTransport$$log = Logging$.MODULE$.withMarker((ActorSystem)system, this.getClass(), LogSource$.MODULE$.fromAnyClass());
        this.udpConnectionTable = new ConcurrentHashMap();
        this.channelGroup = new DefaultChannelGroup(new StringBuilder(41).append("akka-netty-transport-driver-channelgroup-").append(NettyTransport$.MODULE$.uniqueIdCounter().getAndIncrement()).toString());
        NettyTransportSettings.Mode mode2 = settings.TransportMode();
        if (NettyTransportSettings$Tcp$.MODULE$.equals(mode2)) {
            Executor boss = this.createExecutorService();
            Executor worker = this.createExecutorService();
            nioDatagramChannelFactory2 = new NioClientSocketChannelFactory(boss, 1, (WorkerPool)new NioWorkerPool(worker, settings.ClientSocketWorkerPoolSize()), (Timer)new HashedWheelTimer(system.threadFactory()));
        } else if (NettyTransportSettings$Udp$.MODULE$.equals(mode2)) {
            nioDatagramChannelFactory2 = new NioDatagramChannelFactory(this.createExecutorService(), settings.ClientSocketWorkerPoolSize());
        } else {
            throw new MatchError((Object)mode2);
        }
        this.clientChannelFactory = nioDatagramChannelFactory2;
        NettyTransportSettings.Mode mode3 = settings.TransportMode();
        if (NettyTransportSettings$Tcp$.MODULE$.equals(mode3)) {
            Executor boss = this.createExecutorService();
            Executor worker = this.createExecutorService();
            nioDatagramChannelFactory = new NioServerSocketChannelFactory(boss, worker, settings.ServerSocketWorkerPoolSize());
        } else if (NettyTransportSettings$Udp$.MODULE$.equals(mode3)) {
            nioDatagramChannelFactory = new NioDatagramChannelFactory(this.createExecutorService(), settings.ServerSocketWorkerPoolSize());
        } else {
            throw new MatchError((Object)mode3);
        }
        this.serverChannelFactory = nioDatagramChannelFactory;
        this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise = Promise$.MODULE$.apply();
        if (settings.EnableSsl()) {
            sSLEngineProvider = (SSLEngineProvider)OptionVal.Some$.MODULE$.apply(system.dynamicAccess().createInstanceFor(settings.SSLEngineProviderClassName(), (Seq)new .colon.colon((Object)new Tuple2(ActorSystem.class, (Object)system), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(SSLEngineProvider.class)).recover((PartialFunction)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyTransport $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    throw new ConfigurationException(new StringBuilder(37).append("Could not create SSLEngineProvider [").append(this.$outer.settings().SSLEngineProviderClassName()).append("]").toString(), A1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = true;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).get());
        } else {
            OptionVal$.MODULE$.None();
            sSLEngineProvider = null;
        }
        this.sslEngineProvider = sSLEngineProvider;
        this.serverPipelineFactory = new ChannelPipelineFactory(this){
            private final /* synthetic */ NettyTransport $outer;

            /*
             * WARNING - void declaration
             */
            public ChannelPipeline getPipeline() {
                void var1_1;
                DefaultChannelPipeline pipeline = this.$outer.akka$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", (ChannelHandler)this.$outer.akka$remote$transport$netty$NettyTransport$$sslHandler(false));
                }
                ServerHandler handler = this.$outer.akka$remote$transport$netty$NettyTransport$$isDatagram() ? new UdpServerHandler(this.$outer, (Future<Transport.AssociationEventListener>)this.$outer.akka$remote$transport$netty$NettyTransport$$associationListenerPromise().future()) : new TcpServerHandler(this.$outer, (Future<Transport.AssociationEventListener>)this.$outer.akka$remote$transport$netty$NettyTransport$$associationListenerPromise().future(), (LoggingAdapter)this.$outer.akka$remote$transport$netty$NettyTransport$$log());
                pipeline.addLast("ServerHandler", (ChannelHandler)handler);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        NettyTransportSettings.Mode mode4 = settings.TransportMode();
        if (NettyTransportSettings$Tcp$.MODULE$.equals(mode4)) {
            serverBootstrap = this.setupBootstrap(new ServerBootstrap(this.serverChannelFactory()), this.serverPipelineFactory());
        } else if (NettyTransportSettings$Udp$.MODULE$.equals(mode4)) {
            serverBootstrap = this.setupBootstrap(new ConnectionlessBootstrap(this.serverChannelFactory()), this.serverPipelineFactory());
        } else {
            throw new MatchError((Object)mode4);
        }
        this.inboundBootstrap = serverBootstrap;
    }

    public NettyTransport(ExtendedActorSystem system, Config conf) {
        this(new NettyTransportSettings(conf), system);
    }
}

