/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.sharding;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.PoisonPill$;
import akka.actor.Props;
import akka.actor.Props$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.sharding.ClusterSharding$;
import akka.cluster.sharding.ClusterShardingGuardian;
import akka.cluster.sharding.ClusterShardingSettings;
import akka.cluster.sharding.ClusterShardingSettings$;
import akka.cluster.sharding.ShardCoordinator;
import akka.cluster.sharding.ShardRegion;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Timeout;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t}s!\u0002\u0013&\u0011\u0003ac!\u0002\u0018&\u0011\u0003y\u0003BB#\u0002\t\u0003\u0011)\u0005C\u0004\u0003H\u0005!\tE!\u0013\t\u000f\tM\u0013\u0001\"\u0011\u0003V!9!\u0011L\u0001\u0005B\tmc\u0001\u0002\u0018&\u0001uB\u0001\"\u0011\u0004\u0003\u0002\u0003\u0006IA\u0011\u0005\u0006\u000b\u001a!\tA\u0012\u0005\b\u0011\u001a\u0011\r\u0011\"\u0003J\u0011\u0019\u0001f\u0001)A\u0005\u0015\"9\u0001F\u0002b\u0001\n\u0013\t\u0006B\u0002,\u0007A\u0003%!\u000bC\u0004X\r\t\u0007I\u0011\u0002-\t\rE4\u0001\u0015!\u0003Z\u0011\u001d\u0011hA1A\u0005\naCaa\u001d\u0004!\u0002\u0013I\u0006\u0002\u0003;\u0007\u0011\u000b\u0007I\u0011B;\t\u000bY4A\u0011A<\t\rY4A\u0011AA!\u0011!\tyE\u0002C\u0001S\u0005E\u0003B\u0002<\u0007\t\u0003\t)\b\u0003\u0004w\r\u0011\u0005\u0011\u0011\u0011\u0005\u0007m\u001a!\t!a#\t\rY4A\u0011AAQ\u0011\u00191h\u0001\"\u0001\u0002,\"9\u00111\u0017\u0004\u0005\u0002\u0005U\u0006bBAZ\r\u0011\u0005\u0011q\u0019\u0005\b\u0003[4A\u0011BAx\u0011\u001d\t\u0019L\u0002C\u0001\u0003kDq!a-\u0007\t\u0003\u0011)\u0001C\u0004\u0003\u0010\u0019!\tA!\u0005\t\u000f\t\rb\u0001\"\u0001\u0003&!9!1\u0006\u0004\u0005\u0002\t5\u0002b\u0002B\u0019\r\u0011\u0005!1\u0007\u0005\b\u0005s1A\u0011\u0001B\u001e\u0003=\u0019E.^:uKJ\u001c\u0006.\u0019:eS:<'B\u0001\u0014(\u0003!\u0019\b.\u0019:eS:<'B\u0001\u0015*\u0003\u001d\u0019G.^:uKJT\u0011AK\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u00055\nQ\"A\u0013\u0003\u001f\rcWo\u001d;feNC\u0017M\u001d3j]\u001e\u001cR!\u0001\u00197\u0005\u007f\u0001\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a!\u00118z%\u00164\u0007cA\u001c;y5\t\u0001H\u0003\u0002:S\u0005)\u0011m\u0019;pe&\u00111\b\u000f\u0002\f\u000bb$XM\\:j_:LE\r\u0005\u0002.\rM\u0019a\u0001\r \u0011\u0005]z\u0014B\u0001!9\u0005%)\u0005\u0010^3og&|g.\u0001\u0004tsN$X-\u001c\t\u0003o\rK!\u0001\u0012\u001d\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0002\rqJg.\u001b;?)\tat\tC\u0003B\u0011\u0001\u0007!)A\u0002m_\u001e,\u0012A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b&\nQ!\u001a<f]RL!a\u0014'\u0003\u001d1{wmZ5oO\u0006#\u0017\r\u001d;fe\u0006!An\\4!+\u0005\u0011\u0006CA*U\u001b\u00059\u0013BA+(\u0005\u001d\u0019E.^:uKJ\f\u0001b\u00197vgR,'\u000fI\u0001\be\u0016<\u0017n\u001c8t+\u0005I\u0006\u0003\u0002.bG:l\u0011a\u0017\u0006\u00039v\u000b!bY8oGV\u0014(/\u001a8u\u0015\tqv,\u0001\u0003vi&d'\"\u00011\u0002\t)\fg/Y\u0005\u0003En\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\t!7N\u0004\u0002fSB\u0011aMM\u0007\u0002O*\u0011\u0001nK\u0001\u0007yI|w\u000e\u001e \n\u0005)\u0014\u0014A\u0002)sK\u0012,g-\u0003\u0002m[\n11\u000b\u001e:j]\u001eT!A\u001b\u001a\u0011\u0005]z\u0017B\u000199\u0005!\t5\r^8s%\u00164\u0017\u0001\u0003:fO&|gn\u001d\u0011\u0002\u000fA\u0014x\u000e_5fg\u0006A\u0001O]8yS\u0016\u001c\b%\u0001\u0005hk\u0006\u0014H-[1o+\u0005q\u0017!B:uCJ$H\u0003\u00048yu~\fI!a\u0007\u0002&\u0005]\u0002\"B=\u0013\u0001\u0004\u0019\u0017\u0001\u0003;za\u0016t\u0015-\\3\t\u000bm\u0014\u0002\u0019\u0001?\u0002\u0017\u0015tG/\u001b;z!J|\u0007o\u001d\t\u0003ouL!A \u001d\u0003\u000bA\u0013x\u000e]:\t\u000f\u0005\u0005!\u00031\u0001\u0002\u0004\u0005A1/\u001a;uS:<7\u000fE\u0002.\u0003\u000bI1!a\u0002&\u0005]\u0019E.^:uKJ\u001c\u0006.\u0019:eS:<7+\u001a;uS:<7\u000fC\u0004\u0002\fI\u0001\r!!\u0004\u0002\u001f\u0015DHO]1di\u0016sG/\u001b;z\u0013\u0012\u0004B!a\u0004\u0002\u00169\u0019Q&!\u0005\n\u0007\u0005MQ%A\u0006TQ\u0006\u0014HMU3hS>t\u0017\u0002BA\f\u00033\u0011q\"\u0012=ue\u0006\u001cG/\u00128uSRL\u0018\n\u001a\u0006\u0004\u0003')\u0003bBA\u000f%\u0001\u0007\u0011qD\u0001\u000fKb$(/Y2u'\"\f'\u000fZ%e!\u0011\ty!!\t\n\t\u0005\r\u0012\u0011\u0004\u0002\u000f\u000bb$(/Y2u'\"\f'\u000fZ%e\u0011\u001d\t9C\u0005a\u0001\u0003S\t!#\u00197m_\u000e\fG/[8o'R\u0014\u0018\r^3hsB!\u00111FA\u0019\u001d\ri\u0013QF\u0005\u0004\u0003_)\u0013\u0001E*iCJ$7i\\8sI&t\u0017\r^8s\u0013\u0011\t\u0019$!\u000e\u0003/MC\u0017M\u001d3BY2|7-\u0019;j_:\u001cFO]1uK\u001eL(bAA\u0018K!9\u0011\u0011\b\nA\u0002\u0005m\u0012A\u00055b]\u0012|eMZ*u_BlUm]:bO\u0016\u00042!MA\u001f\u0013\r\tyD\r\u0002\u0004\u0003:LH#\u00048\u0002D\u0005\u0015\u0013qIA%\u0003\u0017\ni\u0005C\u0003z'\u0001\u00071\rC\u0003|'\u0001\u0007A\u0010C\u0004\u0002\fM\u0001\r!!\u0004\t\u000f\u0005u1\u00031\u0001\u0002 !9\u0011qE\nA\u0002\u0005%\u0002bBA\u001d'\u0001\u0007\u00111H\u0001\u000eS:$XM\u001d8bYN#\u0018M\u001d;\u0015\u001f9\f\u0019&!\u0016\u0002^\u0005}\u0013\u0011MA2\u0003KBQ!\u001f\u000bA\u0002\rDaa\u001f\u000bA\u0002\u0005]\u0003#B\u0019\u0002Z\rd\u0018bAA.e\tIa)\u001e8di&|g.\r\u0005\b\u0003\u0003!\u0002\u0019AA\u0002\u0011\u001d\tY\u0001\u0006a\u0001\u0003\u001bAq!!\b\u0015\u0001\u0004\ty\u0002C\u0004\u0002(Q\u0001\r!!\u000b\t\u000f\u0005eB\u00031\u0001\u0002<!\u001aA#!\u001b\u0011\t\u0005-\u0014\u0011O\u0007\u0003\u0003[R1!a\u001c*\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\niGA\u0006J]R,'O\\1m\u0003BLGc\u00038\u0002x\u0005e\u00141PA?\u0003\u007fBQ!_\u000bA\u0002\rDQa_\u000bA\u0002qDq!!\u0001\u0016\u0001\u0004\t\u0019\u0001C\u0004\u0002\fU\u0001\r!!\u0004\t\u000f\u0005uQ\u00031\u0001\u0002 QIa.a!\u0002\u0006\u0006\u001d\u0015\u0011\u0012\u0005\u0006sZ\u0001\ra\u0019\u0005\u0006wZ\u0001\r\u0001 \u0005\b\u0003\u00171\u0002\u0019AA\u0007\u0011\u001d\tiB\u0006a\u0001\u0003?!RB\\AG\u0003\u001f\u000b\t*a%\u0002\u001e\u0006}\u0005\"B=\u0018\u0001\u0004\u0019\u0007\"B>\u0018\u0001\u0004a\bbBA\u0001/\u0001\u0007\u00111\u0001\u0005\b\u0003+;\u0002\u0019AAL\u0003AiWm]:bO\u0016,\u0005\u0010\u001e:bGR|'\u000f\u0005\u0003\u0002\u0010\u0005e\u0015\u0002BAN\u00033\u0011\u0001#T3tg\u0006<W-\u0012=ue\u0006\u001cGo\u001c:\t\u000f\u0005\u001dr\u00031\u0001\u0002*!9\u0011\u0011H\fA\u0002\u0005mB#\u00038\u0002$\u0006\u0015\u0016qUAU\u0011\u0015I\b\u00041\u0001d\u0011\u0015Y\b\u00041\u0001}\u0011\u001d\t\t\u0001\u0007a\u0001\u0003\u0007Aq!!&\u0019\u0001\u0004\t9\nF\u0004o\u0003[\u000by+!-\t\u000beL\u0002\u0019A2\t\u000bmL\u0002\u0019\u0001?\t\u000f\u0005U\u0015\u00041\u0001\u0002\u0018\u0006Q1\u000f^1siB\u0013x\u000e_=\u0015\u00139\f9,!/\u0002D\u0006\u0015\u0007\"B=\u001b\u0001\u0004\u0019\u0007bBA^5\u0001\u0007\u0011QX\u0001\u0005e>dW\r\u0005\u00032\u0003\u007f\u001b\u0017bAAae\t1q\n\u001d;j_:Dq!a\u0003\u001b\u0001\u0004\ti\u0001C\u0004\u0002\u001ei\u0001\r!a\b\u0015\u00179\fI-a3\u0002N\u0006%\u00181\u001e\u0005\u0006sn\u0001\ra\u0019\u0005\b\u0003w[\u0002\u0019AA_\u0011\u001d\tym\u0007a\u0001\u0003#\f!\u0002Z1uC\u000e+g\u000e^3s!\u0015\t\u0014qXAj!\u0011\t).a9\u000f\t\u0005]\u0017q\u001c\b\u0005\u00033\fiND\u0002g\u00037L\u0011AK\u0005\u0003Q%J1!!9(\u0003=\u0019E.^:uKJ\u001cV\r\u001e;j]\u001e\u001c\u0018\u0002BAs\u0003O\u0014!\u0002R1uC\u000e+g\u000e^3s\u0015\r\t\to\n\u0005\b\u0003\u0017Y\u0002\u0019AA\u0007\u0011\u001d\tib\u0007a\u0001\u0003?\t\u0011\u0002\u001d:pqft\u0015-\\3\u0015\u000b\r\f\t0a=\t\u000bed\u0002\u0019A2\t\u000f\u0005=G\u00041\u0001\u0002RR9a.a>\u0002z\n\r\u0001\"B=\u001e\u0001\u0004\u0019\u0007bBA^;\u0001\u0007\u00111 \t\u0006\u0003{\fypY\u0007\u0002;&\u0019!\u0011A/\u0003\u0011=\u0003H/[8oC2Dq!!&\u001e\u0001\u0004\t9\nF\u0005o\u0005\u000f\u0011IAa\u0003\u0003\u000e!)\u0011P\ba\u0001G\"9\u00111\u0018\u0010A\u0002\u0005m\bbBAh=\u0001\u0007\u00111 \u0005\b\u0003+s\u0002\u0019AAL\u00039\u0019\b.\u0019:e)f\u0004XMT1nKN,\"Aa\u0005\u0011\u000b\tU!qD2\u000e\u0005\t]!\u0002\u0002B\r\u00057\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\tu!'\u0001\u0006d_2dWm\u0019;j_:LAA!\t\u0003\u0018\t\u00191+\u001a;\u0002#\u001d,Go\u00155be\u0012$\u0016\u0010]3OC6,7/\u0006\u0002\u0003(A)\u0011Q B\u0015G&\u0019!\u0011E/\u0002\u0017MD\u0017M\u001d3SK\u001eLwN\u001c\u000b\u0004]\n=\u0002\"B=\"\u0001\u0004\u0019\u0017\u0001E:iCJ$'+Z4j_:\u0004&o\u001c=z)\u0015q'Q\u0007B\u001c\u0011\u0015I(\u00051\u0001d\u0011\u001d\tyM\ta\u0001\u0003'\fa\u0004Z3gCVdGo\u00155be\u0012\fE\u000e\\8dCRLwN\\*ue\u0006$XmZ=\u0015\t\u0005%\"Q\b\u0005\b\u0003\u0003\u0019\u0003\u0019AA\u0002!\r9$\u0011I\u0005\u0004\u0005\u0007B$aE#yi\u0016t7/[8o\u0013\u0012\u0004&o\u001c<jI\u0016\u0014H#\u0001\u0017\u0002\u0007\u001d,G\u000fF\u0002=\u0005\u0017Ba!Q\u0002A\u0002\t5\u0003cA\u001c\u0003P%\u0019!\u0011\u000b\u001d\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\u0007Y>|7.\u001e9\u0015\u0005\t]cBA\u0017\u0001\u0003=\u0019'/Z1uK\u0016CH/\u001a8tS>tGc\u0001\u001f\u0003^!)\u0011)\u0002a\u0001\u0005\u0002")
public class ClusterSharding
implements Extension {
    private ActorRef guardian;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final Cluster cluster;
    private final ConcurrentHashMap<String, ActorRef> regions;
    private final ConcurrentHashMap<String, ActorRef> proxies;
    private volatile boolean bitmap$0;

    public static ClusterSharding createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterSharding$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterSharding$ lookup() {
        return ClusterSharding$.MODULE$.lookup();
    }

    public static ClusterSharding get(ActorSystem actorSystem) {
        return ClusterSharding$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterSharding$.MODULE$.apply(actorSystem);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private Cluster cluster() {
        return this.cluster;
    }

    private ConcurrentHashMap<String, ActorRef> regions() {
        return this.regions;
    }

    private ConcurrentHashMap<String, ActorRef> proxies() {
        return this.proxies;
    }

    private ActorRef guardian$lzycompute() {
        ClusterSharding clusterSharding = this;
        synchronized (clusterSharding) {
            if (!this.bitmap$0) {
                String guardianName = this.system.settings().config().getString("akka.cluster.sharding.guardian-name");
                String string = this.system.settings().config().getString("akka.cluster.sharding.use-dispatcher");
                String string2 = "".equals(string) ? "akka.actor.default-dispatcher" : string;
                String dispatcher = string2;
                this.guardian = this.system.systemActorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(ClusterShardingGuardian.class)).withDispatcher(dispatcher), guardianName);
                this.bitmap$0 = true;
            }
        }
        return this.guardian;
    }

    private ActorRef guardian() {
        return !this.bitmap$0 ? this.guardian$lzycompute() : this.guardian;
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.internalStart(typeName, (Function1<String, Props>)(Function1 & Serializable & scala.Serializable)x$1 -> entityProps, settings, extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
    }

    public ActorRef start(String typeName, Props entityProps, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
    }

    @InternalApi
    public ActorRef internalStart(String typeName, Function1<String, Props> entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        ActorRef actorRef;
        if (settings.shouldHostShard(this.cluster())) {
            ActorRef actorRef2;
            ActorRef actorRef3 = this.regions().get(typeName);
            if (actorRef3 == null) {
                ActorRef shardRegion;
                ActorRef x$3;
                Timeout x$2;
                ClusterShardingGuardian.Start x$1;
                Timeout timeout = this.system.settings().CreationTimeout();
                ClusterShardingGuardian.Start startMsg = new ClusterShardingGuardian.Start(typeName, entityProps, settings, extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
                ActorRef qual$1 = package$.MODULE$.ask(this.guardian());
                Object object = Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)(x$1 = startMsg), x$2 = timeout, x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)), (Duration)timeout.duration());
                if (!(object instanceof ClusterShardingGuardian.Started)) {
                    throw new MatchError(object);
                }
                ClusterShardingGuardian.Started started = (ClusterShardingGuardian.Started)object;
                ActorRef actorRef4 = shardRegion = started.shardRegion();
                ActorRef shardRegion2 = actorRef4;
                this.regions().put(typeName, shardRegion2);
                actorRef2 = shardRegion2;
            } else {
                actorRef2 = actorRef3;
            }
            actorRef = actorRef2;
        } else {
            this.log().debug("Starting Shard Region Proxy [{}] (no actors will be hosted on this node)...", (Object)typeName);
            actorRef = this.startProxy(typeName, settings.role(), (Option<String>)None$.MODULE$, extractEntityId, extractShardId);
        }
        return actorRef;
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        ShardCoordinator.ShardAllocationStrategy allocationStrategy = this.defaultShardAllocationStrategy(settings);
        return this.start(typeName, entityProps, settings, extractEntityId, extractShardId, allocationStrategy, PoisonPill$.MODULE$);
    }

    public ActorRef start(String typeName, Props entityProps, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), extractEntityId, extractShardId);
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, ShardRegion.MessageExtractor messageExtractor, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.internalStart(typeName, (Function1<String, Props>)(Function1 & Serializable & scala.Serializable)x$2 -> entityProps, settings, (PartialFunction<Object, Tuple2<String, Object>>)new scala.Serializable(null, messageExtractor){
            public static final long serialVersionUID = 0L;
            private final ShardRegion.MessageExtractor messageExtractor$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.messageExtractor$1.entityId(A1) != null ? new Tuple2((Object)this.messageExtractor$1.entityId(A1), this.messageExtractor$1.entityMessage(A1)) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = this.messageExtractor$1.entityId(object) != null;
                return bl;
            }
            {
                this.messageExtractor$1 = messageExtractor$1;
            }
        }, (Function1<Object, String>)(Function1 & Serializable & scala.Serializable)msg -> messageExtractor.shardId(msg), allocationStrategy, handOffStopMessage);
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, ShardRegion.MessageExtractor messageExtractor) {
        ShardCoordinator.ShardAllocationStrategy allocationStrategy = this.defaultShardAllocationStrategy(settings);
        return this.start(typeName, entityProps, settings, messageExtractor, allocationStrategy, (Object)PoisonPill$.MODULE$);
    }

    public ActorRef start(String typeName, Props entityProps, ShardRegion.MessageExtractor messageExtractor) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), messageExtractor);
    }

    public ActorRef startProxy(String typeName, Option<String> role, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        return this.startProxy(typeName, role, (Option<String>)None$.MODULE$, extractEntityId, extractShardId);
    }

    public ActorRef startProxy(String typeName, Option<String> role, Option<String> dataCenter, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        ActorRef actorRef;
        ActorRef actorRef2 = this.proxies().get(this.proxyName(typeName, dataCenter));
        if (actorRef2 == null) {
            ActorRef shardRegion;
            ActorRef x$3;
            Timeout x$2;
            ClusterShardingGuardian.StartProxy x$1;
            Timeout timeout = this.system.settings().CreationTimeout();
            ClusterShardingSettings settings = ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system).withRole(role);
            ClusterShardingGuardian.StartProxy startMsg = new ClusterShardingGuardian.StartProxy(typeName, dataCenter, settings, extractEntityId, extractShardId);
            ActorRef qual$1 = package$.MODULE$.ask(this.guardian());
            Object object = Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)(x$1 = startMsg), x$2 = timeout, x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)), (Duration)timeout.duration());
            if (!(object instanceof ClusterShardingGuardian.Started)) {
                throw new MatchError(object);
            }
            ClusterShardingGuardian.Started started = (ClusterShardingGuardian.Started)object;
            ActorRef actorRef3 = shardRegion = started.shardRegion();
            ActorRef shardRegion2 = actorRef3;
            this.proxies().put(this.proxyName(typeName, dataCenter), shardRegion2);
            actorRef = shardRegion2;
        } else {
            actorRef = actorRef2;
        }
        return actorRef;
    }

    private String proxyName(String typeName, Option<String> dataCenter) {
        String string;
        Option<String> option = dataCenter;
        if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(5).append(typeName).append("Proxy").toString();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String t = (String)some.value();
            string = new StringBuilder(6).append(typeName).append("Proxy").append("-").append(t).toString();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public ActorRef startProxy(String typeName, Optional<String> role, ShardRegion.MessageExtractor messageExtractor) {
        return this.startProxy(typeName, role, Optional.empty(), messageExtractor);
    }

    public ActorRef startProxy(String typeName, Optional<String> role, Optional<String> dataCenter, ShardRegion.MessageExtractor messageExtractor) {
        return this.startProxy(typeName, (Option<String>)Option$.MODULE$.apply(role.orElse(null)), (Option<String>)Option$.MODULE$.apply(dataCenter.orElse(null)), (PartialFunction<Object, Tuple2<String, Object>>)new scala.Serializable(null, messageExtractor){
            public static final long serialVersionUID = 0L;
            private final ShardRegion.MessageExtractor messageExtractor$2;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.messageExtractor$2.entityId(A1) != null ? new Tuple2((Object)this.messageExtractor$2.entityId(A1), this.messageExtractor$2.entityMessage(A1)) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = this.messageExtractor$2.entityId(object) != null;
                return bl;
            }
            {
                this.messageExtractor$2 = messageExtractor$2;
            }
        }, (Function1<Object, String>)(Function1 & Serializable & scala.Serializable)msg -> messageExtractor.shardId(msg));
    }

    public scala.collection.immutable.Set<String> shardTypeNames() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.regions().keySet()).asScala()).toSet();
    }

    public Set<String> getShardTypeNames() {
        return this.regions().keySet();
    }

    public ActorRef shardRegion(String typeName) {
        ActorRef actorRef;
        ActorRef actorRef2 = this.regions().get(typeName);
        if (actorRef2 == null) {
            ActorRef actorRef3;
            ActorRef actorRef4 = this.proxies().get(this.proxyName(typeName, (Option<String>)None$.MODULE$));
            if (actorRef4 == null) {
                throw new IllegalArgumentException(new StringBuilder(35).append("Shard type [").append(typeName).append("] must be started first").toString());
            }
            actorRef = actorRef3 = actorRef4;
        } else {
            actorRef = actorRef2;
        }
        return actorRef;
    }

    public ActorRef shardRegionProxy(String typeName, String dataCenter) {
        ActorRef actorRef = this.proxies().get(this.proxyName(typeName, (Option<String>)new Some((Object)dataCenter)));
        if (actorRef == null) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Shard type [").append(typeName).append("] must be started first").toString());
        }
        ActorRef actorRef2 = actorRef;
        return actorRef2;
    }

    public ShardCoordinator.ShardAllocationStrategy defaultShardAllocationStrategy(ClusterShardingSettings settings) {
        int threshold = settings.tuningParameters().leastShardAllocationRebalanceThreshold();
        int maxSimultaneousRebalance = settings.tuningParameters().leastShardAllocationMaxSimultaneousRebalance();
        return new ShardCoordinator.LeastShardAllocationStrategy(threshold, maxSimultaneousRebalance);
    }

    public ClusterSharding(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, this.getClass(), LogSource$.MODULE$.fromAnyClass());
        this.cluster = (Cluster)Cluster$.MODULE$.apply((ActorSystem)system);
        this.regions = new ConcurrentHashMap();
        this.proxies = new ConcurrentHashMap();
    }
}

