/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.XLReleaseOperations$;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.PhaseRestart;
import com.xebialabs.xlrelease.service.PhaseRestart$;
import com.xebialabs.xlrelease.service.RestartPhasesException;
import com.xebialabs.xlrelease.service.TaskBackup;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenSeqLike;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Profile(value={"sql"})
@Component
@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u000b\u0017\u0001}A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!1\u0005A!A!\u0002\u00139\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u00119\u0003!\u0011!Q\u0001\n=C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t3\u0002\u0011\t\u0011)A\u00055\"AQ\f\u0001B\u0001B\u0003-a\fC\u0003e\u0001\u0011\u0005Q\rC\u0004\u0002\u0004\u0001!\t%!\u0002\t\u0013\u0005%\u0003!%A\u0005\u0002\u0005-\u0003\"CA0\u0001E\u0005I\u0011AA1\u0011\u001d\t)\u0007\u0001C!\u0003OBq!a!\u0001\t\u0013\t)\tC\u0004\u0002\f\u0002!I!!$\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002(\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAk\u0001\u0011%\u0011q\u001b\u0002\u0010'Fd\u0007\u000b[1tKJ+7\u000f^1si*\u0011q\u0003G\u0001\bg\u0016\u0014h/[2f\u0015\tI\"$A\u0005yYJ,G.Z1tK*\u00111\u0004H\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!H\u0001\u0004G>l7\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Q5\ta#\u0003\u0002*-\ta\u0001\u000b[1tKJ+7\u000f^1si\u0006I1o\u00195fIVdWM\u001d\t\u0003YIj\u0011!\f\u0006\u0003U9R!a\f\u0019\u0002\u0011AdW/\u001c2j]\u001eT!!\r\u000e\u0002\u0011\u0011,\u0007\u000f\\8zSRL!aM\u0017\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018A\u0003;bg.\u0014\u0015mY6vaB\u0011qEN\u0005\u0003oY\u0011!\u0002V1tW\n\u000b7m[;q\u0003-\u0001XM]7jgNLwN\\:\u0011\u0005ijT\"A\u001e\u000b\u0005qB\u0012\u0001C:fGV\u0014\u0018\u000e^=\n\u0005yZ$!\u0005)fe6L7o]5p]\u000eCWmY6fe\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rC\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011QI\u0011\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"a\n%\n\u0005%3\"aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\f\u0011\u0003Z3qK:$WM\\2z'\u0016\u0014h/[2f!\t9C*\u0003\u0002N-\t\tB)\u001a9f]\u0012,gnY=TKJ4\u0018nY3\u0002\u001dQ\f7o\u001b*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\tU\u0005\u0003#\n\u0013a\u0002V1tWJ+\u0007o\\:ji>\u0014\u00180A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW\r\u0005\u0002U/6\tQK\u0003\u0002W1\u00051\u0011m\u0019;peNL!\u0001W+\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002\u001f\u0019\f7-\u001a;SKB|7/\u001b;pef\u0004\"!Q.\n\u0005q\u0013%a\u0004$bG\u0016$(+\u001a9pg&$xN]=\u0002\u0011\u00154XM\u001c;CkN\u0004\"a\u00182\u000e\u0003\u0001T!!\u0019\r\u0002\r\u00154XM\u001c;t\u0013\t\u0019\u0007MA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkN\fa\u0001P5oSRtDC\u00034jU.dWN\\8qcR\u0011q\r\u001b\t\u0003O\u0001AQ!X\u0006A\u0004yCQAK\u0006A\u0002-BQ\u0001N\u0006A\u0002UBQ\u0001O\u0006A\u0002eBQaP\u0006A\u0002\u0001CQAR\u0006A\u0002\u001dCQAS\u0006A\u0002-CQAT\u0006A\u0002=CQAU\u0006A\u0002MCQ!W\u0006A\u0002iC#aC:\u0011\u0005Q|X\"A;\u000b\u0005Y<\u0018AC1o]>$\u0018\r^5p]*\u0011\u00010_\u0001\bM\u0006\u001cGo\u001c:z\u0015\tQ80A\u0003cK\u0006t7O\u0003\u0002}{\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001\u007f\u0003\ry'oZ\u0005\u0004\u0003\u0003)(!C!vi><\u0018N]3e\u00035\u0011Xm\u001d;beR\u0004\u0006.Y:fgRa\u0011qAA\n\u0003[\t\t$!\u000e\u0002@A!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000ea\ta\u0001Z8nC&t\u0017\u0002BA\t\u0003\u0017\u0011qAU3mK\u0006\u001cX\rC\u0004\u0002\u00161\u0001\r!a\u0006\u0002\u0013I,G.Z1tK&#\u0007\u0003BA\r\u0003OqA!a\u0007\u0002$A\u0019\u0011Q\u0004\u0012\u000e\u0005\u0005}!bAA\u0011=\u00051AH]8pizJ1!!\n#\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011FA\u0016\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0005\u0012\t\u000f\u0005=B\u00021\u0001\u0002\u0018\u00059\u0001\u000f[1tK&#\u0007bBA\u001a\u0019\u0001\u0007\u0011qC\u0001\u0007i\u0006\u001c8.\u00133\t\u0013\u0005]B\u0002%AA\u0002\u0005e\u0012\u0001\u00049iCN,g+\u001a:tS>t\u0007cA!\u0002<%\u0019\u0011Q\b\"\u0003\u0019AC\u0017m]3WKJ\u001c\u0018n\u001c8\t\u0013\u0005\u0005C\u0002%AA\u0002\u0005\r\u0013!\u0004:fgVlWMU3mK\u0006\u001cX\rE\u0002\"\u0003\u000bJ1!a\u0012#\u0005\u001d\u0011un\u001c7fC:\fqC]3ti\u0006\u0014H\u000f\u00155bg\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u00055#\u0006BA\u001d\u0003\u001fZ#!!\u0015\u0011\t\u0005M\u00131L\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003m\nJA!!\u0018\u0002V\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002/I,7\u000f^1siBC\u0017m]3tI\u0011,g-Y;mi\u0012*TCAA2U\u0011\t\u0019%a\u0014\u0002\u001bI,7\u000f^8sKBC\u0017m]3t)\u0011\tI'a \u0011\r\u0005-\u0014QOA=\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014\u0001B;uS2T!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003o\niG\u0001\u0003MSN$\b\u0003BA\u0005\u0003wJA!! \u0002\f\t)\u0001\u000b[1tK\"9\u0011\u0011Q\bA\u0002\u0005%\u0014a\u00049iCN,7\u000fV8SKN$xN]3\u0002\u0019I,7\u000f^8sKBC\u0017m]3\u0015\t\u0005e\u0014q\u0011\u0005\b\u0003\u0013\u0003\u0002\u0019AA=\u0003\u0015\u0001\b.Y:f\u00031\u0011Xm\u001d;pe\u0016$\u0016m]6t)\u0019\ty)!&\u0002\"B\u0019\u0011%!%\n\u0007\u0005M%E\u0001\u0003V]&$\bbBAL#\u0001\u0007\u0011\u0011T\u0001\u000e_JLw-\u001b8bYR\u000b7o[:\u0011\r\u0005-\u0014QOAN!\u0011\tI!!(\n\t\u0005}\u00151\u0002\u0002\u0005)\u0006\u001c8\u000eC\u0004\u0002$F\u0001\r!!'\u0002\u00119,w\u000fV1tWN\fA$\u001e9eCR,w)\u0019;fgJ+g-\u001a:f]\u000eLgn\u001a)iCN,7\u000f\u0006\u0004\u0002\u0010\u0006%\u0016Q\u0018\u0005\b\u0003\u0003\u0013\u0002\u0019AAV!\u0019\ti+a.\u0002z9!\u0011qVAZ\u001d\u0011\ti\"!-\n\u0003\rJ1!!.#\u0003\u001d\u0001\u0018mY6bO\u0016LA!!/\u0002<\n\u00191+Z9\u000b\u0007\u0005U&\u0005C\u0004\u0002@J\u0001\r!a+\u0002\u001dI,7\u000f^8sK\u0012\u0004\u0006.Y:fg\u0006y1o[5q)\u0006\u001c8n\u001d\"fM>\u0014X\r\u0006\u0005\u0002F\u0006-\u0017QZAi!\u0011\tI!a2\n\t\u0005%\u00171\u0002\u0002\b\u0007\"\fgnZ3t\u0011\u001d\t\u0019d\u0005a\u0001\u0003/Aq!a4\u0014\u0001\u0004\tI(A\u0007pe&<\u0017N\\1m!\"\f7/\u001a\u0005\b\u0003'\u001c\u0002\u0019AA=\u00035\u0011Xm\u001d;pe\u0016$\u0007\u000b[1tK\u0006q\u0001/\u001a:tSN$(+\u001a7fCN,GCCAH\u00033\fi.!9\u0002f\"9\u00111\u001c\u000bA\u0002\u0005\u001d\u0011\u0001C8sS\u001eLg.\u00197\t\u000f\u0005}G\u00031\u0001\u0002\b\u00059!/\u001a7fCN,\u0007bBAr)\u0001\u0007\u0011QY\u0001\bG\"\fgnZ3t\u0011\u001d\ty\f\u0006a\u0001\u0003SB3\u0001AAu!\u0011\tY/!=\u000e\u0005\u00055(bAAxw\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005M\u0018Q\u001e\u0002\n\u0007>l\u0007o\u001c8f]RDs\u0001AA|\u0005\u000b\u00119\u0001\u0005\u0003\u0002z\n\u0005QBAA~\u0015\r1\u0018Q \u0006\u0004\u0003\u007f\\\u0018aB2p]R,\u0007\u0010^\u0005\u0005\u0005\u0007\tYPA\u0004Qe>4\u0017\u000e\\3\u0002\u000bY\fG.^3-\u0005\t%\u0011E\u0001B\u0006\u0003\r\u0019\u0018\u000f\u001c")
public class SqlPhaseRestart
implements PhaseRestart {
    private final Scheduler scheduler;
    private final TaskBackup taskBackup;
    private final PermissionChecker permissions;
    private final ReleaseRepository releaseRepository;
    private final CiIdService ciIdService;
    private final DependencyService dependencyService;
    private final TaskRepository taskRepository;
    private final ReleaseActorService releaseActorService;
    private final FacetRepository facetRepository;
    private final XLReleaseEventBus eventBus;

    @Timed
    public Release restartPhases(String releaseId, String phaseId, String taskId, PhaseVersion phaseVersion) {
        return PhaseRestart.restartPhases$((PhaseRestart)this, (String)releaseId, (String)phaseId, (String)taskId, (PhaseVersion)phaseVersion);
    }

    public void checkCanRestartPhases(Release release, String phaseId, String taskId, PhaseVersion phaseVersion, boolean resumeRelease) {
        PhaseRestart.checkCanRestartPhases$((PhaseRestart)this, (Release)release, (String)phaseId, (String)taskId, (PhaseVersion)phaseVersion, (boolean)resumeRelease);
    }

    public Release restartPhases(String releaseId, String phaseId, String taskId, PhaseVersion phaseVersion, boolean resumeRelease) {
        Release release = this.releaseRepository.findById(releaseId);
        Release original = (Release)CiCloneHelper.cloneCi((ConfigurationItem)release);
        this.checkCanRestartPhases(release, phaseId, taskId, phaseVersion, resumeRelease);
        Seq phasesToRestore = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(PhaseRestart$.MODULE$.getPhasesToRestore(release, phaseId, phaseVersion)).asScala();
        if (phasesToRestore.isEmpty()) {
            throw new RestartPhasesException(releaseId, phaseId, taskId, phaseVersion, resumeRelease, new StringBuilder(37).append("There are no ").append(phaseVersion).append(" phases to restart from ").append(phaseId).toString());
        }
        PhaseRestart$.MODULE$.checkIfPhaseCanBeRestartedFrom(release.getTask(taskId), (Phase)phasesToRestore.head(), this.permissions);
        List<Phase> restoredPhases = this.restorePhases((List)JavaConverters$.MODULE$.seqAsJavaListConverter(phasesToRestore).asJava());
        this.updateGatesReferencingPhases((Seq<Phase>)phasesToRestore, (Seq<Phase>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(restoredPhases).asScala()));
        Changes changes = release.restorePhases(restoredPhases);
        changes.addAll(release.getCurrentPhase().close());
        changes.addAll(this.skipTasksBefore(taskId, (Phase)phasesToRestore.head(), restoredPhases.get(0)));
        this.persistRelease(original, release, changes, restoredPhases);
        return release;
    }

    public PhaseVersion restartPhases$default$4() {
        return PhaseVersion.ALL;
    }

    public boolean restartPhases$default$5() {
        return false;
    }

    public List<Phase> restorePhases(List<Phase> phasesToRestore) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(phasesToRestore).asScala()).map((Function1 & Serializable & scala.Serializable)originalPhase -> {
            void var2_2;
            Phase restoredPhase = this.restorePhase((Phase)originalPhase);
            this.restoreTasks(originalPhase.getTasks(), restoredPhase.getTasks());
            return var2_2;
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Phase restorePhase(Phase phase) {
        void var3_3;
        String restoredPhaseId = this.ciIdService.getUniqueId(Type.valueOf(Phase.class), Ids.releaseIdFrom((String)phase.getId()));
        Phase copiedPhase = (Phase)CiCloneHelper.cloneCi((ConfigurationItem)phase);
        CiHelper.rewriteWithNewId((ConfigurationItem)copiedPhase, (String)restoredPhaseId);
        copiedPhase.setTitle(RetryTitleGenerator.getNextTitle((String)phase.getTitle()));
        copiedPhase.setStatus(PhaseStatus.PLANNED);
        copiedPhase.setStartDate(null);
        copiedPhase.setEndDate(null);
        copiedPhase.setOriginId(phase.getId());
        return var3_3;
    }

    private void restoreTasks(List<Task> originalTasks, List<Task> newTasks) {
        ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(originalTasks).asScala()).indices().foreach((Function1 & Serializable & scala.Serializable)i -> SqlPhaseRestart.$anonfun$restoreTasks$1(this, newTasks, originalTasks, BoxesRunTime.unboxToInt((Object)i)));
    }

    private void updateGatesReferencingPhases(Seq<Phase> phasesToRestore, Seq<Phase> restoredPhases) {
        scala.collection.immutable.Map originToRestored = PhaseRestart$.MODULE$.buildOriginToRestored(phasesToRestore, restoredPhases);
        this.scheduler.execute(() -> ((IterableLike)phasesToRestore.flatMap((Function1 & Serializable & scala.Serializable)phase -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter($this.dependencyService.findActiveIncomingGateIds(phase.getId())).asScala(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.releaseActorService.updateGateReferencingPhases(x$2, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)originToRestored).asJava());
            return BoxedUnit.UNIT;
        }));
    }

    private Changes skipTasksBefore(String taskId, Phase originalPhase, Phase restoredPhase) {
        Changes changes;
        block0: {
            int taskIndexToRestartFrom = ((GenSeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(originalPhase.getTasks()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> (String)CiHelper.TO_ID.apply(x$3), Buffer$.MODULE$.canBuildFrom())).indexOf((Object)taskId);
            changes = new Changes();
            if (taskIndexToRestartFrom <= 0) break block0;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), taskIndexToRestartFrom).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Task task = (Task)restoredPhase.getTasks().get(i);
                changes.addAll(task.markAsDone(task.getId(), TaskStatus.SKIPPED_IN_ADVANCE));
            });
        }
        return changes;
    }

    private void persistRelease(Release original, Release release, Changes changes, List<Phase> restoredPhases) {
        XLReleaseOperations$.MODULE$.runActionInterceptors(changes.getOperations(), this.eventBus);
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService);
        this.releaseRepository.update(original, release);
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(changes.getUpdatedItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SqlPhaseRestart.$anonfun$persistRelease$1(x$4)))).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.taskRepository.updateTaskProperties((Task)task);
            return BoxedUnit.UNIT;
        });
        this.facetRepository.createFromTasks((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(restoredPhases).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$5.getAllTasks()).asScala(), Buffer$.MODULE$.canBuildFrom()));
        XLReleaseOperations$.MODULE$.publishEvents(changes.getOperations(), this.eventBus);
    }

    public static final /* synthetic */ Task $anonfun$restoreTasks$1(SqlPhaseRestart $this, List newTasks$1, List originalTasks$1, int i) {
        Task restoredTask = $this.taskBackup.restoreTask((Task)newTasks$1.get(i), ((BaseConfigurationItem)originalTasks$1.get(i)).getId(), true);
        restoredTask.getAllTasks().forEach(subTask -> subTask.setStatus(TaskStatus.PLANNED));
        restoredTask.clearComments();
        restoredTask.setStartDate(null);
        restoredTask.setEndDate(null);
        Task task = restoredTask;
        if (task instanceof GateTask) {
            GateTask gateTask = (GateTask)task;
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getConditions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.setChecked(false);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return newTasks$1.set(i, restoredTask);
    }

    public static final /* synthetic */ boolean $anonfun$persistRelease$1(ConfigurationItem x$4) {
        return x$4 instanceof Task;
    }

    @Autowired
    public SqlPhaseRestart(Scheduler scheduler, TaskBackup taskBackup, PermissionChecker permissions, ReleaseRepository releaseRepository, CiIdService ciIdService, DependencyService dependencyService, TaskRepository taskRepository, ReleaseActorService releaseActorService, FacetRepository facetRepository, XLReleaseEventBus eventBus) {
        this.scheduler = scheduler;
        this.taskBackup = taskBackup;
        this.permissions = permissions;
        this.releaseRepository = releaseRepository;
        this.ciIdService = ciIdService;
        this.dependencyService = dependencyService;
        this.taskRepository = taskRepository;
        this.releaseActorService = releaseActorService;
        this.facetRepository = facetRepository;
        this.eventBus = eventBus;
        PhaseRestart.$init$((PhaseRestart)this);
    }
}

