/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.variables.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class ListStringVariable
extends Variable.VariableWithValue<List<String>> {
    @PublicApiMember
    @Property(required=false, description="Value of the release variable or default value of the template variable")
    protected List<String> value;

    @Override
    @PublicApiMember
    public List<String> getValue() {
        return this.value == null ? this.getEmptyValue() : Lists.newArrayList(this.value);
    }

    @Override
    public List<String> getEmptyValue() {
        return new ArrayList<String>();
    }

    @Override
    public boolean isValueEmpty() {
        return this.value == null || this.value.isEmpty();
    }

    @Override
    @PublicApiMember
    public void setValue(List<String> value) {
        this.value = value == null ? this.getEmptyValue() : value;
    }

    @Override
    public void setUntypedValue(Object newValue) {
        if (newValue == null) {
            this.setValue(null);
        } else if (newValue instanceof Collection) {
            Collection items = (Collection)newValue;
            List<String> list = items.stream().map(String::valueOf).collect(Collectors.toList());
            this.setValue(list);
        } else {
            throw new IllegalArgumentException(String.format("Cannot set instance of %s into list of strings variable value: %s", newValue.getClass().getSimpleName(), newValue));
        }
    }

    @Override
    public boolean isPassword() {
        return false;
    }

    @Override
    public String getValueAsString() {
        return this.formatValueAsString((List<String>)this.getValue());
    }

    @Override
    public String getEmptyValueAsString() {
        return this.formatValueAsString((List<String>)this.getEmptyValue());
    }

    @Override
    public boolean isValueAssignableFrom(Object value) {
        return value instanceof Collection || value instanceof Iterable;
    }

    private String formatValueAsString(List<String> valueToFormat) {
        List withQuotes = valueToFormat.stream().map(e -> String.format("'%s'", this.escapeQuotes((String)e))).collect(Collectors.toList());
        return String.format("[%s]", Joiner.on((String)", ").join(withQuotes));
    }
}

