/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.excel;

import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.excel.Export;
import com.xebialabs.xlrelease.reports.audit.CommonFormat;
import com.xebialabs.xlrelease.reports.excel.ExcelHeaderColumn;
import com.xebialabs.xlrelease.reports.excel.ReportWorkbook;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.joda.time.Duration;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class ExcelSheetWriter {
    private static final String DEFAULT_PHASE_COLOR = "#E7E6E6";
    public static final Integer MAXIMUM_CELL_LENGTH = Short.MAX_VALUE;
    public static final PeriodFormatter PERIOD_FORMATTER = new PeriodFormatterBuilder().printZeroAlways().appendDays().appendSuffix("d").appendSeparator(" ").appendHours().appendSuffix("h").appendSeparator(" ").appendMinutes().appendSuffix("m").appendSeparator(" ").printZeroNever().appendSeconds().appendSuffix("s").toFormatter();
    private final ReportWorkbook reportWorkbook;
    private final XSSFWorkbook workbook;
    private final XSSFSheet sheet;
    private XSSFRow row;
    int rowIndex = 0;
    int columnIndex = 0;
    private int groupStartIndex;
    private XSSFCellStyle dateStyle;
    private XSSFCellStyle phaseStyle;
    boolean isPhaseRow = false;
    boolean isBoldRow = false;
    boolean isWrappedRow = false;
    private float defaultRowHeight = 0.0f;

    public ExcelSheetWriter(ReportWorkbook reportWorkbook, XSSFSheet sheet) {
        this.reportWorkbook = reportWorkbook;
        this.sheet = sheet;
        this.workbook = reportWorkbook.getWorkbookWithoutErrorSheet();
        this.dateStyle = this.workbook.createCellStyle();
        this.dateStyle.setDataFormat(this.workbook.createDataFormat().getFormat(CommonFormat.DATE_FORMAT()));
        this.phaseStyle = this.workbook.createCellStyle();
        this.phaseStyle.setFillForegroundColor(new XSSFColor(Color.decode(DEFAULT_PHASE_COLOR)));
        this.phaseStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        sheet.protectSheet("");
    }

    public ExcelSheetWriter newRow() {
        this.row = this.sheet.createRow(this.rowIndex++);
        this.columnIndex = 0;
        return this;
    }

    public ExcelSheetWriter setRowHeight(float points) {
        this.row.setHeightInPoints(points);
        return this;
    }

    public ExcelSheetWriter indent() {
        ++this.columnIndex;
        return this;
    }

    public ExcelSheetWriter goToStartOfLine() {
        this.columnIndex = 0;
        return this;
    }

    public ExcelSheetWriter newColumn() {
        CellUtil.createCell((Row)this.row, (int)this.columnIndex++, (String)"", (CellStyle)this.getDefaultStyle());
        return this;
    }

    public ExcelSheetWriter addHeaderCell(String text, int width) {
        Cell headerCell = CellUtil.createCell((Row)this.row, (int)this.columnIndex, (String)ExcelSheetWriter.truncate(text));
        headerCell.setCellStyle((CellStyle)this.getHeaderCellStyle());
        this.sheet.setColumnWidth(this.columnIndex, ExcelSheetWriter.numberOfCharacter(width));
        ++this.columnIndex;
        return this;
    }

    public ExcelSheetWriter addHeaderCell(ExcelHeaderColumn header) {
        return this.addHeaderCell(header.header(), header.width());
    }

    public ExcelSheetWriter addHeaderCell(ExcelHeaderColumn header, XSSFCellStyle style) {
        return this.addHeaderCell(header.header(), header.width(), style);
    }

    public ExcelSheetWriter addHeaderCell(String text, int width, XSSFCellStyle style) {
        Cell headerCell = CellUtil.createCell((Row)this.row, (int)this.columnIndex, (String)ExcelSheetWriter.truncate(text));
        headerCell.setCellStyle((CellStyle)style);
        this.sheet.setColumnWidth(this.columnIndex, ExcelSheetWriter.numberOfCharacter(width));
        ++this.columnIndex;
        return this;
    }

    public ExcelSheetWriter addCell(Object entry) {
        if (entry instanceof Date) {
            this.addCell((Date)entry);
        } else if (entry instanceof Duration) {
            this.addCell((Duration)entry);
        } else {
            this.addCell(Objects.toString(entry, ""));
        }
        return this;
    }

    protected ExcelSheetWriter addCell(Object entry, XSSFCellStyle style) {
        if (entry instanceof Date) {
            this.addCell((Date)entry, style);
        } else if (entry instanceof Duration) {
            this.addCell((Duration)entry, style);
        } else {
            this.addCell(Objects.toString(entry, ""), style);
        }
        return this;
    }

    public ExcelSheetWriter addCell(Integer entry, XSSFCellStyle style) {
        Cell cell = CellUtil.createCell((Row)this.row, (int)this.columnIndex, null, (CellStyle)style);
        cell.setCellValue((double)entry.intValue());
        cell.setCellStyle((CellStyle)style);
        ++this.columnIndex;
        return this;
    }

    public ExcelSheetWriter addCell(String text, XSSFCellStyle style) {
        CellUtil.createCell((Row)this.row, (int)this.columnIndex, (String)ExcelSheetWriter.truncate(text), (CellStyle)style);
        ++this.columnIndex;
        return this;
    }

    public ExcelSheetWriter addCell(String text) {
        CellUtil.createCell((Row)this.row, (int)this.columnIndex, (String)ExcelSheetWriter.truncate(text), (CellStyle)this.getDefaultStyle());
        ++this.columnIndex;
        return this;
    }

    public ExcelSheetWriter setCellHyperlink(XSSFHyperlink hyperlink) {
        this.row.getCell(this.columnIndex - 1).setHyperlink((Hyperlink)hyperlink);
        return this;
    }

    public ExcelSheetWriter addCell(XSSFRichTextString text, XSSFCellStyle style) {
        XSSFCell textCell = this.row.createCell(this.columnIndex);
        textCell.setCellValue((RichTextString)text);
        textCell.setCellStyle((CellStyle)style);
        ++this.columnIndex;
        return this;
    }

    public ExcelSheetWriter addCell(Date date, XSSFCellStyle style) {
        XSSFCell dateCell = this.row.createCell(this.columnIndex);
        dateCell.setCellStyle((CellStyle)style);
        if (date != null) {
            dateCell.setCellValue(date);
        }
        ++this.columnIndex;
        return this;
    }

    public ExcelSheetWriter addCell(Date date) {
        this.addCell(date, this.getDateStyle());
        return this;
    }

    public ExcelSheetWriter addCell(Duration duration) {
        XSSFCell durationCell = this.row.createCell(this.columnIndex);
        durationCell.setCellStyle((CellStyle)this.getDefaultStyle());
        if (duration != null) {
            durationCell.setCellValue(ExcelSheetWriter.truncate(PERIOD_FORMATTER.print((ReadablePeriod)duration.toPeriod().normalizedStandard(PeriodType.dayTime()))));
        }
        ++this.columnIndex;
        return this;
    }

    public ExcelSheetWriter addCell(String text, Color color) {
        XSSFColor backgroundColor = null;
        if (color != null) {
            backgroundColor = new XSSFColor(color);
        }
        CellUtil.createCell((Row)this.row, (int)this.columnIndex, (String)ExcelSheetWriter.truncate(text), (CellStyle)this.getStyle(false, false, backgroundColor));
        ++this.columnIndex;
        return this;
    }

    public ExcelSheetWriter addEmptyCell(XSSFCellStyle style) {
        if (this.row.getCell(this.columnIndex) == null) {
            XSSFCell cell = this.row.createCell(this.columnIndex);
            cell.setCellStyle((CellStyle)style);
        }
        ++this.columnIndex;
        return this;
    }

    public ExcelSheetWriter addHyperlink(String text, String url, XSSFCellStyle hyperlinkStyle) {
        return this.addHyperlink(text, url, HyperlinkType.URL, hyperlinkStyle);
    }

    public ExcelSheetWriter addHyperlink(String text, String url, HyperlinkType type, XSSFCellStyle hyperlinkStyle) {
        Cell cell = CellUtil.createCell((Row)this.row, (int)this.columnIndex++, (String)ExcelSheetWriter.truncate(text), (CellStyle)hyperlinkStyle);
        XSSFHyperlink link = this.workbook.getCreationHelper().createHyperlink(type);
        link.setAddress(url);
        cell.setHyperlink((Hyperlink)link);
        return this;
    }

    public ExcelSheetWriter addFullText(String text) {
        this.isWrappedRow = true;
        this.defaultRowHeight = CellUtil.getRow((int)this.row.getRowNum(), (Sheet)this.sheet).getHeightInPoints();
        CellUtil.createCell((Row)this.row, (int)this.columnIndex++, (String)ExcelSheetWriter.truncate(text), (CellStyle)this.getDefaultStyle());
        CellUtil.getRow((int)this.row.getRowNum(), (Sheet)this.sheet).setHeightInPoints(this.defaultRowHeight);
        this.isWrappedRow = false;
        return this;
    }

    protected ExcelSheetWriter addProperty(String key, String value) {
        this.addCell(ExcelSheetWriter.truncate(key));
        this.addCell(ExcelSheetWriter.truncate(value));
        this.newRow();
        return this;
    }

    public ExcelSheetWriter mergeCells(CellRangeAddress range) {
        this.sheet.addMergedRegion(range);
        return this;
    }

    public ExcelSheetWriter applyPhaseColor(Phase phase) {
        String phaseColor = phase.getColor();
        this.phaseStyle = this.workbook.createCellStyle();
        Color color = phaseColor == null ? Color.decode(DEFAULT_PHASE_COLOR) : Color.decode(phaseColor).brighter();
        this.phaseStyle.setFillForegroundColor(new XSSFColor(color));
        this.phaseStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return this;
    }

    protected ExcelSheetWriter startGroup() {
        this.groupStartIndex = this.rowIndex;
        return this;
    }

    protected ExcelSheetWriter endGroup() {
        this.sheet.groupRow(this.groupStartIndex, this.rowIndex - 1);
        return this;
    }

    private ExcelSheetWriter addHeaderFilter(int headerRowIndex, int startIndex, int endIndex, boolean freezePane) {
        this.sheet.setAutoFilter(new CellRangeAddress(headerRowIndex, headerRowIndex, startIndex, endIndex));
        if (freezePane) {
            this.sheet.createFreezePane(0, 1);
        }
        return this;
    }

    public ExcelSheetWriter addHeaderFilter(int numberOfColumns, boolean freezePane) {
        return this.addHeaderFilter(this.rowIndex - 1, 0, numberOfColumns - 1, freezePane);
    }

    public ExcelSheetWriter addHeaderFilter(int numberOfColumns) {
        return this.addHeaderFilter(numberOfColumns, false);
    }

    public XSSFCellStyle getDefaultStyle() {
        return this.getStyle(false, false, null);
    }

    private XSSFCellStyle getHeaderCellStyle() {
        return this.getStyle(true, false, null);
    }

    public XSSFCellStyle getDateStyle() {
        return this.getStyle(false, true, null);
    }

    private XSSFCellStyle getStyle(boolean isHeader, boolean isDate, XSSFColor backgroundColor) {
        XSSFCellStyle cellStyle = this.workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
        XSSFFont defaultFont = this.workbook.createFont();
        defaultFont.setFontHeightInPoints((short)12);
        cellStyle.setFont((Font)defaultFont);
        if (isDate) {
            cellStyle.setDataFormat(this.dateStyle.getDataFormat());
        }
        if (backgroundColor != null) {
            cellStyle.setFillForegroundColor(backgroundColor);
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        } else if (this.isPhaseRow) {
            cellStyle.setFillForegroundColor(this.phaseStyle.getFillForegroundXSSFColor());
            cellStyle.setFillPattern(this.phaseStyle.getFillPatternEnum());
        }
        if (this.isWrappedRow) {
            cellStyle.setWrapText(true);
        }
        if (this.isBoldRow) {
            XSSFFont font = this.workbook.createFont();
            font.setBold(true);
            cellStyle.setFont((Font)font);
        }
        if (isHeader) {
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
        }
        return cellStyle;
    }

    public ExcelSheetWriter insertImage(URL imageResource, int rowIndex, int colIndex, int magicWidth, int magicHeight) {
        byte[] imageBytes = null;
        try {
            imageBytes = IOUtils.toByteArray((URL)imageResource);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (imageBytes != null) {
            XSSFClientAnchor anchor = this.workbook.getCreationHelper().createClientAnchor();
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
            anchor.setCol1(colIndex);
            anchor.setRow1(rowIndex);
            anchor.setRow2(colIndex);
            anchor.setCol2(rowIndex);
            anchor.setDx1(285750);
            anchor.setDx2(magicWidth * 9525);
            anchor.setDy1(95250);
            anchor.setDy2(magicHeight * 9525);
            int pictureIndex = this.workbook.addPicture(imageBytes, 6);
            XSSFPicture picture = this.sheet.createDrawingPatriarch().createPicture(anchor, pictureIndex);
            picture.resize(1.0, 0.9);
        }
        return this;
    }

    public ExcelSheetWriter replaceWithHyperlink(int srcRow, int srcCol, String targetSheet, int targetRow, int targetCol, XSSFCellStyle hyperlinkStyle) {
        XSSFCell cell = this.sheet.getRow(srcRow).getCell(srcCol);
        XSSFHyperlink link = this.workbook.getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
        link.setAddress(String.format("'%s'!%s%d", targetSheet, CellReference.convertNumToColString((int)targetCol), targetRow + 1));
        cell.setHyperlink((Hyperlink)link);
        cell.setCellStyle((CellStyle)hyperlinkStyle);
        return this;
    }

    public ExcelSheetWriter addBottomBorderToCell(XSSFCell cell) {
        XSSFCellStyle style = this.workbook.createCellStyle();
        style.cloneStyleFrom((CellStyle)cell.getCellStyle());
        style.setBorderBottom(BorderStyle.THIN);
        cell.setCellStyle((CellStyle)style);
        return this;
    }

    private static int numberOfCharacter(int number) {
        return number * 256;
    }

    public XSSFWorkbook getWorkbook() {
        Export.preventDynamicDataExchangeAttack((XSSFWorkbook)this.workbook);
        return this.workbook;
    }

    public XSSFSheet getSheet() {
        return this.sheet;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public boolean isWrappedRow() {
        return this.isWrappedRow;
    }

    public void setWrappedRow(boolean wrapped) {
        this.isWrappedRow = wrapped;
    }

    public boolean isPhaseRow() {
        return this.isPhaseRow;
    }

    public void setPhaseRow(boolean isPhaseRow) {
        this.isPhaseRow = isPhaseRow;
    }

    public ReportWorkbook getReportWorkbook() {
        return this.reportWorkbook;
    }

    public static String truncate(String text) {
        if (text != null && text.length() > MAXIMUM_CELL_LENGTH) {
            return text.substring(0, MAXIMUM_CELL_LENGTH);
        }
        return text;
    }
}

