/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.xebialabs.deployit.plumbing.id.DomainIdDeserializer;
import com.xebialabs.deployit.plumbing.id.DomainIdSerializer;
import com.xebialabs.xlrelease.domain.PollType;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.views.BaseConfigurationItemView;
import java.util.List;
import java.util.TimeZone;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.support.CronSequenceGenerator;

public class ReleaseTriggerView
extends BaseConfigurationItemView {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseTriggerView.class);
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String id;
    private String name;
    private List<Variable> variables;
    private List<String> tags;

    public boolean hasValidPeriodicity() {
        PollType pollType = PollType.valueOf((String)String.valueOf(this.getProperty("pollType")));
        String interval = String.valueOf(this.getProperty("periodicity"));
        try {
            if (PollType.CRON.equals((Object)pollType)) {
                try {
                    new CronSequenceGenerator(interval, TimeZone.getDefault());
                    return true;
                }
                catch (Exception e) {
                    if (!CronExpression.isValidExpression((String)interval)) {
                        throw new IllegalArgumentException(String.format("Wrong QUARTZ CRON expression: %s", interval));
                    }
                    return true;
                }
            }
            Integer.parseInt(interval);
            return true;
        }
        catch (Exception e) {
            logger.error("Wrong interval", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }
}

