import React from 'react';
import PropTypes from 'prop-types';

export default class EditableLabel extends React.Component {

    static propTypes = {
        disabled: PropTypes.bool,
        inputBorderWidth: PropTypes.string,
        inputClassName: PropTypes.string,
        inputFontSize: PropTypes.string,
        inputFontWeight: PropTypes.string,
        inputHeight: PropTypes.string,
        inputMaxLength: PropTypes.number,
        inputPlaceHolder: PropTypes.string,
        inputTabIndex: PropTypes.number,
        inputWidth: PropTypes.string,
        isEditing: PropTypes.bool,
        labelClassName: PropTypes.string,
        labelFontSize: PropTypes.string,
        labelFontWeight: PropTypes.string,
        onFocus: PropTypes.func,
        onFocusOut: PropTypes.func,
        required: PropTypes.bool,
        text: PropTypes.string.isRequired
    };

    constructor(props) {
        super(props);

        this.state = {
            isEditing: this.props.isEditing || false,
            text: this.props.text || "",
            lastSaved: this.props.text
        };
    }

    _handleFocus = () => {
        const {disabled, onFocus, onFocusOut} = this.props;
        if (!disabled) {
            const {isEditing, text} = this.state;
            if (isEditing) {
                if (text && text.length > 0) {
                    /* eslint-disable angular/typecheck-function */
                    if (typeof onFocusOut === 'function') {
                        onFocusOut(text);
                    }
                    /* eslint-enable */
                }
            } else {
                /* eslint-disable angular/typecheck-function */
                if (typeof onFocus === 'function') {
                    onFocus(text);
                }
                /* eslint-enable */
            }

            if (text && text.length > 0) {
                this.setState({
                    lastSaved: text,
                    isEditing: !isEditing,
                });
            }
        }
    };

    _handleChange = (ev) => {
        this.setState({
            text: ev.target.value,
        });
    };

    _handleKeyDown = e => {
        switch (e.key) {
            case 'Enter':
                this._handleFocus(e);
                this._handleChange(e);
                break;
            case 'Escape':
                this.setState({
                    text: this.state.lastSaved,
                    isEditing: false
                });
                break;
        }
    };

    render() {
        return (
            <div>
                {this.state.isEditing ? (
                    <input autoFocus
                           className={this.props.inputClassName}
                           maxLength={this.props.inputMaxLength}
                           onBlur={this._handleFocus}
                           onChange={this._handleChange}
                           onKeyDown={this._handleKeyDown}
                           placeholder={this.props.inputPlaceHolder}
                           style={{
                               width: this.props.inputWidth,
                               height: '30px',
                               fontSize: this.props.inputFontSize,
                               fontWeight: this.props.inputFontWeight,
                               borderWidth: this.props.inputBorderWidth,
                               borderColor: this.props.required && this.state.text.length === 0 ? '#D94C3D' : 'none'
                           }}
                           tabIndex={this.props.inputTabIndex}
                           type="text"
                           value={this.state.text}/>
                ) : (
                    <label className={this.props.labelClassName}
                           onClick={this._handleFocus}
                           style={{
                               fontSize: this.props.labelFontSize,
                               fontWeight: this.props.labelFontWeight,
                               height: '30px'
                           }}
                           title={this.state.text}>
                        {this.state.text}
                    </label>
                )}
            </div>
        );
    }
}
