import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {XlReactWidgetLabel} from 'xl-react-components';
import Select, {components} from 'react-select';

import {Menu, MultiValueLabel, DropdownIndicator, Option} from './widget-multiselect-modules';

import {SelectModel} from './widget-multiselect.type';

const customStyles = {
    control: (providedStyle, state) => ({
        ...providedStyle,
        minHeight: 30,
        '&:hover': {},
        borderColor: state.isFocused ? '#0099cc' : '#D5D5D5',
        boxShadow: state.isFocused ? '0 0 8px #5fcbf4' : 'none',
        outline: 0,
    }),
    dropdownIndicator: (providedStyle, state) => ({
        ...providedStyle,
        padding: 0,
    }),
    indicatorSeparator: (providedStyle, state) => ({
        display: 'none',
    }),
    input: (providedStyle, state) => ({
        ...providedStyle,
        margin: 0,
        padding: 0,
        boxShadow: 'none',
    }),
    menu: (providedStyle, state) => ({
        ...providedStyle,
        zIndex: 100,
        boxShadow: '0 10px 10px -10px #d5d5d5',
        border: 'solid 1px #d5d5d5',
        marginTop: 2,
        marginBottom: 2,
    }),
    menuList: (providedStyle, state) => ({
        ...providedStyle,
        paddingTop: 0,
        paddingBottom: 0,
        maxHeight: 180,
    }),
    multiValue: (providedStyle, state) => ({
        ...providedStyle,
        background: 'none',
        borderRadius: 'none',
        margin: 0,
        height: '28px',
        lineHeight: '28px',
    }),
    multiValueLabel: (providedStyle, state) => ({
    }),
    multiValueRemove: () => ({
        display: 'none',
    }),
    option: (providedStyle, state) => ({
        ...providedStyle,
        padding: '7px 10px',
        backgroundColor: state.isFocused ? '#f0f0f0' : state.isSelected ? 'rgba(0, 153, 204, 0.15)' : '#ffffff',
        WebkitTapHighlightColor: 'rgba(0, 153, 204, 0.15)',
        ':hover': {backgroundColor: '#f0f0f0'},
        ':active': {'backgroundColor': 'inherit'},
        color: state.isSelected ? 'inherit' : 'inherit',
    }),
    placeholder: (providedStyle, state) => ({
        ...providedStyle,
        margin: 0,
        color: '#999999',
    }),
    valueContainer: (providedStyle, state) => ({
        ...providedStyle,
        padding: '1px 10px',
    }),
};

export class WidgetMultiSelect extends Component {
    static propTypes = {
        metadata: PropTypes.object,
        model: PropTypes.arrayOf(SelectModel),
        noOptionMessage: PropTypes.string,
        onPristinityChange: PropTypes.func,
        onSelectChange: PropTypes.func,
        options: PropTypes.arrayOf(SelectModel),
    };

    static defaultProps = {
        model: [],
        options: []
    };


    changePristinityChange = (pristine) => {
      const {onPristinityChange} = this.props;
      onPristinityChange(pristine);
    };

    handleSelect = (selectedOptions) => {this.changePristinityChange(false); this.props.onSelectChange(selectedOptions);};
    handleSelectAll = () => {this.changePristinityChange(false); this.props.onSelectChange(this.props.options);};
    handleClearAll = () => {this.changePristinityChange(false); this.props.onSelectChange([]);};

    render() {
        const {metadata, model, options} = this.props;

        return (
            <div className='xl-react-components'>
                <XlReactWidgetLabel metadata={metadata}/>
                <Select
                    closeMenuOnSelect={false}
                    components={{DropdownIndicator, MultiValueLabel, Menu, Option}}
                    hideSelectedOptions={false}
                    isClearable={false}
                    isMulti
                    noOptionsMessage={() => metadata.noOptionMessage}
                    onChange={this.handleSelect}
                    onClearAll={this.handleClearAll}
                    onSelectAll={this.handleSelectAll}
                    options={options}
                    placeholder={metadata.placeholder}
                    styles={customStyles}
                    value={model}
                />
                <div className='xl-react-components-description'>
                    <div>{metadata.description}</div>
                </div>
            </div>
        );
    }
}
