/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.api.internal;

import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.notifications.actors.extension.TaskWatcherExecutionActorMessages;
import com.xebialabs.xlrelease.notifications.package$;
import com.xebialabs.xlrelease.notifications.service.TaskWatchersService;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;

@Path(value="/tasks")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0001\u0003\u0001=\u0011A\u0003V1tW^\u000bGo\u00195feN\u0014Vm]8ve\u000e,'BA\u0002\u0005\u0003!Ig\u000e^3s]\u0006d'BA\u0003\u0007\u0003\r\t\u0007/\u001b\u0006\u0003\u000f!\tQB\\8uS\u001aL7-\u0019;j_:\u001c(BA\u0005\u000b\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\f\u0019\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011]\u0001!\u0011!Q\u0001\na\t1\u0002]3s[&\u001c8/[8ogB\u0011\u0011\u0004H\u0007\u00025)\u00111\u0004C\u0001\tg\u0016\u001cWO]5us&\u0011QD\u0007\u0002\u0012!\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014\b\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002'I,G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rB\u0011AB1di>\u00148/\u0003\u0002&E\t\u0019\"+\u001a7fCN,\u0017i\u0019;peN+'O^5dK\"Aq\u0005\u0001B\u0001B\u0003%\u0001&A\nuCN\\w+\u0019;dQ\u0016\u00148oU3sm&\u001cW\r\u0005\u0002*Y5\t!F\u0003\u0002,\r\u000591/\u001a:wS\u000e,\u0017BA\u0017+\u0005M!\u0016m]6XCR\u001c\u0007.\u001a:t'\u0016\u0014h/[2f\u0011!y\u0003A!A!\u0002\u0013\u0001\u0014a\u0003;bg.\u001cVM\u001d<jG\u0016\u0004\"!M\u001a\u000e\u0003IR!a\u000b\u0005\n\u0005Q\u0012$a\u0003+bg.\u001cVM\u001d<jG\u0016D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u0001\u0012kN,'OV5fo\u000e{gN^3si\u0016\u0014\bC\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003)\u0019wN\u001c<feR,'o\u001d\u0006\u0003y!\tQA^5foNL!AP\u001d\u0003#U\u001bXM\u001d,jK^\u001cuN\u001c<feR,'\u000fC\u0003A\u0001\u0011\u0005\u0011)\u0001\u0004=S:LGO\u0010\u000b\u0007\u0005\u0012+ei\u0012%\u0011\u0005\r\u0003Q\"\u0001\u0002\t\u000b]y\u0004\u0019\u0001\r\t\u000b}y\u0004\u0019\u0001\u0011\t\u000b\u001dz\u0004\u0019\u0001\u0015\t\u000b=z\u0004\u0019\u0001\u0019\t\u000bYz\u0004\u0019A\u001c)\u0005}R\u0005CA&W\u001b\u0005a%BA'O\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u001fB\u000bqAZ1di>\u0014\u0018P\u0003\u0002R%\u0006)!-Z1og*\u00111\u000bV\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tQ+A\u0002pe\u001eL!a\u0016'\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"B-\u0001\t\u0003Q\u0016aC4fi^\u000bGo\u00195feN$\"aW4\u0011\u0007q\u000b7-D\u0001^\u0015\tqv,\u0001\u0003vi&d'\"\u00011\u0002\t)\fg/Y\u0005\u0003Ev\u00131aU3u!\t!W-D\u0001<\u0013\t17H\u0001\u0005Vg\u0016\u0014h+[3x\u0011\u0015A\u0007\f1\u0001j\u0003\u0019!\u0018m]6JIB\u0011!.\u001d\b\u0003W>\u0004\"\u0001\u001c\n\u000e\u00035T!A\u001c\b\u0002\rq\u0012xn\u001c;?\u0013\t\u0001(#\u0001\u0004Qe\u0016$WMZ\u0005\u0003eN\u0014aa\u0015;sS:<'B\u00019\u0013Q\t9W\u000f\u0005\u0002w{6\tqO\u0003\u0002ys\u0006\u0011\u0011\u000e\u001a\u0006\u0003un\f\u0001\u0002\u001d7v[\nLgn\u001a\u0006\u0003y*\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003}^\u0014q!\u00133QCJ\fW\u000eK\u0004h\u0003\u0003\t)\"a\u0006\u0011\t\u0005\r\u0011\u0011C\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005\u0011!o\u001d\u0006\u0005\u0003\u0017\ti!\u0001\u0002xg*\u0011\u0011qB\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003'\t)AA\u0005QCRD\u0007+\u0019:b[\u0006)a/\u00197vK\u0006\n\u0001\u000eK\u0002Y\u00037\u0001B!a\u0001\u0002\u001e%!\u0011qDA\u0003\u0005\r9U\t\u0016\u0015\b1\u0006\r\u0012QCA\u0015!\u0011\t\u0019!!\n\n\t\u0005\u001d\u0012Q\u0001\u0002\u0005!\u0006$\b.\t\u0002\u0002,\u0005q2\u0010^1tW&#'H\f\u0016UCN\\7LX\u0018.;*jxf^1uG\",'o\u001d\u0005\b\u0003_\u0001A\u0011AA\u0019\u0003)\tG\rZ,bi\u000eDWM\u001d\u000b\u00067\u0006M\u0012\u0011\b\u0005\u0007Q\u00065\u0002\u0019A5)\u0007\u0005MR\u000f\u000b\u0005\u00024\u0005\u0005\u0011QCA\f\u0011\u001d\tY$!\fA\u0002\r\f1b^1uG\",'OV5fo\"\"\u0011QFA !\u0011\t\u0019!!\u0011\n\t\u0005\r\u0013Q\u0001\u0002\u0005!>\u001bF\u000b\u000b\u0005\u0002.\u0005\r\u0012QCA\u0015\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017\nQB]3n_Z,w+\u0019;dQ\u0016\u0014H#B.\u0002N\u0005M\u0003B\u00025\u0002H\u0001\u0007\u0011\u000eK\u0002\u0002NUD\u0003\"!\u0014\u0002\u0002\u0005U\u0011q\u0003\u0005\b\u0003+\n9\u00051\u0001j\u0003!)8/\u001a:oC6,\u0007\u0006CA*\u0003\u0003\t)\"!\u0017\"\u0005\u0005U\u0003\u0006BA$\u0003;\u0002B!a\u0001\u0002`%!\u0011\u0011MA\u0003\u0005\u0019!U\tT#U\u000b\"B\u0011qIA\u0012\u0003+\t)'\t\u0002\u0002h\u0005I3\u0010^1tW&#'H\f\u0016UCN\\7LX\u0018.;*jxf^1uG\",'o]\u0018|kN,'O\\1nKvDq!a\u001b\u0001\t\u0003\ti'\u0001\bva\u0012\fG/Z,bi\u000eDWM]:\u0015\u000bm\u000by'!\u001e\t\r!\fI\u00071\u0001jQ\r\ty'\u001e\u0015\t\u0003_\n\t!!\u0006\u0002\u0018!9\u0011qOA5\u0001\u0004Y\u0016\u0001D<bi\u000eDWM]:WS\u0016<\b\u0006BA5\u0003w\u0002B!a\u0001\u0002~%!\u0011qPA\u0003\u0005\r\u0001V\u000b\u0016\u0015\t\u0003S\n\u0019#!\u0006\u0002*!9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0015!D2p]Z,'\u000f\u001e+p-&,w\u000fF\u0002\\\u0003\u0013C\u0001\"a#\u0002\u0004\u0002\u0007\u0011QR\u0001\to\u0006$8\r[3sgB!!.a$j\u0013\t\u00117\u000fK\u0002\u0001\u0003'\u0003B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0004\u00033\u0013\u0016AC:uKJ,w\u000e^=qK&!\u0011QTAL\u0005)\u0019uN\u001c;s_2dWM\u001d\u0015\b\u0001\u0005\u0005\u0016QCAT!\u0011\t\u0019!a)\n\t\u0005\u0015\u0016Q\u0001\u0002\t!J|G-^2fg2\u0012\u0011\u0011V\u0011\u0003\u0003W\u000b\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8)\u000f\u0001\ty+!\u0006\u00026B!\u00111AAY\u0013\u0011\t\u0019,!\u0002\u0003\u0011\r{gn];nKNd#!!+)\u000f\u0001\t\u0019#!\u0006\u0002:\u0006\u0012\u00111X\u0001\u0007_Q\f7o[:")
public class TaskWatchersResource {
    private final PermissionChecker permissions;
    private final ReleaseActorService releaseActorService;
    private final TaskService taskService;
    private final UserViewConverter userViewConverter;

    @Path(value="{taskId:.*Task[^/-]*}/watchers")
    @GET
    public java.util.Set<UserView> getWatchers(@PathParam(value="taskId") @IdParam String taskId) {
        Task task = this.taskService.findByIdIncludingArchived(taskId);
        this.permissions.checkViewTask(task);
        return this.convertToView(package$.MODULE$.TaskWithNotificationFields(task).getWatchers());
    }

    @Path(value="{taskId:.*Task[^/-]*}/watchers")
    @POST
    public java.util.Set<UserView> addWatcher(@PathParam(value="taskId") @IdParam String taskId, UserView watcherView) {
        String string = User.AUTHENTICATED_USER.getName();
        String string2 = watcherView.getUsername();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        }
        scala.collection.immutable.Set watchers = (scala.collection.immutable.Set)this.releaseActorService.executeCommand(taskId, (ReleaseExecutionActorMessages.ExtensionCommand)new TaskWatcherExecutionActorMessages.AddWatcher(taskId, watcherView.getUsername()));
        return this.convertToView((scala.collection.immutable.Set<String>)watchers);
    }

    @Path(value="{taskId:.*Task[^/-]*}/watchers/{username}")
    @DELETE
    public java.util.Set<UserView> removeWatcher(@PathParam(value="taskId") @IdParam String taskId, @PathParam(value="username") String username) {
        String string = User.AUTHENTICATED_USER.getName();
        String string2 = username;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        }
        scala.collection.immutable.Set watchers = (scala.collection.immutable.Set)this.releaseActorService.executeCommand(taskId, (ReleaseExecutionActorMessages.ExtensionCommand)new TaskWatcherExecutionActorMessages.RemoveWatcher(taskId, username));
        return this.convertToView((scala.collection.immutable.Set<String>)watchers);
    }

    @Path(value="{taskId:.*Task[^/-]*}/watchers")
    @PUT
    public java.util.Set<UserView> updateWatchers(@PathParam(value="taskId") @IdParam String taskId, java.util.Set<UserView> watchersView) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        scala.collection.immutable.Set watchers = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(watchersView).asScala()).map((Function1 & Serializable & scala.Serializable)userView -> userView.getUsername(), Set$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set updatedWatchers = (scala.collection.immutable.Set)this.releaseActorService.executeCommand(taskId, (ReleaseExecutionActorMessages.ExtensionCommand)new TaskWatcherExecutionActorMessages.UpdateWatchers(taskId, (scala.collection.immutable.Set<String>)watchers));
        return this.convertToView((scala.collection.immutable.Set<String>)updatedWatchers);
    }

    private java.util.Set<UserView> convertToView(scala.collection.immutable.Set<String> watchers) {
        return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)watchers.map((Function1 & Serializable & scala.Serializable)username -> $this.userViewConverter.toUserView(username), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).asJava();
    }

    @Autowired
    public TaskWatchersResource(PermissionChecker permissions, ReleaseActorService releaseActorService, TaskWatchersService taskWatchersService, TaskService taskService, UserViewConverter userViewConverter) {
        this.permissions = permissions;
        this.releaseActorService = releaseActorService;
        this.taskService = taskService;
        this.userViewConverter = userViewConverter;
    }
}

