/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.events.AttachmentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.AttachmentDeletedEvent;
import com.xebialabs.xlrelease.domain.events.AttachmentEvent;
import com.xebialabs.xlrelease.events.EventListening;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ActivityLogRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.TaskService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.AllowConcurrentEvents;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u0017\t)\u0013\t\u001e;bG\"lWM\u001c;BGRLg/\u001b;z\u0019><w-\u001b8h\u000bZ,g\u000e\u001e%b]\u0012dWM\u001d\u0006\u0003\u0007\u0011\t\u0001\"Y2uSZLG/\u001f\u0006\u0003\u000b\u0019\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u001dA\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u00011\u0003\u0002\u0001\r%a\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0019)g/\u001a8ug&\u0011q\u0003\u0006\u0002\u000f\u000bZ,g\u000e\u001e'jgR,g.\u001b8h!\tIb$D\u0001\u001b\u0015\tYB$A\u0003tY\u001a$$NC\u0001\u001e\u0003!9'/\u001b>{Y\u0016$\u0017BA\u0010\u001b\u0005\u001daunZ4j]\u001eD\u0001\"\t\u0001\u0003\u0006\u0004%\tAI\u0001\tKZ,g\u000e\u001e\"vgV\t1\u0005\u0005\u0002\u0014I%\u0011Q\u0005\u0006\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\b\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u0013\u00154XM\u001c;CkN\u0004\u0003\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002+\u0005\u001cG/\u001b<jifdun\u001a*fa>\u001c\u0018\u000e^8ssB\u00111FL\u0007\u0002Y)\u0011Q\u0006B\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0018-\u0005U\t5\r^5wSRLHj\\4SKB|7/\u001b;pefD\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAM\u0001\fi\u0006\u001c8nU3sm&\u001cW\r\u0005\u00024m5\tAG\u0003\u00026\t\u000591/\u001a:wS\u000e,\u0017BA\u001c5\u0005-!\u0016m]6TKJ4\u0018nY3\t\u000be\u0002A\u0011\u0001\u001e\u0002\rqJg.\u001b;?)\u0011YTHP \u0011\u0005q\u0002Q\"\u0001\u0002\t\u000b\u0005B\u0004\u0019A\u0012\t\u000b%B\u0004\u0019\u0001\u0016\t\u000bEB\u0004\u0019\u0001\u001a)\u0005a\n\u0005C\u0001\"N\u001b\u0005\u0019%B\u0001#F\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\r\u001e\u000bqAZ1di>\u0014\u0018P\u0003\u0002I\u0013\u0006)!-Z1og*\u0011!jS\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tA*A\u0002pe\u001eL!AT\"\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"\u0002)\u0001\t\u0003\t\u0016!E8o\u0003R$\u0018m\u00195nK:$XI^3oiR\u0011!+\u0016\t\u0003\u001bMK!\u0001\u0016\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006->\u0003\raV\u0001\u0010CR$\u0018m\u00195nK:$XI^3oiB\u0011\u0001\fX\u0007\u00023*\u0011QC\u0017\u0006\u00037\u0012\ta\u0001Z8nC&t\u0017BA/Z\u0005=\tE\u000f^1dQ6,g\u000e^#wK:$\bFA(`!\t\u0001w-D\u0001b\u0015\t\u00117-A\u0003ue\t,8O\u0003\u0002eK\u0006A!.\u0019<bIV$WMC\u0001g\u0003\tqG.\u0003\u0002iC\n)\u0012\t\u001c7po\u000e{gnY;se\u0016tG/\u0012<f]R\u001c\bFA(k!\t\u00017.\u0003\u0002mC\nI1+\u001e2tGJL'-\u001a\u0015\u0003\u00019\u0004\"a\u001c:\u000e\u0003AT!!]%\u0002\u0015M$XM]3pif\u0004X-\u0003\u0002ta\nI1i\\7q_:,g\u000e\u001e")
public class AttachmentActivityLoggingEventHandler
implements EventListening,
Logging {
    private final XLReleaseEventBus eventBus;
    private final ActivityLogRepository activityLogRepository;
    private final TaskService taskService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @PostConstruct
    public void postConstruct() {
        EventListening.postConstruct$((EventListening)this);
    }

    @PreDestroy
    public void preDestroy() {
        EventListening.preDestroy$((EventListening)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        AttachmentActivityLoggingEventHandler attachmentActivityLoggingEventHandler = this;
        synchronized (attachmentActivityLoggingEventHandler) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Subscribe
    @AllowConcurrentEvents
    public void onAttachmentEvent(AttachmentEvent attachmentEvent) {
        boolean bl = false;
        AttachmentCreatedEvent attachmentCreatedEvent = null;
        boolean bl2 = false;
        AttachmentDeletedEvent attachmentDeletedEvent = null;
        AttachmentEvent attachmentEvent2 = attachmentEvent;
        if (attachmentEvent2 instanceof AttachmentCreatedEvent) {
            bl = true;
            attachmentCreatedEvent = (AttachmentCreatedEvent)attachmentEvent2;
            String releaseId = attachmentCreatedEvent.containerId();
            Attachment attachment = attachmentCreatedEvent.attachment();
            if (Ids.isReleaseId((String)releaseId)) {
                this.activityLogRepository.log(releaseId, ReleaseActivity.ATTACHMENT_ADDED.create(attachment.getFile().getName(), attachment.getContentType()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            String taskId = attachmentCreatedEvent.containerId();
            Attachment attachment = attachmentCreatedEvent.attachment();
            this.activityLogRepository.log(Ids.releaseIdFrom((String)taskId), ReleaseActivity.ATTACHMENT_ADDED_ON_TASK.create(attachment.getFile().getName(), attachment.getContentType(), this.taskService.getTitle(taskId)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (attachmentEvent2 instanceof AttachmentDeletedEvent) {
            bl2 = true;
            attachmentDeletedEvent = (AttachmentDeletedEvent)attachmentEvent2;
            String releaseId = attachmentDeletedEvent.containerId();
            Attachment attachment = attachmentDeletedEvent.attachment();
            if (Ids.isReleaseId((String)releaseId)) {
                this.activityLogRepository.log(releaseId, ReleaseActivity.ATTACHMENT_DELETED.create(attachment.getFile().getName()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl2) {
            String taskId = attachmentDeletedEvent.containerId();
            Attachment attachment = attachmentDeletedEvent.attachment();
            this.activityLogRepository.log(Ids.releaseIdFrom((String)taskId), ReleaseActivity.ATTACHMENT_DELETED_FROM_TASK.create(attachment.getFile().getName(), this.taskService.getTitle(taskId)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Event ", " not traced into activity logs"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachmentEvent2})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Autowired
    public AttachmentActivityLoggingEventHandler(XLReleaseEventBus eventBus, ActivityLogRepository activityLogRepository, TaskService taskService) {
        this.eventBus = eventBus;
        this.activityLogRepository = activityLogRepository;
        this.taskService = taskService;
        EventListening.$init$((EventListening)this);
        Logging.$init$((Logging)this);
    }
}

