/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.CommentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.CommentEvent;
import com.xebialabs.xlrelease.domain.events.CommentUpdatedEvent;
import com.xebialabs.xlrelease.events.EventListening;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ActivityLogRepository;
import com.xebialabs.xlrelease.repository.Ids;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.AllowConcurrentEvents;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u0017\t\u00113i\\7nK:$\u0018i\u0019;jm&$\u0018\u0010T8hO&tw-\u0012<f]RD\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u0011\u0005\u001cG/\u001b<jifT!!\u0002\u0004\u0002\u0013ad'/\u001a7fCN,'BA\u0004\t\u0003%AXMY5bY\u0006\u00147OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001AB\u0005\r\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0004fm\u0016tGo]\u0005\u0003/Q\u0011a\"\u0012<f]Rd\u0015n\u001d;f]&tw\r\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005)1\u000f\u001c45U*\tQ$\u0001\u0005he&T(\u0010\\3e\u0013\ty\"DA\u0004M_\u001e<\u0017N\\4\t\u0011\u0005\u0002!Q1A\u0005\u0002\t\n\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002GA\u00111\u0003J\u0005\u0003KQ\u0011\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0011!9\u0003A!A!\u0002\u0013\u0019\u0013!C3wK:$()^:!\u0011!I\u0003A!A!\u0002\u0013Q\u0013!F1di&4\u0018\u000e^=M_\u001e\u0014V\r]8tSR|'/\u001f\t\u0003W9j\u0011\u0001\f\u0006\u0003[\u0011\t!B]3q_NLGo\u001c:z\u0013\tyCFA\u000bBGRLg/\u001b;z\u0019><'+\u001a9pg&$xN]=\t\u000bE\u0002A\u0011\u0001\u001a\u0002\rqJg.\u001b;?)\r\u0019TG\u000e\t\u0003i\u0001i\u0011A\u0001\u0005\u0006CA\u0002\ra\t\u0005\u0006SA\u0002\rA\u000b\u0015\u0003aa\u0002\"!\u000f#\u000e\u0003iR!a\u000f\u001f\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002>}\u00059a-Y2u_JL(BA A\u0003\u0015\u0011W-\u00198t\u0015\t\t%)A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0019\u0015aA8sO&\u0011QI\u000f\u0002\n\u0003V$xn^5sK\u0012DQa\u0012\u0001\u0005\u0002!\u000bab\u001c8D_6lWM\u001c;Fm\u0016tG\u000f\u0006\u0002J\u0019B\u0011QBS\u0005\u0003\u0017:\u0011A!\u00168ji\")QJ\u0012a\u0001\u001d\u0006a1m\\7nK:$XI^3oiB\u0011qjU\u0007\u0002!*\u0011Q#\u0015\u0006\u0003%\u0012\ta\u0001Z8nC&t\u0017B\u0001+Q\u00051\u0019u.\\7f]R,e/\u001a8uQ\t1e\u000b\u0005\u0002X=6\t\u0001L\u0003\u0002Z5\u0006)AO\r2vg*\u00111\fX\u0001\tU\u00064\u0018\rZ;eK*\tQ,\u0001\u0002oY&\u0011q\f\u0017\u0002\u0016\u00032dwn^\"p]\u000e,(O]3oi\u00163XM\u001c;tQ\t1\u0015\r\u0005\u0002XE&\u00111\r\u0017\u0002\n'V\u00147o\u0019:jE\u0016D#\u0001A3\u0011\u0005\u0019LW\"A4\u000b\u0005!\u0004\u0015AC:uKJ,w\u000e^=qK&\u0011!n\u001a\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class CommentActivityLoggingEventHandler
implements EventListening,
Logging {
    private final XLReleaseEventBus eventBus;
    private final ActivityLogRepository activityLogRepository;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @PostConstruct
    public void postConstruct() {
        EventListening.postConstruct$((EventListening)this);
    }

    @PreDestroy
    public void preDestroy() {
        EventListening.preDestroy$((EventListening)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CommentActivityLoggingEventHandler commentActivityLoggingEventHandler = this;
        synchronized (commentActivityLoggingEventHandler) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onCommentEvent(CommentEvent commentEvent) {
        CommentEvent commentEvent2 = commentEvent;
        if (commentEvent2 instanceof CommentCreatedEvent) {
            CommentCreatedEvent commentCreatedEvent = (CommentCreatedEvent)commentEvent2;
            Task task = commentCreatedEvent.task();
            Comment comment = commentCreatedEvent.comment();
            String author = commentCreatedEvent.author();
            this.activityLogRepository.log(Ids.releaseIdFrom((String)task.getId()), ReleaseActivity.COMMENT_ADDED.create(comment.getText(), task.getTitle()), author);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (commentEvent2 instanceof CommentUpdatedEvent) {
            CommentUpdatedEvent commentUpdatedEvent = (CommentUpdatedEvent)commentEvent2;
            Task task = commentUpdatedEvent.task();
            Comment original = commentUpdatedEvent.original();
            Comment updated = commentUpdatedEvent.updated();
            this.activityLogRepository.log(Ids.releaseIdFrom((String)task.getId()), ReleaseActivity.COMMENT_UPDATED.create(original.getText(), updated.getText(), task.getTitle()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Event ", " not traced into activity logs"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commentEvent2})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Autowired
    public CommentActivityLoggingEventHandler(XLReleaseEventBus eventBus, ActivityLogRepository activityLogRepository) {
        this.eventBus = eventBus;
        this.activityLogRepository = activityLogRepository;
        EventListening.$init$((EventListening)this);
        Logging.$init$((Logging)this);
    }
}

