/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.events.EventListening;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ActivityLogRepository;
import com.xebialabs.xlrelease.repository.Ids;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.AllowConcurrentEvents;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u0017\tiB)\u001a9f]\u0012,gnY=M_\u001e<\u0017N\\4Fm\u0016tG\u000fS1oI2,'O\u0003\u0002\u0004\t\u0005A\u0011m\u0019;jm&$\u0018P\u0003\u0002\u0006\r\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u000f!\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003%\t1aY8n\u0007\u0001\u0019B\u0001\u0001\u0007\u00131A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\r\u00154XM\u001c;t\u0013\t9BC\u0001\bFm\u0016tG\u000fT5ti\u0016t\u0017N\\4\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012!B:mMRR'\"A\u000f\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\b\u000e\u0003\u000f1{wmZ5oO\"A\u0011\u0005\u0001BC\u0002\u0013\u0005!%\u0001\u0005fm\u0016tGOQ;t+\u0005\u0019\u0003CA\n%\u0013\t)CCA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkND\u0001b\n\u0001\u0003\u0002\u0003\u0006IaI\u0001\nKZ,g\u000e\u001e\"vg\u0002B\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0016C\u000e$\u0018N^5us2{wMU3q_NLGo\u001c:z!\tYc&D\u0001-\u0015\tiC!\u0001\u0006sKB|7/\u001b;pefL!a\f\u0017\u0003+\u0005\u001bG/\u001b<jifdun\u001a*fa>\u001c\u0018\u000e^8ss\")\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"2aM\u001b7!\t!\u0004!D\u0001\u0003\u0011\u0015\t\u0003\u00071\u0001$\u0011\u0015I\u0003\u00071\u0001+Q\t\u0001\u0004\b\u0005\u0002:\t6\t!H\u0003\u0002<y\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005ur\u0014a\u00024bGR|'/\u001f\u0006\u0003\u007f\u0001\u000bQAY3b]NT!!\u0011\"\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aQ\u0001\u0004_J<\u0017BA#;\u0005%\tU\u000f^8xSJ,G\rC\u0003H\u0001\u0011\u0005\u0001*A\tp]\u0012+\u0007/\u001a8eK:\u001c\u00170\u0012<f]R$\"!\u0013'\u0011\u00055Q\u0015BA&\u000f\u0005\u0011)f.\u001b;\t\u000b53\u0005\u0019\u0001(\u0002\u001f\u0011,\u0007/\u001a8eK:\u001c\u00170\u0012<f]R\u0004\"aT*\u000e\u0003AS!!F)\u000b\u0005I#\u0011A\u00023p[\u0006Lg.\u0003\u0002U!\nyA)\u001a9f]\u0012,gnY=Fm\u0016tG\u000f\u000b\u0002G-B\u0011qKX\u0007\u00021*\u0011\u0011LW\u0001\u0006iJ\u0012Wo\u001d\u0006\u00037r\u000b\u0001B[1wC\u0012,H-\u001a\u0006\u0002;\u0006\u0011a\u000e\\\u0005\u0003?b\u0013Q#\u00117m_^\u001cuN\\2veJ,g\u000e^#wK:$8\u000f\u000b\u0002GCB\u0011qKY\u0005\u0003Gb\u0013\u0011bU;cg\u000e\u0014\u0018NY3\t\u000b\u0015\u0004A\u0011\u00024\u00029%\u001cX\u000b\u001d3bi\u0016\u001c\u0015-^:fI\nK\b\u000b[1tKJ+7\u000f^1siR\u0019qM\u001b9\u0011\u00055A\u0017BA5\u000f\u0005\u001d\u0011un\u001c7fC:DQa\u001b3A\u00021\f\u0001b\u001c:jO&t\u0017\r\u001c\t\u0003[:l\u0011!U\u0005\u0003_F\u0013!\u0002R3qK:$WM\\2z\u0011\u0015\tH\r1\u0001m\u0003\u001d)\b\u000fZ1uK\u0012D#\u0001A:\u0011\u0005Q<X\"A;\u000b\u0005Y\u0004\u0015AC:uKJ,w\u000e^=qK&\u0011\u00010\u001e\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class DependencyLoggingEventHandler
implements EventListening,
Logging {
    private final XLReleaseEventBus eventBus;
    private final ActivityLogRepository activityLogRepository;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @PostConstruct
    public void postConstruct() {
        EventListening.postConstruct$((EventListening)this);
    }

    @PreDestroy
    public void preDestroy() {
        EventListening.preDestroy$((EventListening)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyLoggingEventHandler dependencyLoggingEventHandler = this;
        synchronized (dependencyLoggingEventHandler) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Subscribe
    @AllowConcurrentEvents
    public void onDependencyEvent(DependencyEvent dependencyEvent) {
        boolean bl = false;
        DependencyUpdatedEvent dependencyUpdatedEvent = null;
        DependencyEvent dependencyEvent2 = dependencyEvent;
        if (dependencyEvent2 instanceof DependencyCreatedEvent) {
            DependencyCreatedEvent dependencyCreatedEvent = (DependencyCreatedEvent)dependencyEvent2;
            Dependency dependency = dependencyCreatedEvent.dependency();
            this.activityLogRepository.log(Ids.releaseIdFrom((String)dependency.getId()), ReleaseActivity.DEPENDENCY_CREATED.create(dependency.getGateTask().getTitle(), dependency.getTargetDisplayPath()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (dependencyEvent2 instanceof DependencyUpdatedEvent) {
            Dependency updated;
            bl = true;
            dependencyUpdatedEvent = (DependencyUpdatedEvent)dependencyEvent2;
            Dependency original = dependencyUpdatedEvent.original();
            if (this.isUpdateCausedByPhaseRestart(original, updated = dependencyUpdatedEvent.updated())) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            Dependency original = dependencyUpdatedEvent.original();
            Dependency updated = dependencyUpdatedEvent.updated();
            this.activityLogRepository.log(Ids.releaseIdFrom((String)updated.getId()), ReleaseActivity.DEPENDENCY_UPDATED.create(updated.getGateTask().getTitle(), original.getTargetDisplayPath(), updated.getTargetDisplayPath()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (dependencyEvent2 instanceof DependencyDeletedEvent) {
            DependencyDeletedEvent dependencyDeletedEvent = (DependencyDeletedEvent)dependencyEvent2;
            Dependency dependency = dependencyDeletedEvent.dependency();
            this.activityLogRepository.log(Ids.releaseIdFrom((String)dependency.getId()), ReleaseActivity.DEPENDENCY_DELETED.create(dependency.getGateTask().getTitle(), dependency.getTargetDisplayPath()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Event ", " not traced into activity logs"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dependencyEvent2})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isUpdateCausedByPhaseRestart(Dependency original, Dependency updated) {
        Tuple2 tuple2 = new Tuple2((Object)DependencyLoggingEventHandler.targetTaskId$1(original), (Object)DependencyLoggingEventHandler.targetTaskId$1(updated));
        if (tuple2 == null) return false;
        Option option = (Option)tuple2._1();
        Option option2 = (Option)tuple2._2();
        if (!(option instanceof Some)) return false;
        Some some = (Some)option;
        String originalId = (String)some.value();
        if (!(option2 instanceof Some)) return false;
        Some some2 = (Some)option2;
        String updatedId = (String)some2.value();
        String originalPhaseName = Ids.getName((String)Ids.phaseIdFrom((String)originalId));
        String updatedPhaseName = Ids.getName((String)Ids.phaseIdFrom((String)updatedId));
        String string = originalPhaseName;
        String string2 = updatedPhaseName;
        if (string == null) {
            if (string2 == null) return false;
        } else if (string.equals(string2)) return false;
        String string3 = originalId.replace(originalPhaseName, updatedPhaseName);
        String string4 = updatedId;
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$isUpdateCausedByPhaseRestart$2(String x$1) {
        return Ids.isTaskId((String)x$1);
    }

    private static final Option targetTaskId$1(Dependency d) {
        return Option$.MODULE$.apply((Object)d.getTarget()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DependencyLoggingEventHandler.$anonfun$isUpdateCausedByPhaseRestart$2(x$1)));
    }

    @Autowired
    public DependencyLoggingEventHandler(XLReleaseEventBus eventBus, ActivityLogRepository activityLogRepository) {
        this.eventBus = eventBus;
        this.activityLogRepository = activityLogRepository;
        EventListening.$init$((EventListening)this);
        Logging.$init$((Logging)this);
    }
}

