/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.HttpClientHolder;
import com.xebialabs.deployit.booter.remote.client.ClientXStreamReaderWriter;
import com.xebialabs.deployit.booter.remote.resteasy.DeployitClientException;
import com.xebialabs.deployit.booter.remote.service.StreamingImportingService;
import com.xebialabs.deployit.core.api.ConfigurationService;
import com.xebialabs.deployit.engine.api.ControlService;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.InspectionService;
import com.xebialabs.deployit.engine.api.MetadataService;
import com.xebialabs.deployit.engine.api.PackageService;
import com.xebialabs.deployit.engine.api.PermissionService;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.ServerService;
import com.xebialabs.deployit.engine.api.TaskBlockService;
import com.xebialabs.deployit.engine.api.TaskService;
import com.xebialabs.deployit.engine.api.UserService;
import com.xebialabs.xltype.serialization.xml.StreamXmlReaderWriter;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Proxies {
    private final Map<Class<?>, Object> registeredProxies = new HashMap();
    private final HttpClientHolder httpClientHolder;
    private final BooterConfig booterConfig;
    private final ResteasyClient client;
    private static final Logger logger = LoggerFactory.getLogger(Proxies.class);

    @Deprecated
    public Proxies(DeployitCommunicator communicator) {
        this(communicator.getHttpClientHolder(), communicator.getConfig());
    }

    public Proxies(HttpClientHolder httpClientHolder, BooterConfig config) {
        this.httpClientHolder = httpClientHolder;
        this.booterConfig = config;
        this.client = new ResteasyClientBuilder().httpEngine(httpClientHolder.createClientHttpEngine()).providerFactory(new ResteasyProviderFactory(ResteasyProviderFactory.getInstance())).register((Object)new ClientXStreamReaderWriter(config)).register((Object)new StreamXmlReaderWriter()).build();
        this.init(config);
    }

    private void init(BooterConfig config) {
        for (Class<?> clazz : Proxies.allProxies()) {
            this.registerProxy(config.getUrl(), clazz);
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public void registerProxy(String url, Class<?> clazz) {
        logger.debug("Registering Proxy: {}", clazz);
        this.registeredProxies.put(clazz, this.wrap(clazz, this.client.target(url).proxy(clazz)));
    }

    private Object wrap(Class<?> clazz, Object proxy) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(proxy);
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)new BadRequestExceptionHandler(invocationHandler, this.booterConfig));
    }

    private static Iterable<Class<?>> allProxies() {
        ArrayList classes = new ArrayList();
        Collections.addAll(classes, ServerService.class, MetadataService.class, RepositoryService.class, ControlService.class, DeploymentService.class, InspectionService.class, PackageService.class, ConfigurationService.class, PermissionService.class, RoleService.class, TaskService.class, TaskBlockService.class, UserService.class);
        return classes;
    }

    public <T> T getProxyInstance(Class<T> clazz) {
        return (T)this.registeredProxies.get(clazz);
    }

    public ServerService getServerService() {
        return this.getProxyInstance(ServerService.class);
    }

    public MetadataService getMetadataService() {
        return this.getProxyInstance(MetadataService.class);
    }

    public RepositoryService getRepositoryService() {
        return this.getProxyInstance(RepositoryService.class);
    }

    public ControlService getControlService() {
        return this.getProxyInstance(ControlService.class);
    }

    public DeploymentService getDeploymentService() {
        return this.getProxyInstance(DeploymentService.class);
    }

    public InspectionService getInspectionService() {
        return this.getProxyInstance(InspectionService.class);
    }

    public PackageService getPackageService() {
        return new StreamingImportingService(this.httpClientHolder, this.booterConfig, this);
    }

    public PermissionService getPermissionService() {
        return this.getProxyInstance(PermissionService.class);
    }

    public RoleService getRoleService() {
        return this.getProxyInstance(RoleService.class);
    }

    public TaskService getTaskService() {
        return this.getProxyInstance(TaskService.class);
    }

    public TaskBlockService getTaskBlockService() {
        return this.getProxyInstance(TaskBlockService.class);
    }

    public UserService getUserService() {
        return this.getProxyInstance(UserService.class);
    }

    public static Proxies reinitialize(Proxies oldProxies, HttpClientHolder httpClientHolder, BooterConfig config) {
        Proxies newProxies = new Proxies(httpClientHolder, config);
        if (oldProxies == null) {
            return newProxies;
        }
        for (Class<?> proxyClass : oldProxies.registeredProxies.keySet()) {
            if (newProxies.registeredProxies.containsKey(proxyClass)) continue;
            newProxies.registerProxy(config.getUrl(), proxyClass);
        }
        return newProxies;
    }

    private static class BadRequestExceptionHandler
    implements InvocationHandler {
        private final InvocationHandler invocationHandler;
        private final BooterConfig booterConfig;

        public BadRequestExceptionHandler(InvocationHandler invocationHandler, BooterConfig booterConfig) {
            this.invocationHandler = invocationHandler;
            this.booterConfig = booterConfig;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.invocationHandler.invoke(proxy, method, args);
            }
            catch (BadRequestException bre) {
                logger.debug("Caught a BadRequestException with an entity");
                XStream xStream = XStreamReaderWriter.getConfiguredXStream();
                MapBackedDataHolder dataHolder = new MapBackedDataHolder();
                dataHolder.put((Object)"BOOTER_CONFIG", (Object)this.booterConfig.getKey());
                Object o = xStream.unmarshal(XStreamReaderWriter.HIERARCHICAL_STREAM_DRIVER.createReader((InputStream)bre.getResponse().readEntity(InputStream.class)), null, (DataHolder)dataHolder);
                if (method.getReturnType().isInstance(o)) {
                    return o;
                }
                throw new DeployitClientException(o, bre.getResponse().getStatus());
            }
        }
    }
}

