/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.repository.ActivityLogRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import java.util.ArrayList;
import java.util.List;

public class JcrActivityLogRepository
implements ActivityLogRepository {
    public static final String ACTIVITY_LOGS_DIR = "Applications/ActivityLogs";
    private CiIdService ciIdService;
    private RepositoryService repositoryService;

    public JcrActivityLogRepository(CiIdService ciIdService, RepositoryService repositoryService) {
        this.ciIdService = ciIdService;
        this.repositoryService = repositoryService;
    }

    public void log(String releaseId, List<ActivityLogEntry> activityLogEntries, String username) {
        String releasesActivityLogsDirectoryPath = this.getActivityLogsDirectoryPath(releaseId);
        List<String> logsIds = this.getUniqueIds(releasesActivityLogsDirectoryPath, activityLogEntries.size());
        for (int i = 0; i < activityLogEntries.size(); ++i) {
            ActivityLogEntry activityLogEntry = activityLogEntries.get(i);
            activityLogEntry.setId(logsIds.get(i));
            activityLogEntry.setUsername(username);
        }
        this.ensureDirectoriesExist(releasesActivityLogsDirectoryPath);
        this.repositoryService.create((ConfigurationItem[])activityLogEntries.toArray(new ActivityLogEntry[activityLogEntries.size()]));
    }

    public List<ActivityLogEntry> findAllLogsOf(String releaseId) {
        SearchParameters parameters = new SearchParameters();
        parameters.setParent(this.getActivityLogsDirectoryPath(releaseId));
        return this.repositoryService.listEntities(parameters);
    }

    public void deleteLogsOf(String releaseId) {
        String releaseDirectoryPath = this.getActivityLogsDirectoryPath(releaseId);
        this.repositoryService.delete(new String[]{releaseDirectoryPath});
    }

    public void move(String fromReleaseId, String toReleaseId) {
        ChangeSet changeSet = new ChangeSet();
        String oldActivityLogsPath = this.getActivityLogsDirectoryPath(fromReleaseId);
        String newActivityLogsPath = this.getActivityLogsDirectoryPath(toReleaseId);
        this.ensureDirectoriesExist(oldActivityLogsPath);
        this.ensureDirectoriesExist(Ids.getParentId((String)newActivityLogsPath));
        changeSet.move(oldActivityLogsPath, newActivityLogsPath);
        this.repositoryService.execute(changeSet);
    }

    private void ensureDirectoriesExist(String releaseDirectoryPath) {
        List<Directory> directoriesToCreate = this.getActivityLogDirectoriesToCreate(releaseDirectoryPath);
        if (!directoriesToCreate.isEmpty()) {
            this.repositoryService.createCollection(directoriesToCreate);
        }
    }

    private List<Directory> getActivityLogDirectoriesToCreate(String releaseDirectoryPath) {
        ArrayList<Directory> directoriesToCreate = new ArrayList<Directory>();
        String directoryId = releaseDirectoryPath;
        while (!Ids.isRoot((String)directoryId) && !this.repositoryService.exists(directoryId)) {
            directoriesToCreate.add((Directory)Type.valueOf(Directory.class).getDescriptor().newInstance(directoryId));
            directoryId = Ids.getParentId((String)directoryId);
        }
        return directoriesToCreate;
    }

    private String getActivityLogsDirectoryPath(String releaseId) {
        return "Applications/ActivityLogs/" + Ids.releasePathInRootFolder((String)releaseId);
    }

    private List<String> getUniqueIds(String parentId, int length) {
        ArrayList ids = Lists.newArrayList();
        Type activityLogType = Type.valueOf(ActivityLogEntry.class);
        while (length-- > 0) {
            String candidateId;
            while (ids.contains(candidateId = this.ciIdService.getUniqueId(activityLogType, parentId))) {
            }
            ids.add(candidateId);
        }
        return ids;
    }
}

