/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.authentication;

import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.UserProfileService;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class LoginPermissionVoter
implements AccessDecisionVoter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(LoginPermissionVoter.class);
    private UserProfileService userProfileService;

    @Autowired
    public LoginPermissionVoter(UserProfileService userProfileService) {
        this.userProfileService = userProfileService;
    }

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        String username = authentication.getName();
        logger.debug("Checking login permission for [{}]", (Object)username);
        this.userProfileService.ensureCreated(username);
        if (XLReleasePermissions.isAdmin((String)username)) {
            return 1;
        }
        UserProfile userProfile = this.userProfileService.findByUsername(username);
        if (userProfile != null && userProfile.isLoginAllowed()) {
            logger.debug("User [{}] is authorized for login", (Object)username);
            Object details = authentication.getDetails();
            String realUserName = userProfile.getName();
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)realUserName, authentication.getCredentials(), authentication.getAuthorities());
            token.setDetails(details);
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
            return 1;
        }
        logger.error("User [{}] is not authorized for login", (Object)username);
        return -1;
    }
}

