/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.actors.cluster.downing;

import akka.actor.Address;
import akka.actor.Props;
import akka.cluster.Member;
import com.xebialabs.xlplatform.hotstandby.NodeState$;
import com.xebialabs.xlrelease.actors.cluster.downing.AutoDowning$;
import com.xebialabs.xlrelease.actors.cluster.downing.LeaderAutoDowningActor;
import com.xebialabs.xlrelease.actors.cluster.downing.LeaderAutoDowningActor$DownReachable$;
import com.xebialabs.xlrelease.actors.cluster.downing.LeaderAutoDowningActor$DownUnreachable$;
import com.xebialabs.xlrelease.actors.cluster.downing.MajorityLeaderAutoDowning$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%<Q!\u0001\u0002\t\u0002=\t\u0011$T1k_JLG/\u001f'fC\u0012,'/Q;u_\u0012{wO\\5oO*\u00111\u0001B\u0001\bI><h.\u001b8h\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0005\u001dA\u0011AB1di>\u00148O\u0003\u0002\n\u0015\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u0001\"\u0001E\t\u000e\u0003\t1QA\u0005\u0002\t\u0002M\u0011\u0011$T1k_JLG/\u001f'fC\u0012,'/Q;u_\u0012{wO\\5oON\u0011\u0011\u0003\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000bm\tB\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005y\u0001\"\u0002\u0010\u0012\t\u0003y\u0012!\u00029s_B\u001cHc\u0001\u0011)eA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0006C\u000e$xN\u001d\u0006\u0002K\u0005!\u0011m[6b\u0013\t9#EA\u0003Qe>\u00048\u000fC\u0003*;\u0001\u0007!&A\u0006ti\u0006\u0014G.Z!gi\u0016\u0014\bCA\u00161\u001b\u0005a#BA\u0017/\u0003!!WO]1uS>t'BA\u0018\u0017\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003c1\u0012aBR5oSR,G)\u001e:bi&|g\u000eC\u00034;\u0001\u0007!&A\te_^t'+Z7pm\u0006dW*\u0019:hS:4AA\u0005\u0002\u0001kM\u0011AG\u000e\t\u0003!]J!\u0001\u000f\u0002\u0003-1+\u0017\rZ3s\u0003V$x\u000eR8x]&tw-Q2u_JD\u0011\"\u000b\u001b\u0003\u0002\u0003\u0006IA\u000b\u001e\n\u0005%:\u0004\"C\u001a5\u0005\u0003\u0005\u000b\u0011\u0002\u0016=\u0013\t\u0019t\u0007C\u0003\u001ci\u0011\u0005a\bF\u0002@\u0001\u0006\u0003\"\u0001\u0005\u001b\t\u000b%j\u0004\u0019\u0001\u0016\t\u000bMj\u0004\u0019\u0001\u0016\t\u000b\r#D\u0011\u0001#\u0002\r\u0011,7-\u001b3f)\u0005)\u0005C\u0001$Y\u001d\t9eK\u0004\u0002I+:\u0011\u0011\n\u0016\b\u0003\u0015Ns!a\u0013*\u000f\u00051\u000bfBA'Q\u001b\u0005q%BA(\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011BA,\u0003\u0003YaU-\u00193fe\u0006+Ho\u001c#po:LgnZ!di>\u0014\u0018BA-[\u0005)!un\u001e8BGRLwN\u001c\u0006\u0003/\nAQ\u0001\u0018\u001b\u0005Bu\u000bA\u0001Z8x]R\u0011a,\u0019\t\u0003+}K!\u0001\u0019\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006En\u0003\raY\u0001\u0005]>$W\r\u0005\u0002\"I&\u0011QM\t\u0002\b\u0003\u0012$'/Z:t\u0011\u00159G\u0007\"\u0011i\u0003!!wn\u001e8TK24G#\u00010")
public class MajorityLeaderAutoDowning
extends LeaderAutoDowningActor {
    public static Props props(FiniteDuration finiteDuration, FiniteDuration finiteDuration2) {
        return MajorityLeaderAutoDowning$.MODULE$.props(finiteDuration, finiteDuration2);
    }

    @Override
    public LeaderAutoDowningActor.DownAction decide() {
        Product product;
        int unreachableSize = this.unreachableMembers().size();
        int membersSize = this.members().size();
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deciding on current cluster state: ", " of ", " members unreachable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)unreachableSize), BoxesRunTime.boxToInteger((int)membersSize)})));
        if (unreachableSize * 2 == membersSize) {
            this.log().info("Both partitions are equal in size, break the tie by keeping the side with oldest member.");
            Address oldestMember = ((Member)this.members().head()).address();
            boolean oldestIsActive = this.isActiveMember(oldestMember);
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Oldest member [", "] detected as being ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldestMember, oldestIsActive ? "active" : "inactive"})));
            if (this.unreachable().apply((Object)oldestMember) && oldestIsActive) {
                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downing my partition [", "] - other partition has active oldest."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reachable()})));
                product = LeaderAutoDowningActor$DownReachable$.MODULE$;
            } else if (this.reachable().apply((Object)oldestMember) && !oldestIsActive) {
                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downing my partition [", "] - my partition has invalid oldest."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reachable()})));
                product = LeaderAutoDowningActor$DownReachable$.MODULE$;
            } else {
                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downing other partition [", "] - my partition has the current active oldest."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unreachable()})));
                product = LeaderAutoDowningActor$DownUnreachable$.MODULE$;
            }
        } else if (unreachableSize * 2 < membersSize) {
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"We are in majority, downing other partition [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unreachable()})));
            product = LeaderAutoDowningActor$DownUnreachable$.MODULE$;
        } else {
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"We are in minority, downing my partition [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reachable()})));
            product = LeaderAutoDowningActor$DownReachable$.MODULE$;
        }
        return product;
    }

    @Override
    public void down(Address node) {
        this.log().info("Downing member [{}].", (Object)node);
        this.cluster().down(node);
    }

    @Override
    public void downSelf() {
        this.log().info("Deactivating myself.");
        NodeState$.MODULE$.setActive(false);
        AutoDowning$.MODULE$.setDowning(true);
        this.log().info("Downing myself.");
        this.shutdownMember();
    }

    public MajorityLeaderAutoDowning(FiniteDuration stableAfter, FiniteDuration downRemovalMargin) {
        super(stableAfter, downRemovalMargin);
    }
}

