/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.variables.ListOfStringValueProviderConfiguration;
import com.xebialabs.xlrelease.domain.variables.ListStringVariable;
import com.xebialabs.xlrelease.domain.variables.SetStringVariable;
import com.xebialabs.xlrelease.domain.variables.ValueProvider;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ListOfStringValueProvider
implements ValueProvider<String, ListOfStringValueProviderConfiguration> {
    private VariableService variableService;

    @Autowired
    public ListOfStringValueProvider(VariableService variableService) {
        this.variableService = variableService;
    }

    @Override
    public Class<ListOfStringValueProviderConfiguration> getValueProviderConfigurationClass() {
        return ListOfStringValueProviderConfiguration.class;
    }

    @Override
    public Collection<String> possibleValues(ListOfStringValueProviderConfiguration config) {
        if (Strings.isBlank((String)config.getVariableKey())) {
            return config.getValues();
        }
        String key = VariableHelper.withoutVariableSyntax((String)config.getVariableKey());
        if (VariableHelper.isGlobalVariable((String)key)) {
            return this.getGlobalVariableValue(key, config);
        }
        return this.getReleaseVariableValue(key, config);
    }

    private Collection<String> getReleaseVariableValue(String key, ListOfStringValueProviderConfiguration config) {
        String releaseId = Ids.releaseIdFrom((String)config.getId());
        Variable variable = this.variableService.findByKey(key, releaseId);
        return this.ensureCollectionAndGetValue(variable, config, true, key);
    }

    private Collection<String> getGlobalVariableValue(String key, ListOfStringValueProviderConfiguration config) {
        Variable global = (Variable)this.variableService.findGlobalVariablesOrEmpty().getVariablesByKeys().get(key);
        return this.ensureCollectionAndGetValue(global, config, false, key);
    }

    private Collection<String> ensureCollectionAndGetValue(Variable variable, ListOfStringValueProviderConfiguration config, boolean failOnNull, String logVariableKey) {
        Collection variableValue;
        String listBoxKey = config.getVariable() == null ? null : config.getVariable().getKey();
        String releaseId = Ids.releaseIdFrom((String)config.getId());
        if (variable == null && failOnNull) {
            throw new IllegalArgumentException(String.format("Could not find variable %s in release %s to provide values for list box variable %s", VariableHelper.formatVariableIfNeeded((String)logVariableKey), releaseId, VariableHelper.formatVariableIfNeeded((String)listBoxKey)));
        }
        if (variable != null && !Type.valueOf(ListStringVariable.class).equals((Object)variable.getType()) && !Type.valueOf(SetStringVariable.class).equals((Object)variable.getType())) {
            throw new IllegalArgumentException(String.format("The variable %s specified in list box variable %s of release %s is not a list or set variable", VariableHelper.formatVariableIfNeeded((String)logVariableKey), VariableHelper.formatVariableIfNeeded((String)listBoxKey), releaseId));
        }
        Collection collection = variableValue = variable == null ? null : (Collection)variable.getValue();
        if (variableValue == null) {
            return Collections.emptyList();
        }
        return variableValue;
    }
}

